/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.jobmanager.internal;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.wiperdog.jobmanager.internal.AbstractGenericJob;
import org.wiperdog.rshell.api.RShell;
import org.wiperdog.rshell.api.RShellProvider;
import org.wiperdog.rshell.api.StreamInputProcessor;

public class CommanderJob
extends AbstractGenericJob {
    private RShellProvider commander;
    private String[] programargs;
    private StreamInputProcessor stdOutProcessor;
    private boolean bUseTmpfile = false;
    private String tmpFileSpec = "tmp/commandJobtmp%i";
    private static int iseq = 0;

    public void setCommander(RShellProvider csvc) {
        this.commander = csvc;
    }

    public void setProgramargs(String[] programargs) {
        this.programargs = programargs;
    }

    public void setUseTmpfile(boolean bUse) {
        this.bUseTmpfile = bUse;
    }

    public void setTmpFileSpec(String tmpfileSpec) {
        this.tmpFileSpec = tmpfileSpec;
    }

    private String getTmpfilePath() {
        return String.format(this.tmpFileSpec, iseq);
    }

    protected Object doJob(JobExecutionContext context) throws Throwable {
        JobDataMap data = context.getJobDetail().getJobDataMap();
        if (this.commander == null) {
            this.lastMsg = "no commander service has injected yet";
            this.logger.warn((Object)"no commander service has injected yet");
            return null;
        }
        Map defmap = this.commander.getRShellMap();
        RShell def = null;
        if (this.programargs == null || this.programargs.length <= 0) {
            this.lastMsg = "no programargs given";
            return null;
        }
        String jobName = this.programargs[0];
        def = (RShell)defmap.get(jobName);
        if (def != null) {
            Process proc = def.run(this.programargs);
            final long timeout = def.getTimeout();
            final Thread stopMe = Thread.currentThread();
            this.stdOutProcessor = StreamInputProcessor.start((InputStream)proc.getInputStream(), (String)(this.bUseTmpfile ? this.getTmpfilePath() : null), (int)((int)def.getXferLimit()));
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(timeout);
                        stopMe.interrupt();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }).start();
            try {
                proc.waitFor();
            }
            catch (InterruptedException e) {
                proc.destroy();
            }
            int rc = proc.exitValue();
            this.stdOutProcessor.stop();
            StringWriter stdoutData = new StringWriter();
            this.stdOutProcessor.writeTo((Writer)stdoutData);
            this.stdOutProcessor.clear();
            data.put("stdout", stdoutData.toString());
            this.lastMsg = stdoutData.toString();
            return rc == 0;
        }
        this.lastMsg = "no commander definition for '" + this.programargs[0] + "' found";
        return null;
    }
}

