/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.jobmanager.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.quartz.DateBuilder;
import org.quartz.InterruptableJob;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ListenerManager;
import org.quartz.Matcher;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.UnableToInterruptJobException;
import org.quartz.impl.matchers.KeyMatcher;
import org.wiperdog.jobmanager.JobClass;
import org.wiperdog.jobmanager.JobFacade;
import org.wiperdog.jobmanager.TriggerReceiver;
import org.wiperdog.jobmanager.internal.JobReceiverImpl;
import org.wiperdog.jobmanager.internal.JobResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobClassImpl
implements JobClass {
    private Logger logger = Logger.getLogger(JobClassImpl.class);
    public static final String KEY_PENDETAT = "pendetAt";
    private String name;
    private BlockingQueue<VetoedTriggerKey> vetoedQueue = new LinkedBlockingQueue<VetoedTriggerKey>();
    private Set<JobKey> running = new HashSet<JobKey>();
    private int numConcurrency;
    private long waitTime;
    private long maxRunTime;
    private static final String NULLNAME = "NULLNAME";
    private static final String NULLGROUP = "NULLGROUP";
    private static final Matcher<JobKey> NULLJOBMATCHER = KeyMatcher.keyEquals(new JobKey("NULLNAME", "NULLGROUP"));
    private JobFacade jobFacade;
    private final Scheduler scheduler;
    private static final String REASONKEY_CONCURRENCY = JobClassImpl.class.getName();
    private final List<JobKey> assignedList = new ArrayList<JobKey>();
    public static final String SUFFIX_CANCELJOB = "_cancel";

    public String toString() {
        List<Matcher<JobKey>> matcherlist = null;
        try {
            matcherlist = this.scheduler.getListenerManager().getJobListenerMatchers(this.name);
        }
        catch (SchedulerException e) {
            this.logger.info((Object)"failed to get matcher");
            this.logger.trace((Object)"", (Throwable)e);
        }
        String str = this.getClass().getSimpleName() + "(" + this.name + "), members : {";
        if (matcherlist != null) {
            for (Matcher<JobKey> keyMatcher : matcherlist) {
                str = str + keyMatcher.toString() + ",";
            }
        }
        str = str + "}";
        return str;
    }

    public JobClassImpl(JobFacade jf, Scheduler sched, String name) throws SchedulerException {
        this.logger.trace((Object)("JobClass.JobClass(" + sched.toString() + "," + name + ")"));
        this.name = name;
        this.jobFacade = jf;
        this.scheduler = sched;
        this.numConcurrency = 1;
        this.maxRunTime = Long.MAX_VALUE;
        this.waitTime = Long.MAX_VALUE;
        ListenerManager lm = sched.getListenerManager();
        lm.addJobListener((JobListener)new ConcurrencyJobListener(), NULLJOBMATCHER);
    }

    public JobClassImpl(JobClassImpl src) throws SchedulerException {
        this.name = src.name;
        this.scheduler = src.scheduler;
        src.vetoedQueue.drainTo(this.vetoedQueue);
        this.running.addAll(src.running);
        this.numConcurrency = src.numConcurrency;
        this.waitTime = src.waitTime;
        this.maxRunTime = src.maxRunTime;
        this.assignedList.addAll(src.assignedList);
        ListenerManager lm = this.scheduler.getListenerManager();
        lm.removeJobListener(this.name);
        lm.addJobListener((JobListener)new ConcurrencyJobListener(), NULLJOBMATCHER);
    }

    @Override
    public void close() {
        try {
            ListenerManager lm = this.scheduler.getListenerManager();
            lm.removeJobListener(this.name);
        }
        catch (SchedulerException e) {
            this.logger.info((Object)("failed to close JobClass: " + this.name));
            this.logger.trace((Object)"", (Throwable)e);
        }
    }

    @Override
    public void setMaxWaitTime(long timeInMillis) {
        this.logger.trace((Object)("JobClass.setWaitTime(" + timeInMillis + ")"));
        this.waitTime = timeInMillis < 0L ? Long.MAX_VALUE : timeInMillis;
    }

    @Override
    public void setMaxRunTime(long timeInMillis) {
        this.logger.trace((Object)("JobClass.setMaxRunTime(" + timeInMillis + ")"));
        this.maxRunTime = timeInMillis < 0L ? Long.MAX_VALUE : timeInMillis;
    }

    @Override
    public void setConcurrency(int num) {
        this.logger.trace((Object)("JobClass.setNumConcurrency(" + num + ")"));
        this.numConcurrency = num;
    }

    @Override
    public void addJob(JobKey key) {
        this.logger.trace((Object)("JobClass.addJob(" + key.toString() + ")"));
        try {
            this.assignedList.add(key);
            this.scheduler.getListenerManager().addJobListenerMatcher(this.name, KeyMatcher.keyEquals(key));
        }
        catch (SchedulerException e) {
            this.logger.info((Object)("failed to add job: " + key.toString()));
            this.logger.trace((Object)"", (Throwable)e);
        }
    }

    @Override
    public void deleteJob(JobKey key) {
        this.logger.trace((Object)("JobClass.deleteJob(" + key.toString() + ")"));
        try {
            this.scheduler.getListenerManager().removeJobListenerMatcher(this.name, KeyMatcher.keyEquals(key));
            this.assignedList.remove(key);
        }
        catch (SchedulerException e) {
            this.logger.info((Object)("failed to delete job: " + key.toString()));
            this.logger.trace((Object)"", (Throwable)e);
        }
    }

    @Override
    public List<JobKey> getAssignedList() {
        this.logger.trace((Object)"JobClassImpl.getJobList()");
        return this.assignedList;
    }

    @Override
    public String getName() {
        this.logger.trace((Object)"JobClass.getName()");
        return this.name;
    }

    private void expiredWaitTime(VetoedTriggerKey vetoedkey) {
        this.logger.info((Object)("waitTime exceeded for job:" + vetoedkey.getKey().toString() + ", giving up"));
        JobReceiverImpl receiver = (JobReceiverImpl)this.jobFacade.getJobReceiver(vetoedkey.getKey().getName());
        if (receiver != null) {
            receiver.putEvent(vetoedkey.getKey().getName(), TriggerReceiver.TRIGGEREVENT.MISFIRED, new Date());
            int ilast = receiver.resultCount() - 1;
            if (ilast >= 0) {
                JobResultImpl result = (JobResultImpl)receiver.getJobResult(ilast);
                result.setWaitexpiredAt(new Date());
            }
        }
    }

    private void vetoedCancelled(VetoedTriggerKey vetoedkey) {
        this.logger.info((Object)("cancelled wainting job:" + vetoedkey.getKey().toString() + ""));
        JobReceiverImpl receiver = (JobReceiverImpl)this.jobFacade.getJobReceiver(vetoedkey.getKey().getName());
        receiver.putEvent(vetoedkey.getKey().getName(), TriggerReceiver.TRIGGEREVENT.MISFIRED, new Date());
        int ilast = receiver.resultCount() - 1;
        if (ilast >= 0) {
            JobResultImpl result = (JobResultImpl)receiver.getJobResult(ilast);
            result.setWaitexpiredAt(new Date());
        }
    }

    @Override
    public int getConcurrency() {
        return this.numConcurrency;
    }

    @Override
    public long getMaxWaitTime() {
        return this.waitTime;
    }

    @Override
    public long getMaxRunTime() {
        return this.maxRunTime;
    }

    public Object[] getVetoedQueue() {
        return this.vetoedQueue.toArray();
    }

    public synchronized void removeAllExpiredJob() {
        LinkedBlockingQueue<VetoedTriggerKey> tmpqueue = new LinkedBlockingQueue<VetoedTriggerKey>();
        while (!this.vetoedQueue.isEmpty()) {
            try {
                VetoedTriggerKey vetoedkey = this.vetoedQueue.take();
                if (new Date().getTime() - vetoedkey.getVetoedDate().getTime() > this.waitTime) {
                    this.expiredWaitTime(vetoedkey);
                    continue;
                }
                tmpqueue.add(vetoedkey);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.vetoedQueue.clear();
        this.vetoedQueue.addAll(tmpqueue);
    }

    @Override
    public synchronized void cancelSpecifiedVetoedJob(JobKey jk) {
        LinkedBlockingQueue<VetoedTriggerKey> tmpqueue = new LinkedBlockingQueue<VetoedTriggerKey>();
        while (!this.vetoedQueue.isEmpty()) {
            try {
                VetoedTriggerKey vetoedkey = this.vetoedQueue.take();
                if (vetoedkey.getJobDetail().getKey().equals(jk)) {
                    this.vetoedCancelled(vetoedkey);
                    continue;
                }
                tmpqueue.add(vetoedkey);
            }
            catch (InterruptedException e) {}
        }
        this.vetoedQueue.clear();
        this.vetoedQueue.addAll(tmpqueue);
    }

    @Override
    public int getCurrentRunningCount() {
        return this.running.size();
    }

    @Override
    public List<JobKey> getVetoedList() {
        ArrayList<JobKey> rlist = new ArrayList<JobKey>();
        int qsize = this.vetoedQueue.size();
        VetoedTriggerKey[] varr = new VetoedTriggerKey[qsize];
        this.vetoedQueue.toArray(varr);
        for (int i = 0; i < varr.length; ++i) {
            JobDetail job = null;
            try {
                job = varr[i].getJobDetail();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (job == null) continue;
            rlist.add(job.getKey());
        }
        return rlist;
    }

    @Override
    public boolean isJobVetoed(JobKey jobkey) {
        List<JobKey> klist = this.getVetoedList();
        try {
            for (JobKey k : klist) {
                if (!k.equals(jobkey)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private class ConcurrencyJobListener
    implements JobListener {
        public ConcurrencyJobListener() {
            JobClassImpl.this.logger.trace((Object)"ConcurrencyJobListener.ConcurrencyJobListener()");
        }

        public String getName() {
            JobClassImpl.this.logger.trace((Object)("ConcurrencyJobListener.getName() - '" + JobClassImpl.this.name + "'"));
            return JobClassImpl.this.name;
        }

        public synchronized void jobToBeExecuted(JobExecutionContext context) {
            JobClassImpl.this.logger.trace((Object)"ConcurrencyJobListener.jobToBeExecuted()");
            Trigger trigger = context.getTrigger();
            JobKey key = trigger.getJobKey();
            JobDetail detail = context.getJobDetail();
            JobDataMap datamap = detail.getJobDataMap();
            JobClassImpl.this.logger.trace((Object)("    job = " + key.getName()));
            HashSet<String> reasons = (HashSet<String>)datamap.get("prohibit");
            if (reasons == null) {
                reasons = new HashSet<String>();
                datamap.put("prohibit", (Object)reasons);
            }
            if (JobClassImpl.this.running.size() >= JobClassImpl.this.numConcurrency || !JobClassImpl.this.vetoedQueue.isEmpty() && trigger.getPriority() <= 5) {
                VetoedTriggerKey vk = new VetoedTriggerKey(trigger.getKey(), detail);
                JobClassImpl.this.logger.trace((Object)("offering into vetoedQueue, size:" + JobClassImpl.this.vetoedQueue.size()));
                JobClassImpl.this.vetoedQueue.offer(vk);
                reasons.add(REASONKEY_CONCURRENCY);
                JobResultImpl jresult = (JobResultImpl)datamap.get("jobresult");
                jresult = jresult == null ? new JobResultImpl(trigger.getJobKey().getName()) : new JobResultImpl(jresult);
                datamap.put("jobresult", (Object)jresult);
                jresult.setPendedAt(vk.getVetoedDate());
                jresult.putData("pendingclass", JobClassImpl.this.name);
                JobClassImpl.this.logger.debug((Object)("ConcurrencyJobListener: numConcurrency exceeded for job: " + trigger.getJobKey().toString()));
                return;
            }
            JobClassImpl.this.running.add(key);
            reasons.remove(REASONKEY_CONCURRENCY);
            if (JobClassImpl.this.maxRunTime != Long.MAX_VALUE && JobClassImpl.this.maxRunTime > 0L) {
                JobClassImpl.this.logger.trace((Object)"insert 'RUNTIMEOVER kill' job");
                JobDetail cancelJob = JobBuilder.newJob(RuntimeLimitterJob.class).withIdentity(key.getName() + JobClassImpl.SUFFIX_CANCELJOB, key.getGroup() + JobClassImpl.SUFFIX_CANCELJOB).build();
                cancelJob.getJobDataMap().put("jobkey", (Object)key);
                Trigger cancelTrigger = TriggerBuilder.newTrigger().withIdentity(key.getName() + JobClassImpl.SUFFIX_CANCELJOB, key.getGroup() + JobClassImpl.SUFFIX_CANCELJOB).startAt(DateBuilder.futureDate((int)JobClassImpl.this.maxRunTime, DateBuilder.IntervalUnit.MILLISECOND)).forJob(cancelJob).build();
                try {
                    context.getScheduler().scheduleJob(cancelJob, cancelTrigger);
                }
                catch (SchedulerException e) {
                    JobClassImpl.this.logger.debug((Object)"failed to insert 'RUNTIMEOVER kill' job");
                }
            }
        }

        public void jobExecutionVetoed(JobExecutionContext context) {
            JobClassImpl.this.logger.trace((Object)"ConcurrencyJobListener.jobExecutionVetoed()");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
            block25: {
                JobClassImpl.this.logger.trace((Object)"ConcurrencyJobListener.jobWasExecuted()");
                Scheduler sched = context.getScheduler();
                try {
                    sched.pauseAll();
                }
                catch (SchedulerException e1) {
                    JobClassImpl.this.logger.debug((Object)"scheduler.pauseAll() failed");
                    JobClassImpl.this.logger.trace((Object)"", (Throwable)e1);
                }
                try {
                    sched.deleteJob(JobKey.jobKey(context.getJobDetail().getKey().getName() + JobClassImpl.SUFFIX_CANCELJOB, context.getJobDetail().getKey().getGroup() + JobClassImpl.SUFFIX_CANCELJOB));
                }
                catch (SchedulerException e) {
                    JobClassImpl.this.logger.debug((Object)("failed to delete RuntimeLimitter job for (" + context.getJobDetail().getKey().getName() + "), may already removed"));
                }
                try {
                    VetoedTriggerKey vetoedkey;
                    if (!JobClassImpl.this.running.remove(context.getTrigger().getJobKey())) break block25;
                    while ((vetoedkey = (VetoedTriggerKey)JobClassImpl.this.vetoedQueue.poll()) != null) {
                        try {
                            JobDetail job = vetoedkey.getJobDetail();
                            if (vetoedkey.canProceed(JobClassImpl.this.waitTime)) {
                                Trigger rft;
                                JobClassImpl.this.logger.trace((Object)("re-launching the waiting job: " + vetoedkey.getJobDetail().getKey().toString() + ":" + vetoedkey.getKey().toString()));
                                if (sched.checkExists(job.getKey())) {
                                    Trigger oldTrigger = sched.getTrigger(vetoedkey.getKey());
                                    Trigger rft2 = TriggerBuilder.newTrigger().startNow().withPriority(6).forJob(job).build();
                                    if (oldTrigger != null && !oldTrigger.mayFireAgain()) {
                                        sched.rescheduleJob(vetoedkey.getKey(), rft2);
                                        JobClassImpl.this.logger.trace((Object)("rescheduleJob(" + vetoedkey.getKey().toString() + ":" + rft2.getKey().toString()));
                                    } else {
                                        sched.scheduleJob(rft2);
                                        JobClassImpl.this.logger.trace((Object)("scheduleJob(" + job.getKey().toString() + ":" + rft2.getKey().toString()));
                                    }
                                } else {
                                    rft = TriggerBuilder.newTrigger().startNow().withPriority(6).forJob(job.getKey()).build();
                                    sched.scheduleJob(job, rft);
                                    JobClassImpl.this.logger.trace((Object)("scheduleJob(" + job.getKey().toString() + ":" + rft.getKey().toString()));
                                }
                                if (JobClassImpl.this.logger.isTraceEnabled()) {
                                    rft = sched.getTrigger(vetoedkey.getKey());
                                    JobClassImpl.this.logger.trace((Object)("trigger is updated for re-launch: " + vetoedkey.getKey().toString() + " { nextfiretime : " + rft.getNextFireTime() + ", previousfiretime : " + rft.getPreviousFireTime() + "}"));
                                }
                                break;
                            }
                            JobClassImpl.this.expiredWaitTime(vetoedkey);
                        }
                        catch (SchedulerException e) {
                            JobClassImpl.this.logger.info((Object)("failed to re-schedule vetoed job: " + vetoedkey.toString()));
                            JobClassImpl.this.logger.trace((Object)"", (Throwable)e);
                        }
                        catch (Throwable t) {
                            JobClassImpl.this.logger.info((Object)"Something has been thrown at post processing of job execution.", t);
                        }
                    }
                }
                catch (Throwable t) {
                    JobClassImpl.this.logger.info((Object)"Something has been thrown at post processing of job execution.", t);
                }
                finally {
                    try {
                        sched.resumeAll();
                    }
                    catch (SchedulerException e) {
                        JobClassImpl.this.logger.info((Object)"failed to resume scheduler");
                        JobClassImpl.this.logger.trace((Object)"", (Throwable)e);
                    }
                    JobClassImpl.this.logger.trace((Object)"schduler resumed");
                }
            }
        }
    }

    public static final class RuntimeLimitterJob
    implements InterruptableJob {
        private Logger logger = Logger.getLogger((String)"com.insight_tec.pi.jobmanager");
        public static final String KEY_JOBKEY = "jobkey";

        public RuntimeLimitterJob() {
            this.logger.trace((Object)"RuntimeLimitterJob.RuntimeLimitterJob()");
        }

        public void execute(JobExecutionContext context) throws JobExecutionException {
            this.logger.trace((Object)"RuntimeLimitterJob.execute()");
            JobKey jobkey = (JobKey)context.getMergedJobDataMap().get(KEY_JOBKEY);
            this.logger.debug((Object)("interrupting job(" + jobkey.getName() + ")"));
            try {
                context.getScheduler().interrupt(jobkey);
            }
            catch (UnableToInterruptJobException e) {
                this.logger.debug((Object)"\terror on interrupt:", (Throwable)e);
            }
            catch (SchedulerException e) {
                this.logger.debug((Object)"\terror on interrupt:", (Throwable)e);
            }
        }

        public void interrupt() throws UnableToInterruptJobException {
            this.logger.trace((Object)"RuntimeLimitterJob.interrupt()");
        }
    }

    private static class VetoedTriggerKey {
        private final Date vetoedAt;
        private final TriggerKey triggerkey;
        private final JobDetail jobDetail;
        private Logger logger = Logger.getLogger(VetoedTriggerKey.class);

        public VetoedTriggerKey(TriggerKey key, JobDetail job) {
            this.logger.trace((Object)("VetoedTriggerKey.VetoedTriggerKey(" + key.toString() + ")"));
            this.triggerkey = key;
            this.jobDetail = job;
            this.vetoedAt = new Date();
        }

        public VetoedTriggerKey(VetoedTriggerKey src) {
            this.vetoedAt = src.vetoedAt;
            this.triggerkey = src.triggerkey;
            this.jobDetail = src.jobDetail;
        }

        public TriggerKey getKey() {
            this.logger.trace((Object)"VetoedTriggerKey.getKey()");
            return this.triggerkey;
        }

        public JobDetail getJobDetail() {
            return this.jobDetail;
        }

        public boolean canProceed(long waitTimeMilli) {
            if (new Date().getTime() - this.vetoedAt.getTime() < waitTimeMilli) {
                this.logger.trace((Object)("VetoedTriggerKey.canProceed(" + waitTimeMilli + ") - true"));
                return true;
            }
            this.logger.trace((Object)("VetoedTriggerKey.canProceed(" + waitTimeMilli + ") - false"));
            return false;
        }

        public Date getVetoedDate() {
            return this.vetoedAt;
        }

        public String toString() {
            return "{ vetoed: '" + this.vetoedAt + "', trigger: '" + this.triggerkey.toString() + "', job: '" + this.jobDetail.getKey().toString() + "' }";
        }
    }
}

