/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.jobmanager.internal;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.wiperdog.jobmanager.JobResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobResultImpl
implements JobResult {
    private String name;
    private Date startedAt;
    private Date endedAt;
    private Date interruptedAt;
    private Date pendedAt;
    private Date waitexpiredAt;
    private Object result;
    private JobResult.JOBSTATUS status = JobResult.JOBSTATUS.NONE;
    private String message;
    private Map<String, Object> params = new HashMap<String, Object>();
    private Map<String, Object> data;

    public JobResultImpl(String name) {
        this.name = name;
    }

    public JobResultImpl(JobResultImpl src) {
        this.name = src.getName();
        this.startedAt = src.getStartedAt();
        this.endedAt = src.getEndedAt();
        this.interruptedAt = src.getInterruptedAt();
        this.pendedAt = src.getPendedAt();
        this.result = src.getResult();
        this.params.putAll(src.params);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Date getStartedAt() {
        return this.startedAt;
    }

    @Override
    public Date getInterruptedAt() {
        return this.interruptedAt;
    }

    @Override
    public Date getEndedAt() {
        return this.endedAt;
    }

    @Override
    public Date getPendedAt() {
        return this.pendedAt;
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public JobResult.JOBSTATUS getLastStatus() {
        return this.status;
    }

    @Override
    public Object getParam(String key) {
        return this.params.get(key);
    }

    public void setStartedAt(Date at) {
        this.startedAt = at;
    }

    public void setEndedAt(Date at) {
        this.status = JobResult.JOBSTATUS.EXECUTED;
        this.endedAt = at;
    }

    public void setInterruptedAt(Date at) {
        this.status = JobResult.JOBSTATUS.INTERRUPTED;
        this.interruptedAt = at;
    }

    public void setPendedAt(Date at) {
        this.pendedAt = at;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public void setWaitexpiredAt(Date at) {
        this.waitexpiredAt = at;
    }

    public void setLastStatus(JobResult.JOBSTATUS status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Map<String, Object> getData() {
        return this.data;
    }

    @Override
    public void putData(String key, Object value) {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        this.data.put(key, value);
    }

    @Override
    public Date getWaitexpiredAt() {
        return this.waitexpiredAt;
    }
}

