/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.jobmanager.internal;

import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.impl.StdSchedulerFactory;
import org.wiperdog.jobmanager.JobFacade;
import org.wiperdog.jobmanager.JobManagerException;
import org.wiperdog.jobmanager.dsl.Parser;
import org.wiperdog.jobmanager.internal.JobFacadeImpl;

public class Main {
    private Scheduler scheduler;
    private SchedulerFactory sf;
    private JobFacade jf;

    private void initSchedulerCore() {
        try {
            this.sf = new StdSchedulerFactory();
            this.scheduler = this.sf.getScheduler();
            this.jf = new JobFacadeImpl(this.scheduler);
        }
        catch (SchedulerException e) {
        }
        catch (JobManagerException jobManagerException) {
            // empty catch block
        }
    }

    private void finishSchedulerCore() {
        try {
            this.jf = null;
            this.scheduler.shutdown();
            this.scheduler = null;
            this.sf = null;
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    private void start(String path, long interval) {
        Parser parser = new Parser(this.jf, false);
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            String jdlpath = args[0];
            long waittime = 10000L;
            if (args.length > 1) {
                try {
                    waittime = Long.parseLong(args[1]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            new Main().start(jdlpath, waittime);
        }
    }
}

