/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.jobmanager.internal;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.wiperdog.jobmanager.internal.AbstractGenericJob;

@DisallowConcurrentExecution
public class ShellJob
extends AbstractGenericJob {
    public static final int DEF_MAX_DATA_SIZE = 4096;
    private String[] programargs;
    private Boolean bUseOut = false;
    private Boolean bUseErr = false;
    private int maxDataSize = 4096;

    public ShellJob() {
        this.logger.trace((Object)"ShellJob.ShellJob()");
    }

    private void close(Closeable s) {
        this.logger.trace((Object)("ShellJob.close(" + s.toString() + ")"));
        try {
            s.close();
        }
        catch (IOException e) {
            this.logger.info((Object)"failed to close closeable object");
            this.logger.trace((Object)e);
        }
    }

    private String getWorkingDirectory() {
        String wd = System.getProperty("felix.home");
        if (wd == null || wd.length() == 0) {
            wd = System.getProperty("user.dir");
        }
        return wd;
    }

    public void setProgramargs(String[] args) {
        this.programargs = args;
    }

    public void setUseOut(Boolean bUse) {
        this.bUseOut = bUse;
    }

    public void setUseErr(Boolean bUse) {
        this.bUseErr = bUse;
    }

    public void setMaxDataSize(Integer size) {
        this.maxDataSize = size;
    }

    /*
     * Loose catch block
     */
    protected Object doJob(JobExecutionContext context) throws Throwable {
        int r;
        OutputProcessor rerr;
        OutputProcessor rin;
        JobDataMap data;
        block8: {
            this.logger.trace((Object)"ShellJob.doJob()");
            data = context.getJobDetail().getJobDataMap();
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            if (!this.programargs[0].startsWith(".") && !this.programargs[0].startsWith("/")) {
                this.programargs[0] = this.getWorkingDirectory() + "/" + this.programargs[0];
            }
            builder.command(this.programargs);
            Process p = builder.start();
            rin = new OutputProcessor(p.getInputStream(), this.bUseOut);
            rin.start();
            rerr = new OutputProcessor(p.getErrorStream(), this.bUseErr);
            rerr.start();
            int rv = 1;
            r = 1;
            rv = p.waitFor();
            Object var11_9 = null;
            rin.stop();
            rerr.stop();
            this.close(p.getOutputStream());
            try {
                r = p.exitValue();
                break block8;
            }
            catch (IllegalThreadStateException e) {
                this.logger.debug((Object)"process is not exited yet");
            }
            {
                break block8;
                catch (InterruptedException e) {
                    this.logger.trace((Object)"interrupted, destroying process then rethrow");
                    p.destroy();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                rin.stop();
                rerr.stop();
                this.close(p.getOutputStream());
                try {
                    r = p.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    this.logger.debug((Object)"process is not exited yet");
                }
                this.logger.trace((Object)("exit value of process is :" + r));
                data.put("stdout", rin.getResult());
                data.put("stderr", rerr.getResult());
                data.put("exitcode", (Object)r);
                throw throwable;
            }
        }
        this.logger.trace((Object)("exit value of process is :" + r));
        data.put("stdout", rin.getResult());
        data.put("stderr", rerr.getResult());
        data.put("exitcode", (Object)r);
        return r == 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    private class OutputProcessor
    implements Runnable {
        private boolean bRun = true;
        private final InputStream is;
        private Thread me;
        private String result = "";
        private final boolean bHoldData;

        public OutputProcessor(InputStream in, boolean bHoldData) {
            ShellJob.this.logger.trace((Object)("OutputProcessor.OutputProcessor(" + in.toString() + ")"));
            this.is = in;
            this.bHoldData = bHoldData;
        }

        public void start() {
            ShellJob.this.logger.trace((Object)"OutputProcessor.start()");
            this.me = new Thread(this);
            this.me.start();
        }

        public void stop() {
            ShellJob.this.logger.trace((Object)"OutputProcessor.stop()");
            this.bRun = false;
            ShellJob.this.close(this.is);
        }

        public String getResult() {
            ShellJob.this.logger.trace((Object)"OutputProcessor.getResult()");
            return this.result;
        }

        public void run() {
            ShellJob.this.logger.trace((Object)"OutputProcessor.run()");
            InputStreamReader r = new InputStreamReader(this.is);
            BufferedReader br = new BufferedReader(r);
            int datasize = 0;
            while (this.bRun) {
                String strIn = null;
                try {
                    strIn = br.readLine();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (strIn == null) {
                    this.bRun = false;
                    continue;
                }
                if (!this.bHoldData) continue;
                String stringToAppend = strIn;
                if (datasize + strIn.length() + 1 > ShellJob.this.maxDataSize) {
                    if (strIn.length() > ShellJob.this.maxDataSize - datasize - 1) {
                        stringToAppend = strIn.substring(0, ShellJob.this.maxDataSize - datasize - 1);
                    }
                    this.bRun = false;
                }
                this.result = this.result + stringToAppend + "\n";
                datasize += stringToAppend.length() + 1;
            }
            ShellJob.this.close(r);
            ShellJob.this.close(br);
        }
    }
}

