/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.jobmanager.dsl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.apache.log4j.Logger;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.wiperdog.jobmanager.ConditionBoardException;
import org.wiperdog.jobmanager.JobClass;
import org.wiperdog.jobmanager.JobFacade;
import org.wiperdog.jobmanager.JobManagerException;
import org.wiperdog.jobmanager.JobNet;
import org.wiperdog.jobmanager.JobReceiver;
import org.wiperdog.jobmanager.RootJobReceiver;
import org.wiperdog.jobmanager.Terminal;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Parser {
    private static Logger logger = Logger.getLogger(Parser.class);
    private static final char ec = '\\';
    private Digester digester = new ParserDigester(logger);
    private final JobFacade jfacade;
    private static final String NODE_MEMBERJOB = "MemberJob";
    private static final String NODE_TOP = "JobDefinition";
    private static final String NODE_JOB = "Job";
    private static final String NODE_ARG = "Arg";
    private static final String NODE_TRIGGER = "Trigger";
    private static final String NODE_ASSIGNTRIGGER = "AssignTrigger";
    private static final String NODE_PSEUDO = "Pseudo";
    private static final String NODE_JOBNET = "JobNet";
    private static final String NODE_TERMINAL = "Terminal";
    private static final String NODE_JOBCLASS = "JobClass";
    private static final String NODE_OPERATOR = "Operator";
    private static final String NODE_PREDECESSOR = "Predecessor";
    private static final String NODE_DELAY = "Delay";
    private static final String NODE_SETJOBCLASS = "SetJobClass";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_FORJOBNAME = "forJobName";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_ENABLED = "enabled";
    private static final String ATTR_CLASS = "class";

    public static String[] splitCommandline(String commandLine) {
        String[] result = null;
        StringBuffer sb = new StringBuffer();
        char[] carr = commandLine.toCharArray();
        ArrayList<String> array = new ArrayList<String>();
        boolean escape = false;
        boolean dquoting = false;
        boolean squoting = false;
        for (int i = 0; i < carr.length; ++i) {
            if (escape) {
                if (carr[i] != '\'' && carr[i] != '\"' && carr[i] != ' ' && carr[i] != '\t') {
                    sb.append('\\');
                }
                if (carr[i] == '\\') {
                    escape = true;
                    continue;
                }
                sb.append(carr[i]);
                escape = false;
                continue;
            }
            if (carr[i] == '\\') {
                escape = true;
                continue;
            }
            if (carr[i] == '\"' && !squoting) {
                boolean bl = dquoting = !dquoting;
                if (dquoting) continue;
                array.add(sb.toString());
                sb = new StringBuffer();
                continue;
            }
            if (carr[i] == '\'' && !dquoting) {
                boolean bl = squoting = !squoting;
                if (squoting) continue;
                array.add(sb.toString());
                sb = new StringBuffer();
                continue;
            }
            if (!(carr[i] != ' ' && carr[i] != '\t' || squoting || dquoting)) {
                String strArg = sb.toString().trim();
                if (strArg.length() <= 0) continue;
                array.add(sb.toString());
                sb = new StringBuffer();
                continue;
            }
            sb.append(carr[i]);
        }
        if (sb.length() > 0) {
            array.add(sb.toString());
        }
        result = new String[array.size()];
        array.toArray(result);
        return result;
    }

    public Parser(JobFacade facade, boolean validate) {
        this.digester.setClassLoader(this.getClass().getClassLoader());
        this.jfacade = facade;
        this.digester.setValidating(validate);
        String path = NODE_TOP;
        this.digester.addObjectCreate(path, TopElement.class);
        this.digester.addSetProperties(path);
        path = "JobDefinition/Job";
        this.digester.addObjectCreate(path, JobElement.class);
        this.digester.addSetProperties(path);
        this.digester.addCallMethod(path + "/" + NODE_ARG, "addArg", 0);
        this.digester.addSetNext(path, "addChild");
        path = "JobDefinition/JobNet/Pseudo";
        this.digester.addObjectCreate(path, PseudoElement.class);
        this.digester.addSetProperties(path);
        this.digester.addSetNext(path, "addChild");
        path = "JobDefinition/Trigger";
        this.digester.addObjectCreate(path, TriggerElement.class);
        this.digester.addSetProperties(path);
        this.digester.addSetNext(path, "addChild");
        path = "JobDefinition/AssignTrigger";
        this.digester.addObjectCreate(path, AssignTriggerElement.class);
        this.digester.addSetProperties(path);
        this.digester.addSetNext(path, "addChild");
        path = "JobDefinition/JobNet";
        this.digester.addObjectCreate(path, JobNetElement.class);
        this.digester.addSetProperties(path);
        this.digester.addSetNext(path, "addChild");
        path = "JobDefinition/JobNet/Terminal";
        this.digester.addObjectCreate(path, TerminalElement.class);
        this.digester.addSetProperties(path);
        this.digester.addSetNext(path, "addChild");
        path = "*/Operator";
        this.digester.addObjectCreate(path, OperatorElement.class);
        this.digester.addSetProperties(path);
        this.digester.addSetNext(path, "addChild");
        path = "*/Predecessor";
        this.digester.addObjectCreate(path, PredecessorElement.class);
        this.digester.addSetProperties(path);
        this.digester.addSetNext(path, "addChild");
        path = "JobDefinition/JobClass";
        this.digester.addObjectCreate(path, JobClassElement.class);
        this.digester.addSetProperties(path);
        this.digester.addSetNext(path, "addChild");
        path = "JobDefinition/SetJobClass";
        this.digester.addObjectCreate(path, SetJobClassElement.class);
        this.digester.addSetProperties(path);
        this.digester.addSetNext(path, "addChild");
        path = "JobDefinition/JobClass/MemberJob";
        this.digester.addObjectCreate(path, MemberJobElement.class);
        this.digester.addSetProperties(path);
        this.digester.addSetNext(path, "addChild");
    }

    public void parse(InputStream is) throws IOException, SAXException {
        try {
            this.digester.resetRoot();
            this.digester.parse(is);
            AbstractSdlElement top = (AbstractSdlElement)this.digester.getRoot();
            if (top != null) {
                top.construct(null, this.jfacade);
                top.connect(null, this.jfacade);
            }
        }
        catch (IOException e) {
            logger.info((Object)e);
            throw e;
        }
        catch (SAXException e) {
            logger.info((Object)e);
            throw e;
        }
    }

    public void parse(File inf) throws IOException, SAXException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(inf);
            this.parse(is);
        }
        catch (FileNotFoundException e) {
            logger.info((Object)e);
            throw e;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    public static class SetJobClassElement
    extends AbstractSdlElement {
        private String forJobName;
        private String classname;

        public void setForJobName(String forJobName) {
            this.forJobName = forJobName;
        }

        public void setClassName(String className) {
            this.classname = className;
        }

        public void connect(AbstractSdlElement parent, JobFacade f) {
            super.connect(parent, f);
            try {
                f.assignJobClass(this.forJobName, this.classname);
            }
            catch (JobManagerException jobManagerException) {
                // empty catch block
            }
        }
    }

    public static class MemberJobElement
    extends AbstractSdlElement {
        private String name;

        public void setName(String name) {
            this.name = name;
        }

        public void construct(AbstractSdlElement parent, JobFacade f) {
            super.construct(parent, f);
        }
    }

    public static class JobClassElement
    extends AbstractSdlElement {
        private String name;
        private String concurrency;
        private String maxruntime;
        private String maxwaittime;

        public void setName(String name) {
            this.name = name;
        }

        public void setConcurrency(String concurrency) {
            this.concurrency = concurrency;
        }

        public void setMaxruntime(String maxruntime) {
            this.maxruntime = maxruntime;
        }

        public void setMaxwaittime(String maxwaittime) {
            this.maxwaittime = maxwaittime;
        }

        public void construct(AbstractSdlElement parent, JobFacade f) {
            super.construct(parent, f);
            JobClass jc = null;
            try {
                jc = f.createJobClass(this.name);
            }
            catch (JobManagerException e) {
                // empty catch block
            }
            if (jc != null) {
                if (this.concurrency == null || this.concurrency.length() == 0) {
                    jc.setConcurrency(1);
                } else {
                    jc.setConcurrency(Integer.parseInt(this.concurrency));
                }
                jc.setMaxRunTime(Long.parseLong(this.maxruntime));
                jc.setMaxWaitTime(Long.parseLong(this.maxwaittime));
            }
        }
    }

    public static class OperatorElement
    extends AbstractSdlElement {
        private String name;
        private String type;
        private int count;
        private List<String> predecessors = new ArrayList<String>();
        private JobNet container;

        public void setName(String name) {
            this.name = name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setCount(String count) {
            try {
                this.count = Integer.parseInt(count);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void addPredecessor(String predecessor) {
            this.predecessors.add(predecessor);
        }

        public JobNet getContainer() {
            return this.container;
        }

        public void construct(AbstractSdlElement parent, JobFacade f) {
            super.construct(parent, f);
            if (parent instanceof JobNetElement) {
                this.container = ((JobNetElement)parent).getJobNet();
            } else if (parent instanceof TerminalElement) {
                this.container = ((TerminalElement)parent).getContainer();
            } else if (parent instanceof OperatorElement) {
                this.container = ((OperatorElement)parent).getContainer();
            } else {
                logger.info((Object)"failed to construct Operator");
                return;
            }
            if (this.type.equalsIgnoreCase("or")) {
                f.createOrOperator(this.container, this.name);
            } else if (this.type.equalsIgnoreCase("and")) {
                f.createAndOperator(this.container, this.name);
            } else if (this.type.equalsIgnoreCase("not")) {
                f.createNotOperator(this.container, this.name);
            } else if (this.type.equalsIgnoreCase("xor")) {
                f.createXorOperator(this.container, this.name);
            } else if (this.type.equalsIgnoreCase("count")) {
                f.createCounterOperator(this.container, this.name, this.count);
            }
        }

        public void connect(AbstractSdlElement parent, JobFacade f) {
            if (this.container != null) {
                for (String p : this.predecessors) {
                    try {
                        f.connect(this.container, p, this.name);
                    }
                    catch (ClassCastException e) {
                        logger.info((Object)"failed to connect Operator because of bad cast operatrion");
                    }
                    catch (ConditionBoardException e) {
                        logger.info((Object)("failed to connect Operator:" + e.getMessage()));
                    }
                }
            }
        }
    }

    public static class PredecessorElement
    extends AbstractSdlElement {
        private String name;

        public void setName(String name) {
            this.name = name;
        }

        public void construct(AbstractSdlElement parent, JobFacade f) {
            super.construct(parent, f);
            if (parent instanceof TerminalElement) {
                ((TerminalElement)parent).addPredecessor(this.name);
            } else if (parent instanceof OperatorElement) {
                ((OperatorElement)parent).addPredecessor(this.name);
            }
        }
    }

    public static class TerminalElement
    extends AbstractSdlElement {
        private static long id = 0L;
        private String type;
        private String name;
        private String forJobName;
        private long delay;
        private List<String> predecessors = new ArrayList<String>();
        private JobNet container;

        public void setType(String type) {
            this.type = type;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setForJobName(String forJobName) {
            this.forJobName = forJobName;
        }

        public void setDelay(String delay) {
            try {
                this.delay = Long.parseLong(delay);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void addPredecessor(String predecessor) {
            this.predecessors.add(predecessor);
        }

        public JobNet getContainer() {
            return this.container;
        }

        public void construct(AbstractSdlElement parent, JobFacade f) {
            super.construct(parent, f);
            this.container = ((JobNetElement)parent).getJobNet();
            if (this.name == null) {
                this.name = "Terminal_" + this.type + "_" + ++id;
            }
            Terminal t = null;
            if (this.type.equalsIgnoreCase("force")) {
                t = f.createForceRunTerminal(this.container, this.name, this.forJobName, this.delay);
            } else if (this.type.equalsIgnoreCase("prohibit")) {
                t = f.createProhibitTerminal(this.container, this.name, this.forJobName, this.delay);
            }
        }

        public void connect(AbstractSdlElement parent, JobFacade f) {
            super.connect(parent, f);
            if (this.container != null) {
                for (String p : this.predecessors) {
                    try {
                        f.connect(this.container, p, this.name);
                    }
                    catch (ClassCastException e) {
                    }
                    catch (ConditionBoardException e) {}
                }
            }
        }
    }

    public static class JobNetElement
    extends AbstractSdlElement {
        private String name;
        private JobNet net;
        private String enabled;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public JobNet getJobNet() {
            return this.net;
        }

        public void setEnabled(String enabled) {
            this.enabled = enabled;
        }

        public void construct(AbstractSdlElement parent, JobFacade f) {
            this.net = f.createJobNet(this.name);
            super.construct(parent, f);
        }
    }

    public static class PseudoElement
    extends AbstractSdlElement {
        private String name;

        public void setName(String name) {
            this.name = name;
        }

        public void construct(AbstractSdlElement parent, JobFacade f) {
            super.construct(parent, f);
            if (this.name != null) {
                JobNetElement e = (JobNetElement)parent;
                f.createInterruptFollower(e.getJobNet(), this.name);
            }
        }
    }

    public static class AssignTriggerElement
    extends AbstractSdlElement {
        private String jobName;
        private String triggerName;

        public void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public void setTriggerName(String triggerName) {
            this.triggerName = triggerName;
        }

        public void connect(AbstractSdlElement parent, JobFacade f) {
            super.connect(parent, f);
            if (this.jobName != null && this.triggerName != null) {
                Trigger t = null;
                try {
                    t = f.getTrigger(this.triggerName);
                }
                catch (JobManagerException e) {
                    // empty catch block
                }
                JobDetail job = null;
                try {
                    job = f.getJob(this.jobName);
                }
                catch (JobManagerException e) {
                    // empty catch block
                }
                try {
                    f.scheduleJob(job, t);
                }
                catch (JobManagerException e) {
                    // empty catch block
                }
            }
        }
    }

    public static class TriggerElement
    extends AbstractSdlElement {
        private String forJobName;
        private String name;
        private String at;
        private Trigger trigger;

        public void setForJobName(String forJobName) {
            this.forJobName = forJobName;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setAt(String at) {
            this.at = at;
        }

        public void construct(AbstractSdlElement parent, JobFacade f) {
            super.construct(parent, f);
            String cronPatrn = "\\S+\\s+\\S+\\s+\\S+\\s+\\S+\\s+\\S+\\s+\\S";
            if (this.at == null || this.at.equalsIgnoreCase("now")) {
                this.trigger = f.createTrigger(this.name);
            } else if (this.at.matches(cronPatrn)) {
                try {
                    this.trigger = f.createTrigger(this.name, this.at);
                }
                catch (JobManagerException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    long interval = Long.parseLong(this.at);
                    this.trigger = f.createTrigger(this.name, interval);
                }
                catch (NumberFormatException e) {
                    logger.info((Object)("invalid 'at' spec:" + this.at));
                }
            }
        }

        public void connect(AbstractSdlElement parent, JobFacade f) {
            super.connect(parent, f);
            if (this.forJobName != null && this.trigger != null) {
                JobDetail job = null;
                try {
                    job = f.getJob(this.forJobName);
                }
                catch (JobManagerException e) {
                    // empty catch block
                }
                if (job != null) {
                    try {
                        f.scheduleJob(job, this.trigger);
                    }
                    catch (JobManagerException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static class ArgElement
    extends AbstractSdlElement {
        private String arg;

        public void construct(AbstractSdlElement parent, JobFacade f) {
            super.construct(parent, f);
            ((JobElement)parent).addArg(this.arg);
        }
    }

    public static class JobElement
    extends AbstractSdlElement {
        private String scriptPath;
        private String name;
        private String jobjectName;
        private String methodName;
        private long maxRunTime = 0L;
        private List<String> childArg = new ArrayList<String>();
        RootJobReceiver.ASSIGNMENT interrupted = RootJobReceiver.ASSIGNMENT.VOID;
        RootJobReceiver.ASSIGNMENT misfired = RootJobReceiver.ASSIGNMENT.VOID;
        RootJobReceiver.ASSIGNMENT stdout = RootJobReceiver.ASSIGNMENT.VOID;
        RootJobReceiver.ASSIGNMENT stderr = RootJobReceiver.ASSIGNMENT.VOID;
        Boolean useOut = false;
        Boolean useErr = false;
        String outPattern;
        String errPattern;
        private boolean usePredefined = false;

        public void setName(String name) {
            this.name = name;
        }

        public void setScriptPath(String scriptPath) {
            this.scriptPath = scriptPath;
        }

        public void addArg(String arg) {
            this.childArg.add(arg);
        }

        public void setMaxRunTime(String arg) {
            try {
                if (arg != null && arg.length() > 0) {
                    this.maxRunTime = Long.parseLong(arg);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void setUseOut(String arg) {
            this.useOut = Boolean.parseBoolean(arg);
        }

        public void setUseErr(String arg) {
            this.useErr = Boolean.parseBoolean(arg);
        }

        public void setInterrupted(String arg) {
            this.interrupted = "true".equalsIgnoreCase(arg) ? RootJobReceiver.ASSIGNMENT.CONVERT_TRUE : ("false".equalsIgnoreCase(arg) ? RootJobReceiver.ASSIGNMENT.CONVERT_FALSE : ("interrupted".equalsIgnoreCase(arg) ? RootJobReceiver.ASSIGNMENT.PSEUDOJOB : RootJobReceiver.ASSIGNMENT.VOID));
        }

        public void setMisfired(String arg) {
            this.misfired = "true".equalsIgnoreCase(arg) ? RootJobReceiver.ASSIGNMENT.CONVERT_TRUE : ("false".equalsIgnoreCase(arg) ? RootJobReceiver.ASSIGNMENT.CONVERT_FALSE : ("misfired".equalsIgnoreCase(arg) ? RootJobReceiver.ASSIGNMENT.PSEUDOJOB : RootJobReceiver.ASSIGNMENT.VOID));
        }

        public void setStdout(String arg) {
            if (arg.startsWith("true:")) {
                this.outPattern = arg.substring("true:".length());
                this.useOut = true;
                this.stdout = RootJobReceiver.ASSIGNMENT.CONVERT_TRUE;
            } else if (arg.startsWith("false:")) {
                this.outPattern = arg.substring("false:".length());
                this.useOut = true;
                this.stdout = RootJobReceiver.ASSIGNMENT.CONVERT_FALSE;
            } else if (arg.startsWith("stdout:")) {
                this.outPattern = arg.substring("stdout:".length());
                this.useOut = true;
                this.stdout = RootJobReceiver.ASSIGNMENT.PSEUDOJOB;
            }
        }

        public void setStderr(String arg) {
            if (arg.startsWith("true:")) {
                this.errPattern = arg.substring("true:".length());
                this.useErr = true;
                this.stderr = RootJobReceiver.ASSIGNMENT.CONVERT_TRUE;
            } else if (arg.startsWith("false:")) {
                this.errPattern = arg.substring("false:".length());
                this.useErr = true;
                this.stderr = RootJobReceiver.ASSIGNMENT.CONVERT_FALSE;
            } else if (arg.startsWith("stderr:")) {
                this.errPattern = arg.substring("stderr:".length());
                this.useErr = true;
                this.stderr = RootJobReceiver.ASSIGNMENT.PSEUDOJOB;
            }
        }

        public void setUsePredefined(String arg) {
            if ("TRUE".equalsIgnoreCase(arg) || !"0".equals(arg)) {
                this.usePredefined = true;
            }
        }

        public void construct(AbstractSdlElement parent, JobFacade f) {
            super.construct(parent, f);
            if (this.scriptPath != null) {
                JobReceiver receiver;
                String[] arr = Parser.splitCommandline(this.scriptPath);
                String[] farr = new String[this.childArg.size()];
                this.childArg.toArray(farr);
                String[] argarr = new String[arr.length + farr.length];
                System.arraycopy(arr, 0, argarr, 0, arr.length);
                System.arraycopy(farr, 0, argarr, arr.length, farr.length);
                try {
                    f.createJob(this.name, argarr, this.useOut, this.useErr, this.usePredefined);
                }
                catch (JobManagerException e) {
                    return;
                }
                if (this.maxRunTime != 0L) {
                    try {
                        f.setJobLastingTime(this.name, this.maxRunTime);
                    }
                    catch (JobManagerException e) {
                        return;
                    }
                }
                if ((receiver = f.getJobReceiver(this.name)) instanceof RootJobReceiver) {
                    RootJobReceiver rr = (RootJobReceiver)((Object)receiver);
                    rr.setInterruptedAssignement(this.interrupted);
                    rr.setMisfiredAssignment(this.misfired);
                    rr.setOutPattern(this.outPattern);
                    rr.setOutPatternAssignment(this.stdout);
                    rr.setErrPattern(this.errPattern);
                    rr.setErrPatternAssignment(this.stderr);
                }
            }
        }
    }

    public static class TopElement
    extends AbstractSdlElement {
    }

    public static abstract class AbstractSdlElement {
        protected List<AbstractSdlElement> elements = new ArrayList<AbstractSdlElement>();

        public void addChild(AbstractSdlElement e) {
            this.elements.add(e);
        }

        public void construct(AbstractSdlElement parent, JobFacade f) {
            for (AbstractSdlElement e : this.elements) {
                try {
                    e.construct(this, f);
                }
                catch (Throwable t) {
                    logger.info((Object)("invalid node fouind:" + e.toString()));
                }
            }
        }

        public void connect(AbstractSdlElement parent, JobFacade f) {
            for (AbstractSdlElement e : this.elements) {
                try {
                    e.connect(this, f);
                }
                catch (Throwable t) {
                    logger.info((Object)("invalid node fouind:" + e.toString()));
                }
            }
        }

        public void print(int depth) {
            String spcs = "";
            for (int i = 0; i < depth; ++i) {
                spcs = spcs + " ";
            }
            System.out.println(spcs + this.getClass().getSimpleName());
            for (AbstractSdlElement e : this.elements) {
                e.print(depth + 1);
            }
        }
    }

    private static final class ParserDigester
    extends Digester {
        private final Logger logger;

        public ParserDigester(Logger logger) {
            this.logger = logger;
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.logger.trace((Object)exception);
        }

        public void error(SAXParseException exception) throws SAXException {
            this.logger.info((Object)"scheduler dsl parse error");
            this.logger.debug((Object)exception);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.logger.info((Object)"scheduler dsl parse error");
            this.logger.debug((Object)exception);
        }
    }
}

