/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.jobmanager.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.wiperdog.jobmanager.ConditionBoardException;
import org.wiperdog.jobmanager.Flow;
import org.wiperdog.jobmanager.JobPatchBoard;
import org.wiperdog.jobmanager.Operator;
import org.wiperdog.jobmanager.Predecessor;

public abstract class AbstractOperator
implements Operator {
    protected final String id;
    protected final List<Flow> outFlowList = new ArrayList<Flow>();
    protected final List<Flow> upperConnectionList = new ArrayList<Flow>();
    protected final List<Boolean> switchboard = new ArrayList<Boolean>();
    protected final Logger logger = Logger.getLogger((String)"com.insight_tec.pi.jobmanager");

    protected AbstractOperator() {
        this.logger.trace((Object)"AbstractOperator.AbstractOperator()");
        this.id = "Operator_" + JobPatchBoard.getSequenceNumber();
    }

    protected AbstractOperator(String name) {
        this.logger.trace((Object)("AbstractOperator.AbstractOperator(" + name + ")"));
        this.id = name;
    }

    public boolean[] getTValues() {
        boolean[] tv = new boolean[this.switchboard.size()];
        for (int i = 0; i < this.switchboard.size(); ++i) {
            tv[i] = this.switchboard.get(i);
        }
        return tv;
    }

    public String getName() {
        return this.id;
    }

    public Flow[] getOutFlows() {
        Flow[] ofs = new Flow[this.outFlowList.size()];
        this.outFlowList.toArray(ofs);
        return ofs;
    }

    public String toString() {
        String str = this.getClass().getSimpleName() + "(" + this.id + ") outflows :{";
        for (Flow f : this.outFlowList) {
            str = str + f.getId() + ",";
        }
        str = str + "}";
        return str;
    }

    protected abstract boolean chkSwitchBoard();

    protected void flowOut(boolean v) {
        this.logger.trace((Object)("AbstractOperator.flowOut(" + v + ")"));
        for (Flow f : this.outFlowList) {
            f.call(v);
        }
    }

    public void addOutFlow(Flow flow) throws ConditionBoardException {
        this.logger.trace((Object)("AbstractOperator.addOutFlow(" + flow.toString() + ")"));
        this.outFlowList.add(flow);
    }

    public void deleteOutFlow(Flow flow) throws ConditionBoardException {
        this.logger.trace((Object)("AbstractOperator.deleteOutFlow(" + flow.toString() + ")"));
        this.outFlowList.remove(flow);
    }

    private Flow _connect(Predecessor o) throws ConditionBoardException {
        this.logger.trace((Object)("AbstractOperator._connect(" + o.toString() + ")"));
        this._disconnect(o);
        InFlow f = new InFlow(o, this.upperConnectionList.size());
        this.upperConnectionList.add(f);
        return f;
    }

    private Flow _disconnect(Predecessor o) throws ConditionBoardException {
        int i;
        this.logger.trace((Object)("AbstractOperator._disconnect(" + o.toString() + ")"));
        Flow found = null;
        for (i = 0; i < this.upperConnectionList.size(); ++i) {
            Flow f = this.upperConnectionList.get(i);
            if (!((InFlow)f).isConnectedTo(o)) continue;
            ((InFlow)f).disconnect();
            found = f;
            break;
        }
        if (found != null) {
            this.upperConnectionList.remove(i);
        }
        return found;
    }

    private Flow _connect(int index, Predecessor o) throws ConditionBoardException {
        this.logger.trace((Object)("AbstractOperator._connect(" + index + "," + o.toString() + ")"));
        this._disconnect(index, o);
        InFlow f = new InFlow(o, index);
        this.upperConnectionList.add(index, f);
        return f;
    }

    private Flow _disconnect(int index, Predecessor o) throws ConditionBoardException {
        this.logger.trace((Object)("AbstractOperator._disconnect(" + index + "," + o.toString() + ")"));
        Flow of = this.upperConnectionList.remove(index);
        if (of != null && ((InFlow)of).isConnectedTo(o)) {
            ((InFlow)of).disconnect();
        }
        return of;
    }

    public void connectUpperFlow(Predecessor f) throws ConditionBoardException {
        this.logger.trace((Object)("AbstractOperator.connectUpperFlow(" + f.toString() + ")"));
        f.addOutFlow(this._connect(f));
    }

    public void connectUpperFlow(int index, Predecessor f) throws ConditionBoardException {
        this.logger.trace((Object)("AbstractOperator.connectUpperFlow(" + index + "," + f.toString() + ")"));
        f.addOutFlow(this._connect(index, f));
    }

    public void disconnectUpperFlow(int index, Predecessor p) throws ConditionBoardException {
        this.logger.trace((Object)("AbstractOperator.disconnectUpperFlow(" + index + "," + p.toString() + ")"));
        InFlow f = (InFlow)this._disconnect(index, p);
        p.deleteOutFlow(f);
    }

    public void disconnectUpperFlow(Predecessor p) throws ConditionBoardException {
        this.logger.trace((Object)("AbstractOperator.disconnectUpperFlow(" + p.toString() + ")"));
        InFlow f = (InFlow)this._disconnect(p);
        p.deleteOutFlow(f);
    }

    public String getId() {
        this.logger.trace((Object)"AbstractOperator.getId()");
        return this.id;
    }

    private final class InFlow
    implements Flow {
        private final Predecessor upper;
        private final int position;

        public InFlow(Predecessor upper, int position) {
            AbstractOperator.this.logger.trace((Object)("AbstractOperator.InFlow.InFlow(" + upper.toString() + "," + position));
            this.upper = upper;
            this.position = position;
            if (AbstractOperator.this.switchboard.size() <= position) {
                for (int i = AbstractOperator.this.switchboard.size(); i <= position; ++i) {
                    AbstractOperator.this.switchboard.add(false);
                }
            }
        }

        public void disconnect() throws ConditionBoardException {
            AbstractOperator.this.logger.trace((Object)"AbstractOperator.InFlow.disconnect()");
            this.upper.deleteOutFlow(this);
        }

        public String getId() {
            AbstractOperator.this.logger.trace((Object)"AbstractOperator.InFlow.getId()");
            return AbstractOperator.this.id;
        }

        public void call(boolean v) {
            AbstractOperator.this.logger.trace((Object)("AbstractOperator.InFlow.call(" + v + ") - " + AbstractOperator.this.id + " - " + this.position));
            AbstractOperator.this.switchboard.set(this.position, v);
            AbstractOperator.this.flowOut(AbstractOperator.this.chkSwitchBoard());
        }

        public int getPosition() {
            AbstractOperator.this.logger.trace((Object)"InAbstractOperator.Flow.getPosition()");
            return this.position;
        }

        public Predecessor getPredecessor() {
            return this.upper;
        }

        public boolean isConnectedTo(Predecessor p) {
            AbstractOperator.this.logger.trace((Object)("AbstractOperator.InFlow.isConnectedTo(" + p.toString() + ")"));
            return this.upper == p;
        }
    }
}

