/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.jobmanager.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;
import org.wiperdog.jobmanager.Flow;
import org.wiperdog.jobmanager.JobFacade;
import org.wiperdog.jobmanager.Operator;
import org.wiperdog.jobmanager.Receiver;
import org.wiperdog.jobmanager.Terminal;
import org.wiperdog.jobmanager.dsl.Parser;
import org.wiperdog.jobmanager.internal.JobFacadeImpl;

public class AppMain {
    private String dotPath = "jobgraph.dot";
    private PrintWriter pw = null;
    public static final String PID = "com.insight_tec.pi.jobmanager";
    public static final String LOGGERNAME = "com.insight_tec.pi.jobmanager";
    public static final String LOGGERNAME_TRACE = "com.insight_tec.pi.jobmanager_trace";

    public static void setupLogger() {
        Logger logger = Logger.getRootLogger();
        SimpleLayout layout = new SimpleLayout();
        ConsoleAppender appender = new ConsoleAppender((Layout)layout, "System.err");
        logger.addAppender((Appender)appender);
        logger = Logger.getLogger((String)"com.insight_tec.pi.jobmanager");
        logger.setLevel(Level.DEBUG);
        logger = Logger.getLogger((String)LOGGERNAME_TRACE);
        logger.setLevel(Level.TRACE);
    }

    public static void disableQuartzUpdateCheck() {
        System.setProperty("org.terracotta.quartz.skipUpdateCheck", "true");
    }

    public static final void main(String[] args) {
        if (args.length == 0) {
            System.out.println("AppMain filename [timeout_millis]");
            return;
        }
        new AppMain()._main(args);
    }

    private void dotprintln(String str) {
        if (this.pw != null) {
            this.pw.println(str);
            this.pw.flush();
        }
    }

    private void showGraph(JobFacade f, File dotfile) {
        if (dotfile != null) {
            try {
                this.pw = new PrintWriter(new FileOutputStream(dotfile));
            }
            catch (FileNotFoundException e) {}
        } else {
            this.pw = null;
        }
        this.dotprintln("digraph {");
        Set<String> netset = f.keySetNet();
        ArrayList<String> nets = new ArrayList<String>();
        nets.addAll(netset);
        nets.add("");
        for (String netname : nets) {
            List<Object> elist = null;
            elist = netname.length() == 0 ? f.getNodeList() : f.getNodeList(netname);
            if (elist == null) continue;
            for (Object o : elist) {
                Flow[] ofs;
                String grafAttr = "";
                if (o instanceof Operator) {
                    Flow[] ofs2;
                    Operator op = (Operator)o;
                    boolean[] tvs = op.getTValues();
                    for (Flow flow : ofs2 = op.getOutFlows()) {
                        this.dotprintln(netname + "_" + op.getName() + " -> " + netname + "_" + flow.getId() + ";");
                    }
                    grafAttr = " [label=\"";
                    grafAttr = grafAttr + op.getName() + "\\n(" + op.getClass().getSimpleName() + ")\\n[ ";
                    for (boolean b : tvs) {
                        grafAttr = grafAttr + b + " ";
                    }
                    grafAttr = grafAttr + "]\\n" + op.getPValue() + "\"];";
                    this.dotprintln(netname + "_" + op.getName() + grafAttr);
                }
                if (o instanceof Terminal) {
                    Terminal ot = (Terminal)o;
                    grafAttr = " [label=\"";
                    grafAttr = grafAttr + ot.getName() + "\\n(" + ot.getClass().getSimpleName() + ")\\n" + ot.getPValue() + "\"];";
                    this.dotprintln(netname + "_" + ot.getName() + grafAttr);
                }
                if (!(o instanceof Receiver)) continue;
                Receiver or = (Receiver)o;
                for (Flow flow : ofs = or.getOutFlows()) {
                    this.dotprintln(netname + "_" + or.getJobKey().getName() + " -> " + netname + "_" + flow.getId() + ";");
                }
                grafAttr = " [label=\"";
                grafAttr = grafAttr + or.getJobKey().toString() + "\\n(" + or.getClass().getSimpleName() + ")\"];";
                this.dotprintln(netname + "_" + or.getJobKey().getName() + grafAttr);
            }
        }
        this.dotprintln("}");
    }

    public void _main(String[] args) {
        StdSchedulerFactory sf = new StdSchedulerFactory();
        try {
            Scheduler scheduler = sf.getScheduler();
            JobFacadeImpl f = new JobFacadeImpl(scheduler);
            Parser p = new Parser(f, false);
            File df = new File(args[0]);
            if (df.isFile()) {
                p.parse(df);
            } else {
                System.err.println("file not found");
            }
            this.showGraph(f, new File("jobgraph.dot"));
            scheduler.start();
            long waittime = 30000L;
            if (args.length > 1) {
                try {
                    waittime = Long.parseLong(args[1]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            Thread.sleep(waittime);
            this.showGraph(f, new File("jobgraph2.dot"));
            System.out.println("end of test, shutting down scheduler");
            scheduler.shutdown();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static {
        AppMain.setupLogger();
        AppMain.disableQuartzUpdateCheck();
    }
}

