/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.jobmanager.internal;

import org.apache.log4j.Logger;
import org.quartz.DateBuilder;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.wiperdog.jobmanager.internal.AbstractTerminal;

public class ForceRunTerminal
extends AbstractTerminal {
    private final Scheduler scheduler;
    private Logger logger = Logger.getLogger((String)"com.insight_tec.pi.jobmanager");
    private long delay = 0L;

    public ForceRunTerminal(String name, Scheduler scheduler, JobKey jobkey) {
        super(name, jobkey);
        this.logger.trace((Object)("ForceRunTerminal.ForceRunTerminal(" + scheduler.toString() + "," + jobkey.toString() + ")"));
        this.scheduler = scheduler;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    protected void update(boolean v) {
        this.logger.trace((Object)("ForceRunTerminal[" + this.jobkey.getName() + "].update(" + v + ")"));
        if (v) {
            this.runImmediate();
        }
    }

    private void runImmediate() {
        this.logger.trace((Object)"ForceRunTerminal.runImmediate()");
        Trigger t = null;
        try {
            t = this.scheduler.getTrigger(TriggerKey.triggerKey((String)this.id, (String)(this.id + "immediatetrigger")));
            if (t != null) {
                TriggerBuilder tb = t.getTriggerBuilder();
                t = tb.forJob(this.jobkey).startAt(DateBuilder.futureDate((int)((int)this.delay), (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.MILLISECOND)).build();
                this.scheduler.rescheduleJob(TriggerKey.triggerKey((String)this.id, (String)(this.id + "immediatetrigger")), t);
            } else {
                t = TriggerBuilder.newTrigger().withIdentity(this.id, this.id + "immediatetrigger").forJob(this.jobkey).startAt(DateBuilder.futureDate((int)((int)this.delay), (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.MILLISECOND)).build();
                try {
                    this.scheduler.scheduleJob(t);
                }
                catch (SchedulerException e) {
                    this.logger.debug((Object)"scheduleJob() failed", (Throwable)e);
                }
            }
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    public boolean getPValue() {
        return false;
    }
}

