/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.jobmanager.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.quartz.JobExecutionContext;
import org.wiperdog.jobmanager.internal.AbstractGenericJob;

public class JavaJob
extends AbstractGenericJob {
    private String className;
    private String methodName;
    private Object[] args;
    private Class<?> clsobj;
    private Object tgtobj;
    private Method method;

    public void setClassName(String className) {
        this.className = className;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setArgs(Object[] args) {
        this.args = args;
    }

    private void prepareJob() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        try {
            Method[] methods;
            this.clsobj = Class.forName(this.className);
            for (Method m : methods = this.clsobj.getMethods()) {
                if (!m.getName().equals(this.methodName)) continue;
                Class<?>[] argtypes = m.getParameterTypes();
                int i = 0;
                boolean bMatched = true;
                for (Class<?> t : argtypes) {
                    if (t.isInstance(this.args[i])) continue;
                    bMatched = false;
                    break;
                }
                if (!bMatched) continue;
                this.method = m;
                break;
            }
            this.tgtobj = this.clsobj.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (InstantiationException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw e;
        }
    }

    protected Object doJob(JobExecutionContext context) throws Throwable {
        Boolean result = Boolean.FALSE;
        this.prepareJob();
        try {
            this.method.invoke(this.tgtobj, this.args);
            result = Boolean.TRUE;
        }
        catch (IllegalAccessException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        return result;
    }
}

