/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.jobmanager.internal;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.DateBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Matcher;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.UnableToInterruptJobException;
import org.quartz.impl.matchers.EverythingMatcher;
import org.quartz.impl.matchers.GroupMatcher;
import org.wiperdog.jobmanager.ConditionBoardException;
import org.wiperdog.jobmanager.Follower;
import org.wiperdog.jobmanager.JobClass;
import org.wiperdog.jobmanager.JobExecutable;
import org.wiperdog.jobmanager.JobFacade;
import org.wiperdog.jobmanager.JobManagerException;
import org.wiperdog.jobmanager.JobNet;
import org.wiperdog.jobmanager.JobReceiver;
import org.wiperdog.jobmanager.JobResult;
import org.wiperdog.jobmanager.JobResultSource;
import org.wiperdog.jobmanager.Operator;
import org.wiperdog.jobmanager.Predecessor;
import org.wiperdog.jobmanager.Receiver;
import org.wiperdog.jobmanager.Terminal;
import org.wiperdog.jobmanager.TriggerReceiver;
import org.wiperdog.jobmanager.internal.AndOperator;
import org.wiperdog.jobmanager.internal.CommanderJob;
import org.wiperdog.jobmanager.internal.CounterOperator;
import org.wiperdog.jobmanager.internal.ForceRunTerminal;
import org.wiperdog.jobmanager.internal.JavaJob;
import org.wiperdog.jobmanager.internal.JobClassImpl;
import org.wiperdog.jobmanager.internal.JobReceiverImpl;
import org.wiperdog.jobmanager.internal.JobTerminateJob;
import org.wiperdog.jobmanager.internal.NotOperator;
import org.wiperdog.jobmanager.internal.ObjectJob;
import org.wiperdog.jobmanager.internal.OrOperator;
import org.wiperdog.jobmanager.internal.ProhibitTerminal;
import org.wiperdog.jobmanager.internal.PseudoReceiver;
import org.wiperdog.jobmanager.internal.ShellJob;
import org.wiperdog.jobmanager.internal.XorOperator;
import org.wiperdog.rshell.api.RShellProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobFacadeImpl
implements JobFacade {
    private final Scheduler sched;
    private Map<String, JobNet> jobNetMap = new HashMap<String, JobNet>();
    private Map<String, JobClassImpl> jobClassMap = new HashMap<String, JobClassImpl>();
    private Logger logger = Logger.getLogger(JobFacadeImpl.class);
    private Map<String, JobDetail> jobDetailMap = new HashMap<String, JobDetail>();
    private Map<String, JobReceiver> jobReceiverMap = new HashMap<String, JobReceiver>();
    private static long seqnum = 0L;
    private static final String AUTONAME_BASE = "JOBOBJECT_";
    private RShellProvider commander;
    private int maxReceiveSize = 4096;
    private int maxHistoryDepth = 5;

    public void setCommander(RShellProvider commander) {
        this.commander = commander;
    }

    private String autoname() {
        return AUTONAME_BASE + ++seqnum;
    }

    private String autoname(String name) {
        if (name == null || "_autoname_".equals(name)) {
            return this.autoname();
        }
        return name;
    }

    public JobFacadeImpl(Scheduler sched) throws JobManagerException {
        this.logger.trace((Object)("constructor JobFacadeImpl(" + sched.toString() + ")"));
        this.sched = sched;
        try {
            sched.getListenerManager().addTriggerListener((TriggerListener)new FacadeTriggerListener("JobFacadeTriggerListener"), (Matcher)EverythingMatcher.allTriggers());
        }
        catch (SchedulerException e) {
            this.logger.info((Object)"failed to initialize Trigger Listener");
            this.logger.trace((Object)"", (Throwable)e);
            throw new JobManagerException("failed to initialize Trigger Listener", e);
        }
    }

    @Override
    public JobClass createJobClass(String name) throws JobManagerException {
        this.logger.trace((Object)("JobFacadeImpl.createJobClass(" + name + ")"));
        try {
            JobClassImpl jc = null;
            jc = this.jobClassMap.get(name);
            if (jc == null) {
                jc = new JobClassImpl(this, this.sched, name);
                this.jobClassMap.put(name, jc);
            }
            return jc;
        }
        catch (SchedulerException e) {
            this.logger.info((Object)("failed to create JobClass:" + name), (Throwable)e);
            throw new JobManagerException("failed to create JobClass:" + name, e);
        }
    }

    @Override
    public JobClass createJobClass(String name, int concurrency, long maxWaitTime, long maxRunTime) throws JobManagerException {
        this.logger.trace((Object)("JobFacadeImpl.createJobClass(" + name + "," + concurrency + "," + maxWaitTime + "," + maxRunTime + ")"));
        try {
            JobClassImpl jc = null;
            jc = this.jobClassMap.get(name);
            if (jc == null) {
                jc = new JobClassImpl(this, this.sched, name);
                this.jobClassMap.put(name, jc);
            }
            jc.setConcurrency(concurrency);
            jc.setMaxWaitTime(maxWaitTime);
            jc.setMaxRunTime(maxRunTime);
            return jc;
        }
        catch (SchedulerException e) {
            this.logger.info((Object)("failed to create JobClass:" + name), (Throwable)e);
            throw new JobManagerException("failed to create JobClass:" + name, e);
        }
    }

    @Override
    public void deleteJobClass(String name) throws JobManagerException {
        this.logger.trace((Object)("JobFacadeImpl.deleteJobClass(" + name + ")"));
        JobClass jc = this.jobClassMap.get(name);
        if (jc == null) {
            this.logger.trace((Object)("no such jobclass(" + name + ")"));
            throw new JobManagerException("no such jobclass(" + name + ")");
        }
        jc.close();
        this.jobClassMap.remove(name);
    }

    private void putJobReceiver(String name, JobReceiverImpl receiver) {
        this.jobReceiverMap.put(name, receiver);
        this.jobReceiverMap.put(name + "_INTERRUPTED", receiver.getInterruptedReceiver());
        this.jobReceiverMap.put(name + "_MISFIRED", receiver.getMisfiredReceiver());
        this.jobReceiverMap.put(name + "_OUTPATTERN", receiver.getOutPatternReceiver());
        this.jobReceiverMap.put(name + "_ERRPATTERN", receiver.getErrPatternReceiver());
    }

    private void removeJobReceiver(String name) {
        this.jobReceiverMap.remove(name);
        this.jobReceiverMap.remove(name + "_INTERRUPTED");
        this.jobReceiverMap.remove(name + "_MISFIRED");
        this.jobReceiverMap.remove(name + "_OUTPATTERN");
        this.jobReceiverMap.remove(name + "_ERRPATTERN");
    }

    private JobDetail createJob(String name, Class<? extends Job> cls, JobDataMap data) throws JobManagerException {
        JobDataMap datamap = data;
        if (datamap == null) {
            datamap = new JobDataMap();
        }
        datamap.put("prohibit", new HashSet());
        JobDetail job = JobBuilder.newJob().withIdentity(name).ofType(cls).storeDurably().requestRecovery(false).usingJobData(datamap).build();
        try {
            this.sched.addJob(job, true);
        }
        catch (SchedulerException e) {
            this.logger.info((Object)("failed to add job:" + name));
            throw new JobManagerException("failed to add job:" + name, e);
        }
        if (job != null) {
            this.jobDetailMap.put(name, job);
            try {
                JobReceiverImpl receiver = new JobReceiverImpl(this.sched, JobKey.jobKey((String)name), this.maxHistoryDepth);
                this.putJobReceiver(name, receiver);
            }
            catch (SchedulerException e) {
                throw new JobManagerException("failed to setup job receiver", e);
            }
        }
        return job;
    }

    @Override
    public JobDetail createControlJob(String name, JobFacade.ControlJobType type, String[] args) throws JobManagerException {
        JobDataMap data = new JobDataMap();
        if (args.length == 0) {
            return null;
        }
        data.put("jobname", args[0]);
        return this.createJob(name, JobTerminateJob.class, data);
    }

    @Override
    public JobDetail createJob(String name, String[] scriptPathAndArguments, boolean usePredefined) throws JobManagerException {
        return this.createJob(name, scriptPathAndArguments, false, false, usePredefined);
    }

    @Override
    public JobDetail createJob(String name, String[] scriptPathAndArguments, boolean useOut, boolean useErr, boolean usePredefined) throws JobManagerException {
        this.logger.trace((Object)("JobFacadeImpl.createJob(" + name + "," + scriptPathAndArguments.toString() + ")"));
        JobDataMap dataMap = new JobDataMap();
        dataMap.put("type", "command");
        dataMap.put("programargs", (Object)scriptPathAndArguments);
        dataMap.put("useOut", (Object)useOut);
        dataMap.put("useErr", (Object)useErr);
        if (usePredefined) {
            dataMap.put("commander", (Object)this.commander);
            return this.createJob(name, CommanderJob.class, dataMap);
        }
        return this.createJob(name, ShellJob.class, dataMap);
    }

    @Override
    public JobDetail createJob(String name, String className, String methodSignature, Object[] args) throws JobManagerException {
        JobDataMap dataMap = new JobDataMap();
        dataMap.put("type", "javaclass");
        dataMap.put("className", className);
        dataMap.put("methodName", methodSignature);
        dataMap.put("args", (Object)args);
        return this.createJob(name, JavaJob.class, dataMap);
    }

    @Override
    public JobDetail createJob(String name, String[] filterspec, String methodSignature, Object[] args) throws JobManagerException {
        this.logger.trace((Object)("JobFacadeImpl.createJob(" + name + "," + filterspec.toString() + ")"));
        throw new JobManagerException("not supported job creation");
    }

    @Override
    public JobDetail createJob(JobExecutable executable) throws JobManagerException {
        String name = executable.getName();
        JobDataMap dataMap = new JobDataMap();
        dataMap.put("type", "object");
        dataMap.put("object", (Object)executable);
        return this.createJob(name, ObjectJob.class, dataMap);
    }

    @Override
    public void removeJob(JobDetail job) throws JobManagerException {
        this.logger.trace((Object)("JobFacadeImpl.removeJob(" + job.getKey().toString() + ")"));
        try {
            this.sched.deleteJob(job.getKey());
            this.removeJobReceiver(job.getKey().getName());
            this.jobDetailMap.remove(job.getKey().getName());
        }
        catch (SchedulerException e) {
            this.logger.info((Object)("failed to remove job:" + job.getKey().toString()));
            throw new JobManagerException("failed to remove job:" + job.getKey().toString(), e);
        }
    }

    @Override
    public List<JobResult> getJobResult(String name) {
        JobReceiver receiver = this.jobReceiverMap.get(name);
        if (receiver != null && receiver instanceof JobResultSource) {
            String jobclassname;
            JobResult jr;
            List<JobResult> resultlist = receiver.getJobResultList();
            if (resultlist.size() > 0 && (jr = resultlist.get(resultlist.size() - 1)).getPendedAt() != null && jr.getEndedAt() == null && jr.getWaitexpiredAt() == null && (jobclassname = (String)jr.getData().get("pendingclass")) != null) {
                JobClassImpl jc = (JobClassImpl)this.getJobClass(jobclassname);
                jc.removeAllExpiredJob();
                resultlist = receiver.getJobResultList();
            }
            return resultlist;
        }
        return null;
    }

    @Override
    public Trigger createTrigger(String name) {
        this.logger.trace((Object)("JobFacadeImpl.createTrigger(" + name + ")"));
        return TriggerBuilder.newTrigger().withIdentity(this.autoname(name)).startNow().build();
    }

    @Override
    public Trigger createTrigger(String name, long delay) {
        this.logger.trace((Object)("JobFacadeImpl.createTrigger(" + name + "," + delay + ")"));
        return TriggerBuilder.newTrigger().withIdentity(this.autoname(name)).startAt(DateBuilder.futureDate((int)((int)delay), (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.MILLISECOND)).build();
    }

    @Override
    public Trigger createTrigger(String name, Date at) {
        this.logger.trace((Object)("JobFacadeImpl.createTrigger(" + name + "," + at.toString() + ")"));
        return TriggerBuilder.newTrigger().withIdentity(this.autoname(name)).startAt(at).build();
    }

    @Override
    public Trigger createTrigger(String name, String crondef) throws JobManagerException {
        this.logger.trace((Object)("JobFacadeImpl.createTrigger(" + name + "," + crondef + ")"));
        try {
            return TriggerBuilder.newTrigger().withIdentity(this.autoname(name)).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)crondef)).withDescription(crondef).build();
        }
        catch (ParseException e) {
            this.logger.info((Object)("failed to create cron trigger, bad format:" + name + ", " + crondef), (Throwable)e);
            throw new JobManagerException("failed to create cron trigger, bad format:" + name + ", " + crondef, e);
        }
    }

    @Override
    public void scheduleJob(JobDetail job, Trigger trigger) throws JobManagerException {
        this.logger.trace((Object)("JobFacadeImpl.scheduleJob(" + job.getKey().toString() + "," + trigger.getKey().toString() + ")"));
        try {
            TriggerBuilder builder = trigger.getTriggerBuilder();
            Trigger newTrigger = builder.forJob(job).build();
            if (this.sched.getTrigger(trigger.getKey()) != null) {
                this.sched.rescheduleJob(trigger.getKey(), newTrigger);
            } else {
                this.sched.scheduleJob(newTrigger);
            }
        }
        catch (SchedulerException e) {
            this.logger.info((Object)("assigning schedule to job failed:" + trigger.getKey().toString() + " --- " + job.getKey().toString()), (Throwable)e);
            throw new JobManagerException("assigning schedule to job failed:" + trigger.getKey().toString() + " --- " + job.getKey().toString(), e);
        }
    }

    @Override
    public Trigger createTrigger(String name, long delay, long interval) {
        this.logger.trace((Object)("JobFacadeImpl.createTrigger(" + name + ", " + delay + ", " + interval + ")"));
        Date startTime = new Date(System.currentTimeMillis() + delay);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(this.autoname(name)).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(interval).repeatForever()).startAt(startTime).build();
        return trigger;
    }

    @Override
    public Set<TriggerKey> getTriggerKeys() {
        HashSet<TriggerKey> result = new HashSet<TriggerKey>();
        try {
            List groupNames = this.sched.getTriggerGroupNames();
            for (String name : groupNames) {
                GroupMatcher matcher = GroupMatcher.triggerGroupEquals((String)name);
                Set keys = this.sched.getTriggerKeys(matcher);
                result.addAll(keys);
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Trigger getTrigger(TriggerKey key) {
        try {
            return this.sched.getTrigger(key);
        }
        catch (SchedulerException schedulerException) {
            return null;
        }
    }

    @Override
    public void unscheduleJob(Trigger trigger) throws JobManagerException {
        this.logger.trace((Object)("JobFacadeImpl.unscheduleJob(" + trigger.getKey().toString() + ")"));
        try {
            this.sched.unscheduleJob(trigger.getKey());
        }
        catch (SchedulerException e) {
            this.logger.info((Object)("failed to unscheduler job:" + trigger.getKey().toString()));
            throw new JobManagerException("failed to unscheduler job:" + trigger.getKey().toString(), e);
        }
    }

    @Override
    public JobNet createJobNet(String name) {
        this.logger.trace((Object)("JobFacadeImpl.createJobNet(" + name + ")"));
        JobNetImpl net = new JobNetImpl(name);
        this.jobNetMap.put(name, net);
        return net;
    }

    @Override
    public JobNet getJobNet(String name) {
        return this.jobNetMap.get(name);
    }

    @Override
    public Terminal createForceRunTerminal(JobNet net, String name, String jobName) {
        this.logger.trace((Object)("JobFacadeImpl.createForceRunTerminal(" + net.getName() + "," + name + "," + jobName + ")"));
        return net.createForceRunTerminal(name, jobName);
    }

    @Override
    public Terminal createForceRunTerminal(JobNet net, String name, String jobName, long interval) {
        ForceRunTerminal t = (ForceRunTerminal)this.createForceRunTerminal(net, name, jobName);
        t.setDelay(interval);
        return t;
    }

    @Override
    public Terminal createProhibitTerminal(JobNet net, String name, String jobName) {
        this.logger.trace((Object)("JobFacadeImpl.createProhitTerminal(" + net.getName() + "," + name + "," + jobName + ")"));
        return net.createProhibitTerminal(name, jobName);
    }

    @Override
    public Terminal createProhibitTerminal(JobNet net, String name, String jobName, long interval) {
        ProhibitTerminal t = (ProhibitTerminal)this.createProhibitTerminal(net, name, jobName);
        t.setGateTimer(interval);
        return t;
    }

    @Override
    public Operator createOrOperator(JobNet net, String name) {
        this.logger.trace((Object)("JobFacadeImpl.createOrOperator(" + net.getName() + "," + name + ")"));
        return net.createOrOperator(name);
    }

    @Override
    public Operator createAndOperator(JobNet net, String name) {
        this.logger.trace((Object)("JobFacadeImpl.createAndOperator(" + net.getName() + "," + name + ")"));
        return net.createAndOperator(name);
    }

    @Override
    public Operator createXorOperator(JobNet net, String name) {
        this.logger.trace((Object)("JobFacadeImpl.createXorOperator(" + net.getName() + "," + name + ")"));
        return net.createXorOperator(name);
    }

    @Override
    public Operator createNotOperator(JobNet net, String name) {
        this.logger.trace((Object)("JobFacadeImpl.createNotOperator(" + net.getName() + "," + name + ")"));
        return net.createNotOperator(name);
    }

    @Override
    public Operator createCounterOperator(JobNet net, String name, int count) {
        this.logger.trace((Object)("JobFacadeImpl.createNotOperator(" + net.getName() + "," + name + ")"));
        return net.createCounterOperator(name, count);
    }

    @Override
    public Receiver createInterruptFollower(JobNet net, String name) {
        this.logger.trace((Object)("JobFacadeImpl.createInterruptFollower(" + net.getName() + "," + name + ")"));
        return net.createInterruptFollower(name);
    }

    @Override
    public void signalNet(JobNet net, String portName, boolean v) {
        this.logger.trace((Object)("JobFacadeImpl.interruptNet(" + net.getName() + "," + portName + "," + v + ")"));
        net.interruptNet(portName, v);
    }

    @Override
    public Set<String> keySetNet() {
        return this.jobNetMap.keySet();
    }

    @Override
    public List<Object> getNodeList() {
        this.logger.trace((Object)"JobFacadeImpll.getNodeList()");
        ArrayList<Object> list = new ArrayList<Object>();
        Set<String> keys = this.jobDetailMap.keySet();
        for (String key : keys) {
            list.add(this.jobDetailMap.get(key));
        }
        return list;
    }

    @Override
    public List<Object> getNodeList(String netName) {
        this.logger.trace((Object)("JobFacadeImpl.getNodeList(" + netName + ")"));
        return this.jobNetMap.get(netName).getNodeList();
    }

    @Override
    public Object getNode(String netname, String objname) {
        return this.jobNetMap.get(netname).getNode(objname);
    }

    @Override
    public JobDetail getJob(String name) throws JobManagerException {
        this.logger.trace((Object)("JobFacadeImpl.getJob(" + name + ")"));
        try {
            return this.sched.getJobDetail(JobKey.jobKey((String)name));
        }
        catch (SchedulerException e) {
            this.logger.info((Object)("failed to get job:" + name));
            throw new JobManagerException("failed to get job:" + name, e);
        }
    }

    @Override
    public Trigger getTrigger(String name) throws JobManagerException {
        this.logger.trace((Object)("JobFacadeImpl.getTrigger(" + name + ")"));
        try {
            return this.sched.getTrigger(TriggerKey.triggerKey((String)name));
        }
        catch (SchedulerException e) {
            this.logger.info((Object)("failed to get trigger:" + name));
            throw new JobManagerException("failed to get trigger:" + name, e);
        }
    }

    @Override
    public void connect(JobNet net, String upper, String lower) throws ClassCastException, ConditionBoardException {
        this.logger.trace((Object)("JobFacadeImpl.connect(" + net.getName() + "," + upper + "," + lower + ")"));
        net.connect(upper, lower);
    }

    @Override
    public void disconnect(JobNet net, String upper, String lower) {
        this.logger.trace((Object)("JobFacadeImpl.disconnect(" + net.getName() + "," + upper + "," + lower + ")"));
        net.disconnect(upper, lower);
    }

    @Override
    public void assignJobClass(String jobName, String className) throws JobManagerException {
        this.logger.trace((Object)("JobFacadeImpl.assignJob(" + jobName + "," + className + ")"));
        JobClassImpl jc = this.jobClassMap.get(className);
        if (jc == null) {
            this.logger.debug((Object)("no such jobclass(" + className + ") exist"));
            throw new JobManagerException("no such jobclass(" + className + ") exist");
        }
        jc.addJob(JobKey.jobKey((String)jobName));
    }

    @Override
    public void revokeJobClass(String jobName, String className) throws JobManagerException {
        this.logger.trace((Object)("JobFacadeImpl.revokeJobClass(" + jobName + "," + className + ")"));
        JobClassImpl jc = this.jobClassMap.get(className);
        if (jc == null) {
            this.logger.debug((Object)("no such jobclass(" + className + ") exist"));
            throw new JobManagerException("no such jobclass(" + className + ") exist");
        }
        jc.deleteJob(JobKey.jobKey((String)jobName));
    }

    @Override
    public void revokeJobClass(String className) throws JobManagerException {
        this.logger.trace((Object)("JobFacadeImpl.revokeJobClass(" + className + ")"));
        JobClassImpl jc = this.jobClassMap.get(className);
        if (jc != null) {
            List<JobKey> keylist = jc.getAssignedList();
            for (JobKey key : keylist) {
                jc.deleteJob(key);
            }
        } else {
            this.logger.debug((Object)("no such jobclass(" + className + ") exist"));
            throw new JobManagerException("no such jobclass(" + className + ") exist");
        }
    }

    @Override
    public Set<String> keySetJob() {
        return this.jobDetailMap.keySet();
    }

    @Override
    public Set<String> keySetClass() {
        return this.jobClassMap.keySet();
    }

    @Override
    public JobClass getJobClass(String name) {
        return this.jobClassMap.get(name);
    }

    @Override
    public boolean interruptJob(String name) throws JobManagerException {
        JobDetail job = this.getJob(name);
        try {
            return this.sched.interrupt(JobKey.jobKey((String)name));
        }
        catch (UnableToInterruptJobException e) {
            this.logger.info((Object)("failed to interrupt job: " + name));
            this.logger.debug((Object)"", (Throwable)e);
            throw new JobManagerException("failed to interrupt job: " + name, e);
        }
    }

    @Override
    public void pause() throws JobManagerException {
        try {
            this.sched.standby();
        }
        catch (SchedulerException e) {
            this.logger.warn((Object)"failed to set scheduler standby mode");
            this.logger.debug((Object)"", (Throwable)e);
            throw new JobManagerException("failed to set scheduler standby mode", e);
        }
    }

    @Override
    public void resume() throws JobManagerException {
        try {
            this.sched.start();
        }
        catch (SchedulerException e) {
            this.logger.warn((Object)"failed to resume scheduler");
            this.logger.debug((Object)"", (Throwable)e);
            throw new JobManagerException("failed to resume scheduler", e);
        }
    }

    @Override
    public JobKey jobKeyForName(String name) {
        return JobKey.jobKey((String)name);
    }

    @Override
    public TriggerKey triggerKeyForName(String name) {
        return TriggerKey.triggerKey((String)name);
    }

    @Override
    public void setJobLastingTime(String name, long timelength) throws JobManagerException {
        this.logger.trace((Object)("setJobLastingTime(" + name + "," + timelength + ")"));
        Long oTime = timelength < 0L ? Long.MAX_VALUE : Long.valueOf(timelength);
        try {
            JobDetail job = this.sched.getJobDetail(JobKey.jobKey((String)name));
            if (job == null) {
                this.logger.trace((Object)("no such job(" + name + ") to set lasting time"));
                throw new JobManagerException("no such job(" + name + ") to set lasting time");
            }
            JobDataMap data = job.getJobDataMap();
            data.put("MAXRUNTIME", (Object)oTime);
            this.sched.addJob(job, true);
        }
        catch (SchedulerException e) {
            this.logger.warn((Object)"failed to set job lasting length(time)");
            this.logger.debug((Object)"", (Throwable)e);
            throw new JobManagerException("failed to set job lasting length(time)", e);
        }
    }

    @Override
    public JobReceiver getJobReceiver(String name) {
        return this.jobReceiverMap.get(name);
    }

    @Override
    public void triggerJobNondurably(JobDetail job, Trigger trigger) throws JobManagerException {
        try {
            this.sched.deleteJob(job.getKey());
            JobBuilder builder = job.getJobBuilder();
            JobDetail jobToKick = builder.storeDurably(false).build();
            Trigger jobKicker = trigger.getTriggerBuilder().forJob(jobToKick).build();
            this.sched.scheduleJob(jobToKick, jobKicker);
        }
        catch (SchedulerException e) {
            this.logger.warn((Object)("failed to trigger job :" + job.getKey().getName()));
            this.logger.trace((Object)"", (Throwable)e);
            throw new JobManagerException("failed to trigger job :" + job.getKey().getName(), e);
        }
    }

    @Override
    public Set<String> getRunningJobSet() {
        HashSet<String> jobNameList = new HashSet<String>();
        try {
            List elist = this.sched.getCurrentlyExecutingJobs();
            for (JobExecutionContext je : elist) {
                jobNameList.add(je.getJobDetail().getKey().getName());
            }
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
        return jobNameList;
    }

    @Override
    public long getJobNextFireLatency(String jobname) throws JobManagerException {
        List<Trigger> tlist = this.getRelatedTrigger(jobname);
        long minlatency = -1L;
        long now = new Date().getTime();
        for (Trigger t : tlist) {
            Date next = t.getNextFireTime();
            if (next == null) continue;
            long latency = next.getTime() - now;
            if (minlatency < 0L) {
                minlatency = latency;
                continue;
            }
            if (latency >= minlatency) continue;
            minlatency = latency;
        }
        return minlatency;
    }

    @Override
    public List<Trigger> getRelatedTrigger(String jobname) throws JobManagerException {
        try {
            return this.sched.getTriggersOfJob(this.jobKeyForName(jobname));
        }
        catch (SchedulerException e) {
            throw new JobManagerException("failed to retrieve trigger for job: " + jobname, e);
        }
    }

    @Override
    public int getJobRunningCount(String jobname) {
        int count = 0;
        try {
            List elist = this.sched.getCurrentlyExecutingJobs();
            for (JobExecutionContext je : elist) {
                String jname = je.getJobDetail().getKey().getName();
                if (jname == null || !jname.equals(jobname)) continue;
                ++count;
            }
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
        return count;
    }

    public void setMaxReceiveSize(int size) {
        this.maxReceiveSize = size;
    }

    public void setMaxHistoryDepth(int maxDepth) {
        this.maxHistoryDepth = maxDepth;
    }

    @Override
    public void setJobDataReceiveSize(String name, int size) throws JobManagerException {
        JobDetail job = null;
        try {
            job = this.sched.getJobDetail(this.jobKeyForName(name));
            if (job != null) {
                job.getJobBuilder().usingJobData("maxDataSize", Integer.valueOf(size));
                this.sched.addJob(job, true);
                return;
            }
        }
        catch (SchedulerException e) {
            throw new JobManagerException("failed to get job detail", e);
        }
        throw new JobManagerException("no such job exist(" + name + ")");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getJobDataReceiveSize(String name) throws JobManagerException {
        JobDetail job = this.jobDetailMap.get(name);
        int maxDataSize = this.maxReceiveSize;
        if (job == null) throw new JobManagerException("no such job exist(" + name + ")");
        try {
            Integer v = (Integer)job.getJobDataMap().get((Object)"maxDataSize");
            if (v == null) return maxDataSize;
            return v;
        }
        catch (Exception e) {
            throw new JobManagerException("failed to get property", e);
        }
    }

    @Override
    public void setJobHistoryLength(String name, int length) throws JobManagerException {
        JobReceiverImpl receiver = (JobReceiverImpl)this.jobReceiverMap.get(name);
        if (receiver == null) {
            throw new JobManagerException("no such job exist(" + name + ")");
        }
        receiver.setHistorySize(length);
    }

    @Override
    public int getJobHistoryLength(String name) throws JobManagerException {
        JobReceiverImpl receiver = (JobReceiverImpl)this.jobReceiverMap.get(name);
        if (receiver != null) {
            return receiver.getHistorySize();
        }
        throw new JobManagerException("no such job exist (" + name + ")");
    }

    @Override
    public JobClass[] findJobClassForJob(String jobName) {
        HashSet<JobClass> jcs = new HashSet<JobClass>();
        Set<String> jckeys = this.jobClassMap.keySet();
        block0: for (String k : jckeys) {
            JobClass c = this.jobClassMap.get(k);
            List<JobKey> jklist = c.getAssignedList();
            for (JobKey jk : jklist) {
                if (!jk.getName().equals(jobName)) continue;
                jcs.add(c);
                continue block0;
            }
        }
        JobClass[] rarray = new JobClass[jcs.size()];
        jcs.toArray(rarray);
        return rarray;
    }

    @Override
    public Object getSchedulerObject() {
        return this.sched;
    }

    private final class FacadeTriggerListener
    implements TriggerListener {
        private final String name;

        public FacadeTriggerListener(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void triggerComplete(Trigger arg0, JobExecutionContext arg1, Trigger.CompletedExecutionInstruction arg2) {
        }

        public void triggerFired(Trigger arg0, JobExecutionContext arg1) {
        }

        public void triggerMisfired(Trigger arg0) {
            JobReceiver jr = (JobReceiver)JobFacadeImpl.this.jobReceiverMap.get(arg0.getJobKey().getName());
            jr.putEvent(arg0.getKey().getName(), TriggerReceiver.TRIGGEREVENT.MISFIRED, new Date());
        }

        public boolean vetoJobExecution(Trigger arg0, JobExecutionContext arg1) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class JobNetImpl
    implements JobNet {
        private final String name;
        private Map<String, Object> nodeMap = new HashMap<String, Object>();
        private Logger logger = Logger.getLogger((String)"com.insight_tec.pi.jobmanager");

        public JobNetImpl(String name) {
            this.name = name;
            this.logger.trace((Object)("constractor JobNetImpl(" + name + "," + JobFacadeImpl.this.sched.toString() + ")"));
        }

        @Override
        public Terminal createForceRunTerminal(String name, String jobName) {
            JobKey k = JobKey.jobKey((String)jobName);
            ForceRunTerminal t = new ForceRunTerminal(name, JobFacadeImpl.this.sched, k);
            this.nodeMap.put(name, t);
            this.logger.trace((Object)("JobNet(" + this.name + ").createForceRunTerminal(" + name + "," + jobName + ") -> " + ((Object)t).toString()));
            return t;
        }

        @Override
        public Terminal createProhibitTerminal(String name, String jobName) {
            ProhibitTerminal t;
            JobKey k = JobKey.jobKey((String)jobName);
            try {
                t = new ProhibitTerminal(name, JobFacadeImpl.this.sched, k);
            }
            catch (SchedulerException e) {
                this.logger.info((Object)"failed to create prohibit terminal");
                return null;
            }
            this.nodeMap.put(name, t);
            this.logger.trace((Object)("JobNet(" + this.name + ").createProhibitTerminal(" + name + "," + jobName + ") -> " + ((Object)t).toString()));
            return t;
        }

        @Override
        public Operator createOrOperator(String name) {
            OrOperator o = new OrOperator(name);
            this.nodeMap.put(name, o);
            this.logger.trace((Object)("JobNet(" + this.name + ").createOrOperator(" + name + ") -> " + ((Object)o).toString()));
            return o;
        }

        @Override
        public Operator createAndOperator(String name) {
            AndOperator o = new AndOperator(name);
            this.nodeMap.put(name, o);
            this.logger.trace((Object)("JobNet(" + this.name + ").createAndOperator(" + name + ") -> " + ((Object)o).toString()));
            return o;
        }

        @Override
        public Operator createXorOperator(String name) {
            XorOperator o = new XorOperator(name);
            this.nodeMap.put(name, o);
            this.logger.trace((Object)("JobNet(" + this.name + ").createXorOperator(" + name + ") -> " + ((Object)o).toString()));
            return o;
        }

        @Override
        public Operator createNotOperator(String name) {
            NotOperator o = new NotOperator(name);
            this.nodeMap.put(name, o);
            this.logger.trace((Object)("JobNet(" + this.name + ").createNotOperator(" + name + ") -> " + ((Object)o).toString()));
            return o;
        }

        @Override
        public Operator createCounterOperator(String name, int count) {
            CounterOperator o = new CounterOperator(name, count);
            this.nodeMap.put(name, o);
            this.logger.trace((Object)("JobNet(" + this.name + ").createNotOperator(" + name + ") -> " + o.toString()));
            return o;
        }

        @Override
        public Receiver createInterruptFollower(String name) {
            PseudoReceiver f = new PseudoReceiver();
            this.nodeMap.put(name, f);
            this.logger.trace((Object)("JobNet(" + this.name + ").createInterruptFollower(" + name + ") -> " + f.toString()));
            return f;
        }

        @Override
        public void interruptNet(String portName, boolean v) {
            this.logger.trace((Object)("JobNet(" + this.name + ").interruptNet(" + portName + "," + v + ")"));
            try {
                PseudoReceiver f = (PseudoReceiver)this.nodeMap.get(portName);
                if (f != null) {
                    f.interruptNet(v);
                    return;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            this.logger.info((Object)("stray interruption(" + portName + ") to jobnet:" + this.name));
        }

        @Override
        public List<? extends Object> getNodeList() {
            this.logger.trace((Object)("JobNet(" + this.name + ").getNodeList()"));
            ArrayList<Object> list = new ArrayList<Object>();
            Set<String> keys = this.nodeMap.keySet();
            for (String k : keys) {
                list.add(this.nodeMap.get(k));
            }
            return list;
        }

        @Override
        public Object getNode(String name) {
            return this.nodeMap.get(name);
        }

        @Override
        public void connect(String upper, String lower) throws ClassCastException, ConditionBoardException {
            this.logger.trace((Object)("JobNet(" + this.name + ").connect(" + upper + "," + lower + ")"));
            Predecessor oUpper = (Predecessor)this.nodeMap.get(upper);
            Follower oLower = (Follower)this.nodeMap.get(lower);
            this.logger.trace((Object)("" + this.name + ".connect(" + upper + "," + lower + ")"));
            if (oUpper == null) {
                this.logger.trace((Object)("no node(" + upper + ") found in nodemap of JobNet(" + this.name + ")"));
                oUpper = (Predecessor)JobFacadeImpl.this.jobReceiverMap.get(upper);
                if (oUpper == null) {
                    this.logger.debug((Object)("no JobReceiver'" + upper + "' found, upper object is null"));
                }
                this.nodeMap.put(upper, oUpper);
            }
            if (oUpper != null && oLower != null) {
                try {
                    oLower.connectUpperFlow(oUpper);
                }
                catch (ConditionBoardException e) {
                    this.logger.info((Object)("establishing jobnet node connection failed between " + upper + " and " + lower));
                    throw e;
                }
            } else {
                this.logger.info((Object)("no such a jobnet node exist:" + (oUpper == null ? upper : (oLower == null ? lower : ""))));
            }
        }

        @Override
        public void disconnect(String upper, String lower) {
            this.logger.trace((Object)("JobNet(" + this.name + ").disconnect(" + upper + "," + lower));
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

