/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.jobmanager.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Matcher;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.matchers.KeyMatcher;
import org.quartz.utils.Key;
import org.wiperdog.jobmanager.ConditionBoardException;
import org.wiperdog.jobmanager.Flow;
import org.wiperdog.jobmanager.JobPatchBoard;
import org.wiperdog.jobmanager.JobReceiver;
import org.wiperdog.jobmanager.JobResult;
import org.wiperdog.jobmanager.RootJobReceiver;
import org.wiperdog.jobmanager.TriggerReceiver;
import org.wiperdog.jobmanager.internal.JobResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JobReceiverImpl
implements JobReceiver,
RootJobReceiver {
    private final JobKey jobkey;
    private final String id = "FOLLOWER_" + JobPatchBoard.getSequenceNumber();
    private final List<Flow> outList = new ArrayList<Flow>();
    private final List<JobResult> resultList = new ArrayList<JobResult>();
    private int historySize = 10;
    private boolean pval = false;
    private Logger logger = Logger.getLogger((String)"com.insight_tec.pi.jobmanager");
    private PseudoJobReceiver intReceiver = new PseudoJobReceiver("_INTERRUPTED");
    private PseudoJobReceiver misReceiver = new PseudoJobReceiver("_MISFIRED");
    private PseudoJobReceiver outPatternReceiver = new PseudoJobReceiver("_OUTPATTERN");
    private PseudoJobReceiver errPatternReceiver = new PseudoJobReceiver("_ERRPATTERN");
    private RootJobReceiver.ASSIGNMENT interruptedAssignment = RootJobReceiver.ASSIGNMENT.CONVERT_FALSE;
    private RootJobReceiver.ASSIGNMENT misfiredAssignment = RootJobReceiver.ASSIGNMENT.VOID;
    private RootJobReceiver.ASSIGNMENT outPatternAssignment = RootJobReceiver.ASSIGNMENT.VOID;
    private RootJobReceiver.ASSIGNMENT errPatternAssignment = RootJobReceiver.ASSIGNMENT.VOID;
    private Pattern outPattern;
    private Pattern errPattern;

    public String toString() {
        String str = this.getClass().getSimpleName() + "(" + this.jobkey.getName() + "), outlist: {";
        for (Flow f : this.outList) {
            str = str + f.getId() + ",";
        }
        str = str + "}";
        return str;
    }

    public JobReceiverImpl(Scheduler sched, JobKey jobkey) throws SchedulerException {
        this.jobkey = jobkey;
        sched.getListenerManager().addJobListener((JobListener)new NodeJobListener(), (Matcher)KeyMatcher.keyEquals((Key)jobkey));
    }

    public JobReceiverImpl(Scheduler sched, JobKey jobkey, int maxHistory) throws SchedulerException {
        this.jobkey = jobkey;
        sched.getListenerManager().addJobListener((JobListener)new NodeJobListener(), (Matcher)KeyMatcher.keyEquals((Key)jobkey));
        this.historySize = maxHistory;
    }

    public void setHistorySize(int size) {
        this.historySize = size;
    }

    public int getHistorySize() {
        return this.historySize;
    }

    @Override
    public JobKey getJobKey() {
        return this.jobkey;
    }

    @Override
    public void addOutFlow(Flow f) {
        this.outList.add(f);
    }

    @Override
    public void deleteOutFlow(Flow f) {
        this.outList.remove(f);
    }

    private void output(boolean v) {
        for (Flow f : this.outList) {
            f.call(v);
        }
    }

    private void pushJobResult(JobResult jr) {
        this.resultList.add(jr);
        if (this.resultList.size() > this.historySize) {
            this.resultList.remove(0);
        }
    }

    @Override
    public Flow[] getOutFlows() {
        Flow[] ofs = new Flow[this.outList.size()];
        this.outList.toArray(ofs);
        return ofs;
    }

    @Override
    public int resultCount() {
        return this.resultList.size();
    }

    @Override
    public List<JobResult> getJobResultList() {
        return this.resultList;
    }

    @Override
    public JobResult getJobResult(int index) {
        return this.resultList.get(index);
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public boolean getPValue() {
        return this.pval;
    }

    @Override
    public void putEvent(String name, TriggerReceiver.TRIGGEREVENT event, Date date) {
        JobResultImpl jr = new JobResultImpl(this.jobkey.getName());
        switch (event) {
            case MISFIRED: {
                jr.setLastStatus(JobResult.JOBSTATUS.MISFIRED);
            }
        }
        this.pushJobResult(jr);
    }

    public JobReceiver getInterruptedReceiver() {
        return this.intReceiver;
    }

    public JobReceiver getMisfiredReceiver() {
        return this.misReceiver;
    }

    public JobReceiver getOutPatternReceiver() {
        return this.outPatternReceiver;
    }

    public JobReceiver getErrPatternReceiver() {
        return this.errPatternReceiver;
    }

    @Override
    public void setInterruptedAssignement(RootJobReceiver.ASSIGNMENT a) {
        this.logger.trace((Object)(this.getClass().getSimpleName() + ".setInterruptedAssignement(" + a.name() + ")"));
        this.interruptedAssignment = a;
    }

    @Override
    public void setMisfiredAssignment(RootJobReceiver.ASSIGNMENT a) {
        this.logger.trace((Object)(this.getClass().getSimpleName() + ".setMisfiredAssignment(" + a.name() + ")"));
        this.misfiredAssignment = a;
    }

    @Override
    public void setOutPatternAssignment(RootJobReceiver.ASSIGNMENT a) {
        this.outPatternAssignment = a;
    }

    @Override
    public void setErrPatternAssignment(RootJobReceiver.ASSIGNMENT a) {
        this.errPatternAssignment = a;
    }

    @Override
    public void setOutPattern(String pattern) {
        if (pattern == null) {
            this.outPattern = null;
        } else {
            try {
                this.outPattern = Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                this.outPattern = null;
            }
        }
    }

    @Override
    public void setErrPattern(String pattern) {
        if (pattern == null) {
            this.errPattern = null;
        } else {
            try {
                this.errPattern = Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                this.errPattern = null;
            }
        }
    }

    public void addJobResult(JobResult jr) {
        this.pushJobResult(jr);
    }

    private class NodeJobListener
    implements JobListener {
        private NodeJobListener() {
        }

        public String getName() {
            return JobReceiverImpl.this.id;
        }

        public void jobToBeExecuted(JobExecutionContext context) {
        }

        public void jobExecutionVetoed(JobExecutionContext context) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
            JobDataMap datamap;
            block28: {
                boolean v;
                block34: {
                    block32: {
                        block33: {
                            boolean bErrMatched;
                            block31: {
                                block29: {
                                    block30: {
                                        datamap = context.getJobDetail().getJobDataMap();
                                        Set p = (Set)datamap.get((Object)"prohibit");
                                        if (p != null && p.size() != 0) break block28;
                                        v = true;
                                        if (jobException != null) {
                                            v = false;
                                        } else {
                                            try {
                                                Boolean r = (Boolean)context.getResult();
                                                if (r == null || !r.booleanValue()) {
                                                    v = false;
                                                }
                                            }
                                            catch (ClassCastException e) {
                                                v = false;
                                            }
                                            if (v) {
                                                try {
                                                    Boolean b = (Boolean)context.getMergedJobDataMap().get((Object)"jobexecutionfailed");
                                                    if (b != null && b.booleanValue()) {
                                                        v = false;
                                                    }
                                                }
                                                catch (ClassCastException e) {
                                                    v = false;
                                                }
                                            }
                                        }
                                        JobResultImpl jr = (JobResultImpl)datamap.get((Object)"jobresult");
                                        if (jr == null) {
                                            JobReceiverImpl.this.logger.warn((Object)"Somethins is wrong in logic");
                                            return;
                                        }
                                        JobReceiverImpl.this.logger.trace((Object)("jobresult.started: " + jr.getStartedAt()));
                                        JobReceiverImpl.this.logger.trace((Object)("jobresult.ended: " + jr.getEndedAt()));
                                        JobReceiverImpl.this.logger.trace((Object)("jobresult.interrupted: " + jr.getInterruptedAt()));
                                        JobReceiverImpl.this.logger.trace((Object)("jobresult.getLastStatus() = " + jr.getLastStatus().name()));
                                        JobReceiverImpl.this.pushJobResult(jr);
                                        if (jr.getLastStatus() == JobResult.JOBSTATUS.INTERRUPTED) {
                                            if (JobReceiverImpl.this.interruptedAssignment == RootJobReceiver.ASSIGNMENT.CONVERT_FALSE) {
                                                v = false;
                                            } else {
                                                if (JobReceiverImpl.this.interruptedAssignment != RootJobReceiver.ASSIGNMENT.CONVERT_TRUE) {
                                                    if (JobReceiverImpl.this.interruptedAssignment != RootJobReceiver.ASSIGNMENT.PSEUDOJOB) return;
                                                    JobReceiverImpl.this.intReceiver.call(true);
                                                    return;
                                                }
                                                v = true;
                                            }
                                        } else if (JobReceiverImpl.this.interruptedAssignment == RootJobReceiver.ASSIGNMENT.PSEUDOJOB) {
                                            JobReceiverImpl.this.intReceiver.call(false);
                                        }
                                        String strStdout = (String)datamap.get((Object)"stdout");
                                        String strStderr = (String)datamap.get((Object)"stderr");
                                        Integer exitCode = (Integer)datamap.get((Object)"exitcode");
                                        jr.putData("stdout", strStdout);
                                        jr.putData("stderr", strStderr);
                                        jr.putData("exitcode", exitCode);
                                        boolean bOutMatched = false;
                                        if (strStdout != null && JobReceiverImpl.this.outPattern != null) {
                                            JobReceiverImpl.this.logger.trace((Object)("check stdout match: " + JobReceiverImpl.this.outPattern.pattern() + ":" + strStdout));
                                            bOutMatched = JobReceiverImpl.this.outPattern.matcher(new StringBuffer(strStdout)).matches();
                                        }
                                        bErrMatched = false;
                                        if (strStderr != null && JobReceiverImpl.this.errPattern != null) {
                                            JobReceiverImpl.this.logger.trace((Object)("check stderr match: " + JobReceiverImpl.this.errPattern.pattern() + ":" + strStderr));
                                            bErrMatched = JobReceiverImpl.this.errPattern.matcher(new StringBuffer(strStderr)).matches();
                                        }
                                        if (!bOutMatched) break block29;
                                        if (JobReceiverImpl.this.outPatternAssignment != RootJobReceiver.ASSIGNMENT.CONVERT_FALSE) break block30;
                                        v = false;
                                        break block31;
                                    }
                                    if (JobReceiverImpl.this.outPatternAssignment == RootJobReceiver.ASSIGNMENT.CONVERT_TRUE) {
                                        v = true;
                                        break block31;
                                    } else if (JobReceiverImpl.this.outPatternAssignment == RootJobReceiver.ASSIGNMENT.PSEUDOJOB) {
                                        JobReceiverImpl.this.outPatternReceiver.call(true);
                                    }
                                    break block31;
                                }
                                if (JobReceiverImpl.this.outPatternAssignment == RootJobReceiver.ASSIGNMENT.PSEUDOJOB) {
                                    JobReceiverImpl.this.outPatternReceiver.call(false);
                                }
                            }
                            if (!bErrMatched) break block32;
                            if (JobReceiverImpl.this.errPatternAssignment != RootJobReceiver.ASSIGNMENT.CONVERT_FALSE) break block33;
                            v = false;
                            break block34;
                        }
                        if (JobReceiverImpl.this.errPatternAssignment == RootJobReceiver.ASSIGNMENT.CONVERT_TRUE) {
                            v = true;
                            break block34;
                        } else if (JobReceiverImpl.this.errPatternAssignment == RootJobReceiver.ASSIGNMENT.PSEUDOJOB) {
                            JobReceiverImpl.this.errPatternReceiver.call(true);
                        }
                        break block34;
                    }
                    if (JobReceiverImpl.this.errPatternAssignment == RootJobReceiver.ASSIGNMENT.PSEUDOJOB) {
                        JobReceiverImpl.this.errPatternReceiver.call(false);
                    }
                }
                JobReceiverImpl.this.pval = v;
                JobReceiverImpl.this.output(v);
                return;
            }
            JobResultImpl jr = (JobResultImpl)datamap.get((Object)"jobresult");
            if (jr == null) {
                JobReceiverImpl.this.logger.warn((Object)"Somethins is wrong in logic");
                return;
            }
            JobReceiverImpl.this.logger.trace((Object)("jobresult.started: " + jr.getStartedAt()));
            JobReceiverImpl.this.logger.trace((Object)("jobresult.ended: " + jr.getEndedAt()));
            JobReceiverImpl.this.logger.trace((Object)("jobresult.interrupted: " + jr.getInterruptedAt()));
            JobReceiverImpl.this.logger.trace((Object)("jobresult.getLastStatus() = " + jr.getLastStatus().name()));
            JobReceiverImpl.this.pushJobResult(jr);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PseudoJobReceiver
    implements JobReceiver {
        private final List<Flow> outList = new ArrayList<Flow>();
        private boolean pvalue = false;
        private final String nameSuffix;

        public PseudoJobReceiver(String suffix) {
            this.nameSuffix = suffix;
        }

        @Override
        public JobKey getJobKey() {
            return JobReceiverImpl.this.jobkey;
        }

        @Override
        public void addOutFlow(Flow f) throws ConditionBoardException {
            this.outList.add(f);
        }

        @Override
        public void deleteOutFlow(Flow f) throws ConditionBoardException {
            this.outList.remove(f);
        }

        @Override
        public Flow[] getOutFlows() {
            Flow[] oa = new Flow[this.outList.size()];
            return this.outList.toArray(oa);
        }

        @Override
        public int resultCount() {
            return JobReceiverImpl.this.resultCount();
        }

        @Override
        public JobResult getJobResult(int index) {
            return JobReceiverImpl.this.getJobResult(index);
        }

        @Override
        public List<JobResult> getJobResultList() {
            return JobReceiverImpl.this.getJobResultList();
        }

        @Override
        public String getName() {
            return JobReceiverImpl.this.getName() + this.nameSuffix;
        }

        @Override
        public boolean getPValue() {
            return this.pvalue;
        }

        @Override
        public void putEvent(String name, TriggerReceiver.TRIGGEREVENT event, Date date) {
        }

        public void call(boolean v) {
            JobReceiverImpl.this.logger.trace((Object)(this.getName() + ".call(" + v + ")"));
            JobReceiverImpl.this.logger.trace((Object)(" outList has " + this.outList.size() + " followers"));
            this.pvalue = v;
            for (Flow f : this.outList) {
                f.call(v);
            }
        }
    }
}

