/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.jobmanager.internal;

import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Matcher;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.matchers.KeyMatcher;
import org.quartz.utils.Key;
import org.wiperdog.jobmanager.internal.AbstractTerminal;

public final class ProhibitTerminal
extends AbstractTerminal {
    private final Scheduler scheduler;
    private boolean bOpen = false;
    private long openedAt = 0L;
    private long gateTimer = 0L;
    private final Logger logger = Logger.getLogger((String)"com.insight_tec.pi.jobmanager");
    public static final String REASONKEY_JOBNODE = "" + ProhibitTerminal.class.getName();

    protected ProhibitTerminal(String name, Scheduler scheduler, JobKey jobkey) throws SchedulerException {
        super(name, jobkey);
        this.logger.trace((Object)("ProhibitTerminal.ProhibitTerminal(" + name + "," + scheduler.toString() + "," + jobkey.toString() + ")"));
        this.scheduler = scheduler;
        scheduler.getListenerManager().addJobListener((JobListener)new NodeJobListener(), (Matcher)KeyMatcher.keyEquals((Key)jobkey));
    }

    public void setGateTimer(long interval) {
        this.logger.trace((Object)("ProhibitTerminal.setGateTimer(" + interval + ")"));
        this.gateTimer = interval;
    }

    protected void update(boolean v) {
        this.logger.trace((Object)("ProhibitTerminal.update(" + v + ")"));
        this.bOpen = v;
        if (v) {
            this.openedAt = new Date().getTime();
        }
    }

    public boolean getPValue() {
        return this.bOpen;
    }

    private final class NodeJobListener
    implements JobListener {
        public NodeJobListener() {
            ProhibitTerminal.this.logger.trace((Object)"NodeJobListener.NodeJobListener()");
        }

        public String getName() {
            ProhibitTerminal.this.logger.trace((Object)"NodeJobListener.getName()");
            return ProhibitTerminal.this.id;
        }

        public void jobToBeExecuted(JobExecutionContext context) {
            ProhibitTerminal.this.logger.trace((Object)"NodeJobListener.jobToBeExecuted()");
            ProhibitTerminal.this.logger.trace((Object)("\tbOpen:" + ProhibitTerminal.this.bOpen));
            HashSet<String> p = (HashSet<String>)context.getMergedJobDataMap().get((Object)"prohibit");
            if (p == null) {
                p = new HashSet<String>();
                context.getJobDetail().getJobDataMap().put("prohibit", p);
            }
            if (!ProhibitTerminal.this.bOpen || ProhibitTerminal.this.gateTimer != 0L && ProhibitTerminal.this.openedAt + ProhibitTerminal.this.gateTimer < new Date().getTime()) {
                p.add(REASONKEY_JOBNODE);
            } else {
                p.remove(REASONKEY_JOBNODE);
            }
        }

        public void jobExecutionVetoed(JobExecutionContext context) {
            ProhibitTerminal.this.logger.trace((Object)"NodeJobListener.jobExecutionVetoed()");
        }

        public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
            ProhibitTerminal.this.logger.trace((Object)"NodeJobListener.jobWasExecuted()");
        }
    }
}

