/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.jobmanager.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.quartz.JobKey;
import org.wiperdog.jobmanager.Flow;
import org.wiperdog.jobmanager.JobPatchBoard;
import org.wiperdog.jobmanager.Node;
import org.wiperdog.jobmanager.Receiver;

public class PseudoReceiver
implements Receiver,
Node {
    private final String id;
    private boolean pval = false;
    private final List<Flow> outList = new ArrayList<Flow>();
    private static final String PSEUDOGROUPNAME = "PSEUDO";
    private final Logger logger = Logger.getLogger((String)"com.insight_tec.pi.jobmanager");

    public PseudoReceiver() {
        this.logger.trace((Object)"PseudoReceiver.PseudoReceiver()");
        this.id = "FOLLOWER_" + JobPatchBoard.getSequenceNumber();
    }

    public PseudoReceiver(String name) {
        this.logger.trace((Object)("PseudoReceiver.PseudoReceiver(" + name + ")"));
        this.id = name;
    }

    public JobKey getJobKey() {
        this.logger.trace((Object)"PseudoReceiver.getJobKey()");
        return JobKey.jobKey((String)PSEUDOGROUPNAME, (String)this.id);
    }

    public void addOutFlow(Flow f) {
        this.logger.trace((Object)("PseudoReceiver.addOutFlow(" + f.toString() + ")"));
        this.outList.add(f);
    }

    public void deleteOutFlow(Flow f) {
        this.logger.trace((Object)("PseudoReceiver.deleteOutFlow(" + f.toString() + ")"));
        this.outList.remove(f);
    }

    public void interruptNet(boolean v) {
        this.logger.trace((Object)("PseudoReceiver.interruptNet(" + v + ")"));
        this.pval = v;
        for (Flow f : this.outList) {
            f.call(v);
        }
    }

    public Flow[] getOutFlows() {
        Flow[] ofs = new Flow[this.outList.size()];
        this.outList.toArray(ofs);
        return ofs;
    }

    public String getName() {
        return this.id;
    }

    public boolean getPValue() {
        return this.pval;
    }
}

