/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.rshell.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.wiperdog.rshell.api.VolatileDataWriter;

public class StreamInputProcessor
implements Runnable {
    private static final int BUFSIZE = 1024;
    private final InputStreamReader reader;
    private Thread me;
    private boolean bRun = false;
    private VolatileDataWriter writer;

    public StreamInputProcessor(InputStream is, File tmpfile, int maxsize) {
        this.reader = new InputStreamReader(is);
        this.writer = new VolatileDataWriter(tmpfile, maxsize);
    }

    public StreamInputProcessor(InputStream is, File tmpfile, int maxsize, Charset cs) {
        this.reader = new InputStreamReader(is, cs);
        this.writer = new VolatileDataWriter(tmpfile, maxsize);
    }

    private void setThread(Thread t) {
        this.me = t;
    }

    public void run() {
        this.bRun = true;
        char[] cbuf = new char[1024];
        while (this.bRun) {
            try {
                int sizeread = this.reader.read(cbuf);
                if (sizeread <= 0) break;
                this.writer.write(cbuf, 0, sizeread);
            }
            catch (IOException iOException) {}
        }
    }

    public void stop() {
        this.bRun = false;
        this.me.interrupt();
        try {
            this.reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        this.writer.clear();
    }

    public void writeTo(Writer to) {
        this.writer.WriteTo(to);
    }

    public static StreamInputProcessor start(InputStream is, String tmpfilepath, int maxsize) {
        File tmpfile = null;
        if (tmpfilepath != null && tmpfilepath.length() > 0) {
            tmpfile = new File(tmpfilepath);
        }
        StreamInputProcessor processor = new StreamInputProcessor(is, tmpfile, maxsize);
        Thread t = new Thread(processor);
        processor.setThread(t);
        t.start();
        return processor;
    }
}

