/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.rshell.api;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class VolatileDataWriter
extends Writer {
    private static final int BUFFSIZE = 4096;
    private File tmpfile;
    private Writer delegate;
    private int maxsize;
    private int currentsize = 0;

    public VolatileDataWriter(File tmpfile, int maxsize) {
        this.tmpfile = tmpfile;
        this.maxsize = maxsize;
        if (tmpfile == null) {
            this.delegate = new CharArrayWriter();
        } else {
            try {
                this.delegate = new FileWriter(tmpfile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void close() throws IOException {
        if (this.delegate == null) {
            throw new IOException("no delegating writer exist");
        }
        if (this.tmpfile != null) {
            ((FileWriter)this.delegate).close();
        }
    }

    public void flush() throws IOException {
        if (this.delegate == null) {
            throw new IOException("no delegating writer exist");
        }
        if (this.tmpfile != null) {
            ((FileWriter)this.delegate).flush();
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        int lentowrite = len;
        if (this.currentsize >= this.maxsize) {
            return;
        }
        lentowrite = this.maxsize - this.currentsize > len ? len : this.maxsize - this.currentsize;
        this.delegate.write(cbuf, off, lentowrite);
        this.currentsize += lentowrite;
    }

    public void clear() {
        if (this.tmpfile != null) {
            try {
                ((FileWriter)this.delegate).close();
                this.tmpfile.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ((CharArrayWriter)this.delegate).close();
        }
    }

    private void writeFileTo(Writer to) {
        FileReader reader = null;
        try {
            int rsize;
            reader = new FileReader(this.tmpfile);
            char[] buff = new char[4096];
            while ((rsize = reader.read(buff)) > 0) {
                to.write(buff, 0, rsize);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void WriteTo(Writer to) {
        if (this.tmpfile != null) {
            this.writeFileTo(to);
        } else if (this.delegate instanceof CharArrayWriter) {
            try {
                ((CharArrayWriter)this.delegate).writeTo(to);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

