/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.installer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.wiperdog.installer.Redirector;
import org.wiperdog.installer.internal.InstallerUtil;
import org.wiperdog.installer.internal.InstallerXML;
import org.wiperdog.installer.internal.XMLErrorHandler;

public class SelfExtractorCmd {
    public static String OUTPUT_FOLDER = "";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        ArrayList<String> listParams = new ArrayList<String>();
        listParams.add("-d");
        listParams.add("-j");
        listParams.add("-m");
        listParams.add("-p");
        listParams.add("-n");
        listParams.add("-u");
        listParams.add("-pw");
        listParams.add("-mp");
        listParams.add("-s");
        List<String> listArgs = Arrays.asList(args);
        try {
            File outputDir;
            if (args.length < 2 || !args[0].trim().equals("-d")) {
                System.out.println("Wrong parameter. Usage:\n \t\t java -jar [Installer Jar] -d [INSTALL_PATH>] \n \t\t or \n \t\t java -jar [Installer Jar] -d [INSTALL_PATH] -j [jettyport] -m [mongodb host] -p [mongodb port] -n [mongodb database name] -u [mongodb user name] -pw [mongodb password] -mp [mail policy] -s [yes/no install as OS service]");
                System.exit(0);
            }
            ArrayList defaultParams = new ArrayList();
            for (int i = 1; i < listParams.size(); ++i) {
                if (listArgs.contains(listParams.get(i))) continue;
                defaultParams.add(listParams.get(i));
            }
            String strArgs = "";
            if (args.length > 2) {
                int i;
                for (i = 1; i < args.length; ++i) {
                    if (args[i].equals("-j")) {
                        if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim())) {
                            if (!SelfExtractorCmd.isNumeric(args[i + 1])) {
                                System.out.println("Jetty port must be number: " + args[i]);
                                return;
                            }
                            strArgs = strArgs + "-j " + args[i + 1] + " ";
                            ++i;
                        } else {
                            System.out.println("Incorrect value of params: " + args[i]);
                            return;
                        }
                    }
                    if (args[i].equals("-m")) {
                        if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim())) {
                            strArgs = strArgs + "-m " + args[i + 1] + " ";
                            ++i;
                        } else {
                            System.out.println("Incorrect value of params: " + args[i]);
                            return;
                        }
                    }
                    if (args[i].equals("-p")) {
                        if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim())) {
                            if (!SelfExtractorCmd.isNumeric(args[i + 1])) {
                                System.out.println("Mongodb port must be number: " + args[i]);
                                return;
                            }
                            strArgs = strArgs + "-p " + args[i + 1] + " ";
                            ++i;
                        } else {
                            System.out.println("Incorrect value of params: " + args[i]);
                            return;
                        }
                    }
                    if (args[i].equals("-n")) {
                        if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim())) {
                            strArgs = strArgs + "-n " + args[i + 1] + " ";
                            ++i;
                        } else {
                            System.out.println("Incorrect value of params: " + args[i]);
                            return;
                        }
                    }
                    if (args[i].equals("-u")) {
                        if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim())) {
                            strArgs = strArgs + "-u " + args[i + 1] + " ";
                            ++i;
                        } else {
                            System.out.println("Incorrect value of params: " + args[i]);
                            return;
                        }
                    }
                    String pattern = "[a-zA-Z0-9]+";
                    if (args[i].equals("-pw")) {
                        if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim()) && args[i + 1].matches(pattern)) {
                            strArgs = strArgs + "-pw " + args[i + 1] + " ";
                            ++i;
                        } else {
                            System.out.println("Incorrect value of params: " + args[i]);
                            return;
                        }
                    }
                    if (args[i].equals("-mp")) {
                        if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim())) {
                            strArgs = strArgs + "-mp " + args[i + 1] + " ";
                            ++i;
                        } else {
                            System.out.println("Incorrect value of params: " + args[i]);
                            return;
                        }
                    }
                    if (!args[i].equals("-s")) continue;
                    if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim())) {
                        strArgs = strArgs + "-s " + args[i + 1] + " ";
                        ++i;
                        continue;
                    }
                    System.out.println("Incorrect value of params: " + args[i]);
                    return;
                }
                for (i = 0; i < defaultParams.size(); ++i) {
                    if (defaultParams.get(i) == "-j") {
                        strArgs = strArgs + "-j 13110 ";
                    }
                    if (defaultParams.get(i) == "-m") {
                        strArgs = strArgs + "-m 127.0.0.1 ";
                    }
                    if (defaultParams.get(i) == "-p") {
                        strArgs = strArgs + "-p 27017 ";
                    }
                    if (defaultParams.get(i) == "-n") {
                        strArgs = strArgs + "-n wiperdog ";
                    }
                    if (defaultParams.get(i) == "-mp") {
                        strArgs = strArgs + "-mp testmail@gmail.com ";
                    }
                    if (defaultParams.get(i) != "-s") continue;
                    strArgs = strArgs + "-s no ";
                }
            }
            if (!(outputDir = new File(OUTPUT_FOLDER = args[1])).isAbsolute()) {
                String userDir = System.getProperty("user.dir");
                OUTPUT_FOLDER = new File(userDir, OUTPUT_FOLDER).getAbsolutePath();
            }
            System.out.println("Wiperdog will be install to directory: " + OUTPUT_FOLDER);
            String jarPath = SelfExtractorCmd.class.getProtectionDomain().getCodeSource().getLocation().getFile();
            if (System.getProperty("os.name").toLowerCase().indexOf("win") != -1) {
                System.out.println("");
                System.out.println("Stop wiperdog service: Start");
                SelfExtractorCmd.stopService();
                System.out.println("Stop wiperdog service: End");
            }
            SelfExtractorCmd.unZip(jarPath, OUTPUT_FOLDER);
            String newJarPath = System.getProperty("os.name").toLowerCase().indexOf("win") != -1 ? jarPath.substring(1, jarPath.length()) : jarPath;
            SelfExtractorCmd.runGroovyInstaller(newJarPath, strArgs);
            System.exit(0);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void runGroovyInstaller(String jarPath, String strArgs) throws Exception {
        File workDir = new File(OUTPUT_FOLDER);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        docBuilder.setErrorHandler(new XMLErrorHandler());
        Document doc = docBuilder.parse(InstallerUtil.class.getResourceAsStream("/extractor.xml"));
        InstallerUtil.parseXml(doc.getDocumentElement());
        if (InstallerXML.getInstance().getRunInstallerSyntax() == null || InstallerXML.getInstance().getRunInstallerSyntax().equals("")) {
            throw new Exception("Cannot run configuration for newly installed Wiperdog");
        }
        String runInstallerSyntax = InstallerXML.getInstance().getRunInstallerSyntax();
        if ((runInstallerSyntax = runInstallerSyntax + " " + OUTPUT_FOLDER + " " + strArgs) != null && !runInstallerSyntax.equals("")) {
            String[] cmdArray = runInstallerSyntax.split(" ");
            LinkedList<String> listCmd = new LinkedList<String>();
            if (cmdArray.length > 0) {
                if (cmdArray[0].equals("java")) {
                    cmdArray[0] = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
                }
                for (int i = 0; i < cmdArray.length; ++i) {
                    if (i == 2) {
                        String claspathSeparator = System.getProperty("os.name").toLowerCase().indexOf("win") != -1 ? ";" : ":";
                        String newCmd = System.getProperty("os.name").toLowerCase().indexOf("win") == -1 ? OUTPUT_FOLDER + File.separator + cmdArray[i] + claspathSeparator + jarPath : cmdArray[i] + claspathSeparator + jarPath;
                        listCmd.add(newCmd);
                        continue;
                    }
                    listCmd.add(cmdArray[i]);
                }
                ProcessBuilder builder = new ProcessBuilder(listCmd);
                builder.directory(workDir);
                builder.redirectErrorStream(true);
                Process p = builder.start();
                InputStream procOut = p.getInputStream();
                OutputStream procIn = p.getOutputStream();
                new Thread(new Redirector("Output", procOut, System.out)).start();
                new Thread(new Redirector("Input", System.in, procIn)).start();
                p.waitFor();
            }
        }
    }

    public static void unZip(String zipFile, String outputFolder) {
        byte[] buffer = new byte[1024];
        try {
            File folder = new File(outputFolder);
            if (!folder.exists()) {
                folder.mkdir();
            }
            ZipInputStream zis2 = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry ze2 = zis2.getNextEntry();
            while (ze2 != null) {
                String fileName = ze2.getName();
                if (!(ze2.isDirectory() || fileName.endsWith(".java") || fileName.endsWith(".class") || fileName.toLowerCase().endsWith(".mf") || fileName.toLowerCase().endsWith("pom.xml") || fileName.toLowerCase().endsWith("pom.properties"))) {
                    int len;
                    File newFile = new File(outputFolder + System.getProperty("file.separator") + fileName);
                    System.out.println("Wiperdog installer, unzip to file : " + newFile.getAbsolutePath());
                    String parentPath = newFile.getParent();
                    File parentFolder = new File(parentPath);
                    if (!parentFolder.exists()) {
                        parentFolder.mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis2.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.flush();
                    fos.close();
                    if (fileName.startsWith("bin")) {
                        newFile.setExecutable(true);
                    }
                }
                ze2 = zis2.getNextEntry();
            }
            zis2.closeEntry();
            zis2.close();
            System.out.println("Self-extracting done!");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isNumeric(String string) {
        return string.matches("-?\\d+(\\.\\d+)?");
    }

    public static void stopService() throws Exception {
        File workDir = new File(System.getProperty("user.dir"));
        LinkedList<String> listCmd = new LinkedList<String>();
        listCmd.add("net");
        listCmd.add("stop");
        listCmd.add("wiperdog");
        ProcessBuilder builder = new ProcessBuilder(listCmd);
        builder.redirectErrorStream(true);
        builder.directory(workDir);
        Process p = builder.start();
        InputStream procOut = p.getInputStream();
        OutputStream procIn = p.getOutputStream();
        new Thread(new Redirector(procOut, System.out)).start();
        new Thread(new Redirector(System.in, procIn)).start();
        p.waitFor();
        listCmd = new LinkedList();
        listCmd.add("taskkill");
        listCmd.add("/F");
        listCmd.add("/IM");
        listCmd.add("wiperdog_service.exe");
        builder = new ProcessBuilder(listCmd);
        builder.redirectErrorStream(true);
        builder.directory(workDir);
        p = builder.start();
        procOut = p.getInputStream();
        procIn = p.getOutputStream();
        new Thread(new Redirector(procOut, System.out)).start();
        new Thread(new Redirector(System.in, procIn)).start();
        p.waitFor();
        listCmd = new LinkedList();
        listCmd.add("cmd.exe");
        listCmd.add("/c");
        listCmd.add("sleep");
        listCmd.add("3");
        builder = new ProcessBuilder(listCmd);
        builder.redirectErrorStream(true);
        builder.directory(workDir);
        p = builder.start();
        procOut = p.getInputStream();
        procIn = p.getOutputStream();
        new Thread(new Redirector(procOut, System.out)).start();
        new Thread(new Redirector(System.in, procIn)).start();
        p.waitFor();
    }
}

