/*
 * Decompiled with CFR 0.152.
 */
package org.wiperdog.installer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.wiperdog.installer.Redirector;
import org.wiperdog.installer.internal.InstallerUtil;
import org.wiperdog.installer.internal.InstallerXML;
import org.wiperdog.installer.internal.XMLErrorHandler;

public class SelfExtractorCmd {
    public static String OUTPUT_FOLDER = "";
    public static final String LOG_FILE_NAME = System.getProperty("user.dir") + "/WiperdogInstaller.log";
    public static SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss.S");
    public static File loggingFile = new File(LOG_FILE_NAME);
    public static FileOutputStream fo = null;

    static void printInfoLog(String content) throws Exception {
        if (fo == null) {
            fo = new FileOutputStream(loggingFile, true);
        }
        fo.write((content + "\n").getBytes());
        System.out.println(content);
    }

    public static void fileInfoLog(String content) throws Exception {
        if (fo == null) {
            fo = new FileOutputStream(loggingFile, true);
        }
        fo.write((content + "\n").getBytes());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        try {
            fo = new FileOutputStream(loggingFile);
            String beginMessage = "Start the Wiperdog installation at " + df.format(new Date(System.currentTimeMillis())) + "\n";
            fo.write(beginMessage.getBytes());
            fo.flush();
            fo.close();
            fo = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> listParams = new ArrayList<String>();
        listParams.add("-d");
        listParams.add("-j");
        listParams.add("-r");
        listParams.add("-m");
        listParams.add("-jd");
        listParams.add("-id");
        listParams.add("-td");
        listParams.add("-cd");
        listParams.add("-p");
        listParams.add("-n");
        listParams.add("-u");
        listParams.add("-pw");
        listParams.add("-mp");
        listParams.add("-s");
        listParams.add("-ni");
        List<String> listArgs = Arrays.asList(args);
        InputStreamReader converter = new InputStreamReader(System.in);
        BufferedReader inp = new BufferedReader(converter, 512);
        try {
            block65: {
                String confirmStr;
                String wiperdogPath;
                block64: {
                    block66: {
                        block63: {
                            try {
                                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                                    public void run() {
                                        try {
                                            SelfExtractorCmd.printInfoLog("Installer shutdown...");
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                }));
                            }
                            catch (Exception ex) {
                                Thread.currentThread();
                                Thread.sleep(100L);
                            }
                            if (args.length != 0 && !SelfExtractorCmd.containParam(args, "-ni")) break block63;
                            if (args.length == 0) {
                                SelfExtractorCmd.printInfoLog("Press CTRL+C to quit. You can execute default installation with -ni option");
                            }
                            String currentDir = System.getProperty("user.dir");
                            String jarFileName = new File(SelfExtractorCmd.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getName();
                            String wiperdogDirName = "";
                            if (jarFileName.endsWith(".jar")) {
                                wiperdogDirName = jarFileName.substring(0, jarFileName.length() - 4);
                            }
                            if (wiperdogDirName.endsWith("-unix")) {
                                wiperdogDirName = wiperdogDirName.substring(0, wiperdogDirName.length() - 5);
                            }
                            if (wiperdogDirName.endsWith("-win")) {
                                wiperdogDirName = wiperdogDirName.substring(0, wiperdogDirName.length() - 4);
                            }
                            if (wiperdogDirName == "") {
                                wiperdogDirName = "wiperdogHome";
                            }
                            wiperdogPath = currentDir + File.separator + wiperdogDirName;
                            SelfExtractorCmd.printInfoLog("You omitted to specify WIPERDOG HOME.");
                            confirmStr = "";
                            if (!SelfExtractorCmd.containParam(args, "-ni")) break block64;
                            OUTPUT_FOLDER = SelfExtractorCmd.containParam(args, "-d") ? SelfExtractorCmd.getParamValue(args, "-d") : wiperdogPath;
                            break block65;
                        }
                        if ((args.length >= 2 || SelfExtractorCmd.containParam(args, "-ni")) && (args[0].trim().equals("-d") || SelfExtractorCmd.containParam(args, "-ni"))) break block66;
                        SelfExtractorCmd.printInfoLog("Wrong parameter. Usage:\n \t\t java -jar [Installer Jar] \n \t\t or \n \t\t java -jar [Installer Jar] -d [INSTALL_PATH>] \n \t\t or \n \t\t java -jar [Installer Jar] -d [INSTALL_PATH] -j [nettyport] -m [mongodb host] -p [mongodb port] -n [mongodb database name] -u [mongodb user name] -pw [mongodb password] -mp [mail policy] -s [yes/no install as OS service] \n \t\t or \n \t\t java -jar [Installer Jar] -ni [ -d INSTALL_PATH] [-j nettyport] ... ]");
                        System.exit(0);
                        break block65;
                    }
                    if (!SelfExtractorCmd.containParam(args, "-d")) break block65;
                    OUTPUT_FOLDER = args[1];
                    break block65;
                }
                while (confirmStr != null && !confirmStr.toLowerCase().equalsIgnoreCase("y") && !confirmStr.toLowerCase().equalsIgnoreCase("n")) {
                    SelfExtractorCmd.printInfoLog("Do you want to install wiperdog at " + wiperdogPath + " ? [y/n] :");
                    confirmStr = inp.readLine().trim();
                    if (confirmStr.toLowerCase().equalsIgnoreCase("y")) {
                        OUTPUT_FOLDER = wiperdogPath;
                        continue;
                    }
                    if (!confirmStr.toLowerCase().equalsIgnoreCase("n")) continue;
                    System.exit(0);
                }
            }
            String strArgs = "";
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-j")) {
                    if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim())) {
                        if (!SelfExtractorCmd.isNumeric(args[i + 1])) {
                            SelfExtractorCmd.printInfoLog("Netty port must be number: " + args[i]);
                            return;
                        }
                        strArgs = strArgs + "-j " + args[i + 1] + " ";
                        ++i;
                    } else {
                        SelfExtractorCmd.printInfoLog("Incorrect value of params: " + args[i]);
                        return;
                    }
                }
                if (args[i].equals("-r")) {
                    if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim())) {
                        if (!SelfExtractorCmd.isNumeric(args[i + 1])) {
                            SelfExtractorCmd.printInfoLog("Restful server port must be numeric: " + args[i]);
                            return;
                        }
                        strArgs = strArgs + "-r " + args[i + 1] + " ";
                        ++i;
                    } else {
                        SelfExtractorCmd.printInfoLog("Incorrect value of params: " + args[i]);
                        return;
                    }
                }
                if (args[i].equals("-jd")) {
                    if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim())) {
                        strArgs = strArgs + "-jd " + args[i + 1] + " ";
                        ++i;
                    } else {
                        SelfExtractorCmd.printInfoLog("Incorrect value of params: " + args[i]);
                        return;
                    }
                }
                if (args[i].equals("-id")) {
                    if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim())) {
                        strArgs = strArgs + "-id " + args[i + 1] + " ";
                        ++i;
                    } else {
                        SelfExtractorCmd.printInfoLog("Incorrect value of params: " + args[i]);
                        return;
                    }
                }
                if (args[i].equals("-cd")) {
                    if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim())) {
                        strArgs = strArgs + "-cd " + args[i + 1] + " ";
                        ++i;
                    } else {
                        SelfExtractorCmd.printInfoLog("Incorrect value of params: " + args[i]);
                        return;
                    }
                }
                if (args[i].equals("-td")) {
                    if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim())) {
                        strArgs = strArgs + "-td " + args[i + 1] + " ";
                        ++i;
                    } else {
                        SelfExtractorCmd.printInfoLog("Incorrect value of params: " + args[i]);
                        return;
                    }
                }
                if (args[i].equals("-m")) {
                    if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim())) {
                        strArgs = strArgs + "-m " + args[i + 1] + " ";
                        ++i;
                    } else {
                        SelfExtractorCmd.printInfoLog("Incorrect value of params: " + args[i]);
                        return;
                    }
                }
                if (args[i].equals("-p")) {
                    if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim())) {
                        if (!SelfExtractorCmd.isNumeric(args[i + 1])) {
                            SelfExtractorCmd.printInfoLog("Mongodb port must be number: " + args[i]);
                            return;
                        }
                        strArgs = strArgs + "-p " + args[i + 1] + " ";
                        ++i;
                    } else {
                        SelfExtractorCmd.printInfoLog("Incorrect value of params: " + args[i]);
                        return;
                    }
                }
                if (args[i].equals("-n")) {
                    if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim())) {
                        strArgs = strArgs + "-n " + args[i + 1] + " ";
                        ++i;
                    } else {
                        SelfExtractorCmd.printInfoLog("Incorrect value of params: " + args[i]);
                        return;
                    }
                }
                if (args[i].equals("-u")) {
                    if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim())) {
                        strArgs = strArgs + "-u " + args[i + 1] + " ";
                        ++i;
                    } else {
                        SelfExtractorCmd.printInfoLog("Incorrect value of params: " + args[i]);
                        return;
                    }
                }
                if (args[i].equals("-pw")) {
                    if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim())) {
                        strArgs = strArgs + "-pw " + args[i + 1] + " ";
                        ++i;
                    } else {
                        SelfExtractorCmd.printInfoLog("Incorrect value of params: " + args[i]);
                        return;
                    }
                }
                if (args[i].equals("-mp")) {
                    if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim())) {
                        strArgs = strArgs + "-mp " + args[i + 1] + " ";
                        ++i;
                    } else {
                        SelfExtractorCmd.printInfoLog("Incorrect value of params: " + args[i]);
                        return;
                    }
                }
                if (args[i].equals("-s")) {
                    if (args.length > i + 1 && args[i + 1].trim() != "" && !listParams.contains(args[i + 1].trim())) {
                        strArgs = strArgs + "-s " + args[i + 1] + " ";
                        ++i;
                    } else {
                        SelfExtractorCmd.printInfoLog("Incorrect value of params: " + args[i]);
                        return;
                    }
                }
                if (!args[i].equals("-ni")) continue;
                strArgs = strArgs + args[i] + " ";
            }
            File outputDir = new File(OUTPUT_FOLDER);
            if (!outputDir.isAbsolute()) {
                String userDir = System.getProperty("user.dir");
                OUTPUT_FOLDER = new File(userDir, OUTPUT_FOLDER).getAbsolutePath();
            }
            SelfExtractorCmd.printInfoLog("Wiperdog will be install to directory: " + OUTPUT_FOLDER);
            String jarPath = new URI(SelfExtractorCmd.class.getProtectionDomain().getCodeSource().getLocation().getFile()).getPath();
            if (System.getProperty("os.name").toLowerCase().indexOf("win") != -1) {
                System.out.println("");
                SelfExtractorCmd.printInfoLog("Stop wiperdog service: Start");
                SelfExtractorCmd.stopService();
                SelfExtractorCmd.printInfoLog("Stop wiperdog service: End");
            }
            SelfExtractorCmd.unZip(jarPath, OUTPUT_FOLDER);
            String newJarPath = System.getProperty("os.name").toLowerCase().indexOf("win") != -1 ? jarPath.substring(1, jarPath.length()) : jarPath;
            try {
                fo.flush();
                fo.close();
            }
            catch (Exception e) {
                fo.flush();
                fo.close();
                e.printStackTrace();
            }
            String logFilePath = LOG_FILE_NAME.replaceAll("\\\\", "/");
            try {
                File file = new File(OUTPUT_FOLDER + "/extractor.xml");
                BufferedReader reader = new BufferedReader(new FileReader(file));
                String line = "";
                String oldtext = "";
                while ((line = reader.readLine()) != null) {
                    oldtext = oldtext + line + "\n";
                }
                reader.close();
                String tempText = oldtext.replaceAll("INSTALLER_LOG_PATH", logFilePath);
                String newText = tempText.replaceAll("INSTALL_MODE", strArgs != null && strArgs.indexOf("-ni") != -1 ? "interactive" : "silient");
                FileWriter writer = new FileWriter(OUTPUT_FOLDER + "/extractor.xml");
                writer.write(newText);
                writer.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            SelfExtractorCmd.runGroovyInstaller(newJarPath, strArgs);
            System.exit(0);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void runGroovyInstaller(String jarPath, String strArgs) throws Exception {
        String logFilePath = LOG_FILE_NAME.replaceAll("\\\\", "/");
        try {
            File file = new File(OUTPUT_FOLDER + "/extractor.xml");
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = "";
            String oldtext = "";
            while ((line = reader.readLine()) != null) {
                oldtext = oldtext + line + "\n";
            }
            reader.close();
            String newtext = oldtext.replaceAll("INSTALLER_LOG_PATH", logFilePath);
            FileWriter writer = new FileWriter(OUTPUT_FOLDER + "/extractor.xml");
            writer.write(newtext);
            writer.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        File workDir = new File(OUTPUT_FOLDER);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        docBuilder.setErrorHandler(new XMLErrorHandler());
        Document doc = docBuilder.parse(InstallerUtil.class.getResourceAsStream("/extractor.xml"));
        InstallerUtil.parseXml(doc.getDocumentElement());
        if (InstallerXML.getInstance().getRunInstallerSyntax() == null || InstallerXML.getInstance().getRunInstallerSyntax().equals("")) {
            throw new Exception("Cannot run configuration for newly installed Wiperdog");
        }
        String runInstallerSyntax = InstallerXML.getInstance().getRunInstallerSyntax();
        if (runInstallerSyntax != null && !runInstallerSyntax.equals("")) {
            String[] cmdArray = runInstallerSyntax.split(" ");
            LinkedList<String> listCmd = new LinkedList<String>();
            if (cmdArray.length > 0) {
                int i;
                if (cmdArray[0].equals("java")) {
                    cmdArray[0] = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
                }
                for (i = 0; i < cmdArray.length; ++i) {
                    if (i == 2) {
                        String claspathSeparator = System.getProperty("os.name").toLowerCase().indexOf("win") != -1 ? ";" : ":";
                        String newCmd = System.getProperty("os.name").toLowerCase().indexOf("win") == -1 ? OUTPUT_FOLDER + File.separator + cmdArray[i] + claspathSeparator + jarPath : cmdArray[i] + claspathSeparator + jarPath;
                        listCmd.add(newCmd);
                        continue;
                    }
                    listCmd.add(cmdArray[i]);
                }
                listCmd.add(OUTPUT_FOLDER);
                if (strArgs != null && !strArgs.equals("")) {
                    cmdArray = strArgs.split(" ");
                    for (i = 0; i < cmdArray.length; ++i) {
                        listCmd.add(cmdArray[i]);
                    }
                }
                ProcessBuilder builder = new ProcessBuilder(listCmd);
                builder.directory(workDir);
                builder.redirectErrorStream(true);
                Process p = builder.start();
                InputStream procOut = p.getInputStream();
                OutputStream procIn = p.getOutputStream();
                new Thread(new Redirector("Output", procOut, System.out)).start();
                new Thread(new Redirector("Input", System.in, procIn)).start();
                p.waitFor();
            }
        }
    }

    public static void unZip(String zipFile, String outputFolder) throws Exception {
        byte[] buffer = new byte[1024];
        try {
            File folder = new File(outputFolder);
            if (!folder.exists()) {
                folder.mkdir();
            }
            ZipInputStream zis2 = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry ze2 = zis2.getNextEntry();
            while (ze2 != null) {
                String fileName = ze2.getName();
                if (!(ze2.isDirectory() || fileName.endsWith(".java") || fileName.endsWith(".class") || fileName.toLowerCase().endsWith(".mf") || fileName.toLowerCase().endsWith("pom.xml") || fileName.toLowerCase().endsWith("pom.properties"))) {
                    int len;
                    File newFile = new File(outputFolder + System.getProperty("file.separator") + fileName);
                    SelfExtractorCmd.printInfoLog("Wiperdog installer, unzip to file : " + newFile.getAbsolutePath());
                    String parentPath = newFile.getParent();
                    File parentFolder = new File(parentPath);
                    if (!parentFolder.exists()) {
                        parentFolder.mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis2.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.flush();
                    fos.close();
                    if (fileName.startsWith("bin")) {
                        newFile.setExecutable(true);
                    }
                }
                ze2 = zis2.getNextEntry();
            }
            zis2.closeEntry();
            zis2.close();
            SelfExtractorCmd.printInfoLog("Self-extracting done!");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static String getParamValue(String[] args, String key) {
        String ret = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || !args[i].equals(key) || i + 1 >= args.length) continue;
            ret = args[i + 1];
            break;
        }
        return ret;
    }

    public static boolean containParam(String[] args, String key) {
        boolean ret = false;
        for (String s : args) {
            if (s == null || !s.equals(key)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static boolean isNumeric(String string) {
        return string.matches("-?\\d+(\\.\\d+)?");
    }

    public static void stopService() throws Exception {
        File workDir = new File(System.getProperty("user.dir"));
        LinkedList<String> listCmd = new LinkedList<String>();
        listCmd.add("net");
        listCmd.add("stop");
        listCmd.add("wiperdog");
        ProcessBuilder builder = new ProcessBuilder(listCmd);
        builder.redirectErrorStream(true);
        builder.directory(workDir);
        Process p = builder.start();
        InputStream procOut = p.getInputStream();
        OutputStream procIn = p.getOutputStream();
        new Thread(new Redirector(procOut, System.out)).start();
        new Thread(new Redirector(System.in, procIn)).start();
        p.waitFor();
        listCmd = new LinkedList();
        listCmd.add("taskkill");
        listCmd.add("/F");
        listCmd.add("/IM");
        listCmd.add("wiperdog_service*");
        builder = new ProcessBuilder(listCmd);
        builder.redirectErrorStream(true);
        builder.directory(workDir);
        p = builder.start();
        procOut = p.getInputStream();
        procIn = p.getOutputStream();
        new Thread(new Redirector(procOut, System.out)).start();
        new Thread(new Redirector(System.in, procIn)).start();
        p.waitFor();
        listCmd = new LinkedList();
        listCmd.add("cmd.exe");
        listCmd.add("/c");
        listCmd.add("sleep");
        listCmd.add("3");
        builder = new ProcessBuilder(listCmd);
        builder.redirectErrorStream(true);
        builder.directory(workDir);
        p = builder.start();
        procOut = p.getInputStream();
        procIn = p.getOutputStream();
        new Thread(new Redirector(procOut, System.out)).start();
        new Thread(new Redirector(System.in, procIn)).start();
        p.waitFor();
    }
}

