/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.content.bodyparsers;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.content.BodyParser;
import org.wisdom.api.content.ParameterConverters;
import org.wisdom.api.http.Context;
import org.wisdom.content.converters.ReflectionHelper;

@Component
@Provides
@Instantiate
public class BodyParserForm
implements BodyParser,
Pojo {
    InstanceManager __IM;
    private static final Logger LOGGER = LoggerFactory.getLogger(BodyParser.class);
    private static final String ERROR_KEY = "Error parsing incoming form data for key ";
    private static final String ERROR_AND = " and value ";
    private boolean __Fconverters;
    @Requires
    ParameterConverters converters;
    boolean __Minvoke$org_wisdom_api_http_Context$java_lang_Class;
    boolean __Minvoke$byte__$java_lang_Class;
    boolean __MgetContentTypes;

    ParameterConverters __getconverters() {
        if (!this.__Fconverters) {
            return this.converters;
        }
        return (ParameterConverters)this.__IM.onGet((Object)this, "converters");
    }

    void __setconverters(ParameterConverters parameterConverters) {
        if (!this.__Fconverters) {
            this.converters = parameterConverters;
            return;
        }
        this.__IM.onSet((Object)this, "converters", (Object)parameterConverters);
    }

    public BodyParserForm() {
        this(null);
    }

    private BodyParserForm(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public <T> T invoke(Context context, Class<T> classOfT) {
        T t;
        if (!this.__Minvoke$org_wisdom_api_http_Context$java_lang_Class) {
            return this.__M_invoke(context, classOfT);
        }
        try {
            this.__IM.onEntry((Object)this, "invoke$org_wisdom_api_http_Context$java_lang_Class", new Object[]{context, classOfT});
            t = this.__M_invoke(context, classOfT);
            this.__IM.onExit((Object)this, "invoke$org_wisdom_api_http_Context$java_lang_Class", t);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "invoke$org_wisdom_api_http_Context$java_lang_Class", throwable);
            throw throwable;
        }
        return t;
    }

    private <T> T __M_invoke(Context context, Class<T> classOfT) {
        Object value;
        Field field;
        T t;
        try {
            t = classOfT.newInstance();
        }
        catch (Exception e) {
            LOGGER.error("can't newInstance class " + classOfT.getName(), (Throwable)e);
            return null;
        }
        for (Map.Entry ent : context.parameters().entrySet()) {
            try {
                field = ReflectionHelper.getField(classOfT, (String)ent.getKey());
                value = this.__getconverters().convertValues((Collection)ent.getValue(), field.getType(), field.getGenericType(), null);
                field.set(t, value);
            }
            catch (Exception e) {
                LOGGER.warn(ERROR_KEY + (String)ent.getKey() + ERROR_AND + ent.getValue(), (Throwable)e);
            }
        }
        if (context.form() == null) {
            return t;
        }
        for (Map.Entry ent : context.form().entrySet()) {
            try {
                field = ReflectionHelper.getField(classOfT, (String)ent.getKey());
                value = this.__getconverters().convertValues((Collection)ent.getValue(), field.getType(), field.getGenericType(), null);
                field.set(t, value);
            }
            catch (NoSuchFieldException e) {
                LOGGER.warn("No member in {} to be bound with attribute {}={}", new Object[]{classOfT.getName(), ent.getKey(), ent.getValue(), e});
            }
            catch (Exception e) {
                LOGGER.warn(ERROR_KEY + (String)ent.getKey() + ERROR_AND + ent.getValue(), (Throwable)e);
            }
        }
        return t;
    }

    public <T> T invoke(byte[] bytes, Class<T> classOfT) {
        T t;
        if (!this.__Minvoke$byte__$java_lang_Class) {
            return this.__M_invoke(bytes, classOfT);
        }
        try {
            this.__IM.onEntry((Object)this, "invoke$byte__$java_lang_Class", new Object[]{bytes, classOfT});
            t = this.__M_invoke(bytes, classOfT);
            this.__IM.onExit((Object)this, "invoke$byte__$java_lang_Class", t);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "invoke$byte__$java_lang_Class", throwable);
            throw throwable;
        }
        return t;
    }

    private <T> T __M_invoke(byte[] bytes, Class<T> classOfT) {
        throw new UnsupportedOperationException("Cannot bind a raw byte[] to a form object");
    }

    public List<String> getContentTypes() {
        List<String> list;
        if (!this.__MgetContentTypes) {
            return this.__M_getContentTypes();
        }
        try {
            this.__IM.onEntry((Object)this, "getContentTypes", new Object[0]);
            list = this.__M_getContentTypes();
            this.__IM.onExit((Object)this, "getContentTypes", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getContentTypes", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __M_getContentTypes() {
        return ImmutableList.of((Object)"application/x-www-form-urlencoded");
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("converters")) {
            this.__Fconverters = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("invoke$org_wisdom_api_http_Context$java_lang_Class")) {
                this.__Minvoke$org_wisdom_api_http_Context$java_lang_Class = true;
            }
            if (set.contains("invoke$byte__$java_lang_Class")) {
                this.__Minvoke$byte__$java_lang_Class = true;
            }
            if (set.contains("getContentTypes")) {
                this.__MgetContentTypes = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

