/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.content.bodyparsers;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.wisdom.api.content.BodyParser;
import org.wisdom.api.content.Xml;
import org.wisdom.api.http.Context;

@Component
@Provides
@Instantiate
public class BodyParserXML
implements BodyParser,
Pojo {
    InstanceManager __IM;
    private boolean __Fxml;
    @Requires
    Xml xml;
    private static final String ERROR = "Error parsing incoming XML";
    private static final Logger LOGGER = LoggerFactory.getLogger(BodyParserXML.class);
    boolean __Minvoke$org_wisdom_api_http_Context$java_lang_Class;
    boolean __Minvoke$byte__$java_lang_Class;
    boolean __MparseXMLDocument$byte__;
    boolean __MgetContentTypes;

    Xml __getxml() {
        if (!this.__Fxml) {
            return this.xml;
        }
        return (Xml)this.__IM.onGet((Object)this, "xml");
    }

    void __setxml(Xml xml) {
        if (!this.__Fxml) {
            this.xml = xml;
            return;
        }
        this.__IM.onSet((Object)this, "xml", (Object)xml);
    }

    public BodyParserXML() {
        this(null);
    }

    private BodyParserXML(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public <T> T invoke(Context context, Class<T> classOfT) {
        T t;
        if (!this.__Minvoke$org_wisdom_api_http_Context$java_lang_Class) {
            return this.__M_invoke(context, classOfT);
        }
        try {
            this.__IM.onEntry((Object)this, "invoke$org_wisdom_api_http_Context$java_lang_Class", new Object[]{context, classOfT});
            t = this.__M_invoke(context, classOfT);
            this.__IM.onExit((Object)this, "invoke$org_wisdom_api_http_Context$java_lang_Class", t);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "invoke$org_wisdom_api_http_Context$java_lang_Class", throwable);
            throw throwable;
        }
        return t;
    }

    private <T> T __M_invoke(Context context, Class<T> classOfT) {
        Object t = null;
        try {
            String content = context.body();
            if (content == null || content.length() == 0) {
                return null;
            }
            if (classOfT.equals(Document.class)) {
                return (T)this.parseXMLDocument(content.getBytes(Charsets.UTF_8));
            }
            t = this.__getxml().xmlMapper().readValue(content, classOfT);
        }
        catch (IOException e) {
            LOGGER.error(ERROR, (Throwable)e);
        }
        return (T)t;
    }

    public <T> T invoke(byte[] bytes, Class<T> classOfT) {
        T t;
        if (!this.__Minvoke$byte__$java_lang_Class) {
            return this.__M_invoke(bytes, classOfT);
        }
        try {
            this.__IM.onEntry((Object)this, "invoke$byte__$java_lang_Class", new Object[]{bytes, classOfT});
            t = this.__M_invoke(bytes, classOfT);
            this.__IM.onExit((Object)this, "invoke$byte__$java_lang_Class", t);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "invoke$byte__$java_lang_Class", throwable);
            throw throwable;
        }
        return t;
    }

    private <T> T __M_invoke(byte[] bytes, Class<T> classOfT) {
        Object t = null;
        try {
            if (classOfT.equals(Document.class)) {
                return (T)this.parseXMLDocument(bytes);
            }
            t = this.__getxml().xmlMapper().readValue(bytes, classOfT);
        }
        catch (IOException e) {
            LOGGER.error(ERROR, (Throwable)e);
        }
        return (T)t;
    }

    private Document parseXMLDocument(byte[] bytes) {
        Document document;
        if (!this.__MparseXMLDocument$byte__) {
            return this.__M_parseXMLDocument(bytes);
        }
        try {
            this.__IM.onEntry((Object)this, "parseXMLDocument$byte__", new Object[]{bytes});
            document = this.__M_parseXMLDocument(bytes);
            this.__IM.onExit((Object)this, "parseXMLDocument$byte__", (Object)document);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "parseXMLDocument$byte__", throwable);
            throw throwable;
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document __M_parseXMLDocument(byte[] bytes) {
        Document document;
        ByteArrayInputStream stream = null;
        try {
            stream = new ByteArrayInputStream(bytes);
            document = this.__getxml().fromInputStream((InputStream)stream, Charsets.UTF_8);
        }
        catch (IOException e) {
            Document document2;
            try {
                LOGGER.error(ERROR, (Throwable)e);
                document2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)stream);
            return document2;
        }
        IOUtils.closeQuietly((InputStream)stream);
        return document;
    }

    public List<String> getContentTypes() {
        List<String> list;
        if (!this.__MgetContentTypes) {
            return this.__M_getContentTypes();
        }
        try {
            this.__IM.onEntry((Object)this, "getContentTypes", new Object[0]);
            list = this.__M_getContentTypes();
            this.__IM.onExit((Object)this, "getContentTypes", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getContentTypes", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __M_getContentTypes() {
        return ImmutableList.of((Object)"application/xml", (Object)"text/xml", (Object)"application/atom+xml");
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("xml")) {
            this.__Fxml = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("invoke$org_wisdom_api_http_Context$java_lang_Class")) {
                this.__Minvoke$org_wisdom_api_http_Context$java_lang_Class = true;
            }
            if (set.contains("invoke$byte__$java_lang_Class")) {
                this.__Minvoke$byte__$java_lang_Class = true;
            }
            if (set.contains("parseXMLDocument$byte__")) {
                this.__MparseXMLDocument$byte__ = true;
            }
            if (set.contains("getContentTypes")) {
                this.__MgetContentTypes = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

