/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.content.codecs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;
import org.wisdom.api.content.ContentCodec;

public abstract class AbstractDefInfCodec
implements ContentCodec {
    public InputStream encode(InputStream toEncode) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            OutputStream encoderout = this.getEncoderClass().getConstructor(OutputStream.class).newInstance(bout);
            encoderout.write(IOUtils.toByteArray((InputStream)toEncode));
            encoderout.flush();
            encoderout.close();
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LoggerFactory.getLogger(AbstractDefInfCodec.class).error("Error while encoding", (Throwable)e);
            return toEncode;
        }
        toEncode.close();
        bout.flush();
        ByteArrayInputStream encoded = new ByteArrayInputStream(bout.toByteArray());
        bout.close();
        return encoded;
    }

    public InputStream decode(InputStream toDecode) throws IOException {
        InputStream decoderin;
        try {
            decoderin = this.getDecoderClass().getConstructor(InputStream.class).newInstance(toDecode);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LoggerFactory.getLogger(AbstractDefInfCodec.class).error("Error while decoding", (Throwable)e);
            return toDecode;
        }
        return decoderin;
    }

    public abstract String getEncodingType();

    public abstract String getContentEncodingHeaderValue();

    public abstract Class<? extends DeflaterOutputStream> getEncoderClass();

    public abstract Class<? extends InflaterInputStream> getDecoderClass();
}

