/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.content.converters;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.LoggerFactory;
import org.wisdom.api.content.ParameterConverter;

public final class FromStringBasedConverter<T>
implements ParameterConverter<T> {
    public static final String FROM_STRING = "fromString";
    private final Method method;
    private final Class<T> clazz;

    private FromStringBasedConverter(Class<T> clazz, Method method) {
        this.clazz = clazz;
        this.method = method;
    }

    public static <T> FromStringBasedConverter<T> getIfEligible(Class<T> clazz) {
        try {
            Method method = clazz.getMethod(FROM_STRING, String.class);
            if (Modifier.isStatic(method.getModifiers())) {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return new FromStringBasedConverter<T>(clazz, method);
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public T fromString(String input) throws IllegalArgumentException {
        try {
            return this.clazz.cast(this.method.invoke(null, input));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LoggerFactory.getLogger(this.getClass()).error("Cannot create an instance of {} from \"{}\" using the 'fromString' method", new Object[]{this.method.getDeclaringClass().getName(), input, e});
            if (e.getCause() != null) {
                throw new IllegalArgumentException(e.getCause());
            }
            throw new IllegalArgumentException(e);
        }
    }

    public Class<T> getType() {
        return this.clazz;
    }
}

