/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.content.converters;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wisdom.content.converters.ClassTypePair;
import org.wisdom.content.converters.EraserVisitor;

public class ReflectionHelper {
    public static List<ClassTypePair> getTypeArgumentAndClass(Type type) throws IllegalArgumentException {
        Type[] types = ReflectionHelper.getTypeArguments(type);
        if (types == null) {
            return Collections.emptyList();
        }
        ArrayList<ClassTypePair> list = new ArrayList<ClassTypePair>();
        for (Type t : types) {
            list.add(new ClassTypePair(ReflectionHelper.erasure(t), t));
        }
        return list;
    }

    public static <T> Class<T> erasure(Type type) {
        return EraserVisitor.ERASER.visit(type);
    }

    public static Type[] getTypeArguments(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        return ((ParameterizedType)type).getActualTypeArguments();
    }

    public static String getPrimitiveDefault(Class type) {
        if (type == Boolean.class) {
            return "false";
        }
        if (type == Character.class) {
            return Character.toString('\u0000');
        }
        return "0";
    }

    public static Field getField(Class clazz, String name) throws NoSuchFieldException {
        Field field = null;
        try {
            field = clazz.getField(name);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (field == null) {
            field = clazz.getDeclaredField(name);
        }
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return field;
    }
}

