/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.content.encoding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.wisdom.api.annotations.encoder.AllowEncoding;
import org.wisdom.api.annotations.encoder.DenyEncoding;
import org.wisdom.api.bodies.RenderableURL;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.content.ContentEncodingHelper;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.EncodingNames;
import org.wisdom.api.http.Renderable;
import org.wisdom.api.http.Result;
import org.wisdom.api.router.Route;
import org.wisdom.api.utils.KnownMimeTypes;
import org.wisdom.content.encoding.ValuedEncoding;

@Component
@Instantiate
@Provides
public class ContentEncodingHelperImpl
implements ContentEncodingHelper,
Pojo {
    InstanceManager __IM;
    private boolean __Fconfiguration;
    @Requires(specification=ApplicationConfiguration.class, optional=false)
    ApplicationConfiguration configuration;
    private boolean __FallowEncodingGlobalSetting;
    Boolean allowEncodingGlobalSetting;
    private boolean __FallowUrlEncodingGlobalSetting;
    Boolean allowUrlEncodingGlobalSetting;
    private boolean __FmaxSizeGlobalSetting;
    Long maxSizeGlobalSetting;
    private boolean __FminSizeGlobalSetting;
    Long minSizeGlobalSetting;
    boolean __MsetConfiguration$org_wisdom_api_configuration_ApplicationConfiguration;
    boolean __MgetAllowEncodingGlobalSetting;
    boolean __MgetAllowUrlEncodingGlobalSetting;
    boolean __MgetMaxSizeGlobalSetting;
    boolean __MgetMinSizeGlobalSetting;
    boolean __MshouldEncode$org_wisdom_api_http_Context$org_wisdom_api_http_Result$org_wisdom_api_http_Renderable;
    boolean __MshouldEncodeWithHeaders$java_util_Map;
    boolean __MshouldEncodeWithMimeType$org_wisdom_api_http_Renderable;
    boolean __MshouldEncodeWithSize$org_wisdom_api_router_Route$org_wisdom_api_http_Renderable;
    boolean __MshouldEncodeWithRoute$org_wisdom_api_router_Route;
    boolean __MparseAcceptEncodingHeader$java_lang_String;

    ApplicationConfiguration __getconfiguration() {
        if (!this.__Fconfiguration) {
            return this.configuration;
        }
        return (ApplicationConfiguration)this.__IM.onGet((Object)this, "configuration");
    }

    void __setconfiguration(ApplicationConfiguration applicationConfiguration) {
        if (!this.__Fconfiguration) {
            this.configuration = applicationConfiguration;
            return;
        }
        this.__IM.onSet((Object)this, "configuration", (Object)applicationConfiguration);
    }

    Boolean __getallowEncodingGlobalSetting() {
        if (!this.__FallowEncodingGlobalSetting) {
            return this.allowEncodingGlobalSetting;
        }
        return (Boolean)this.__IM.onGet((Object)this, "allowEncodingGlobalSetting");
    }

    void __setallowEncodingGlobalSetting(Boolean bl) {
        if (!this.__FallowEncodingGlobalSetting) {
            this.allowEncodingGlobalSetting = bl;
            return;
        }
        this.__IM.onSet((Object)this, "allowEncodingGlobalSetting", (Object)bl);
    }

    Boolean __getallowUrlEncodingGlobalSetting() {
        if (!this.__FallowUrlEncodingGlobalSetting) {
            return this.allowUrlEncodingGlobalSetting;
        }
        return (Boolean)this.__IM.onGet((Object)this, "allowUrlEncodingGlobalSetting");
    }

    void __setallowUrlEncodingGlobalSetting(Boolean bl) {
        if (!this.__FallowUrlEncodingGlobalSetting) {
            this.allowUrlEncodingGlobalSetting = bl;
            return;
        }
        this.__IM.onSet((Object)this, "allowUrlEncodingGlobalSetting", (Object)bl);
    }

    Long __getmaxSizeGlobalSetting() {
        if (!this.__FmaxSizeGlobalSetting) {
            return this.maxSizeGlobalSetting;
        }
        return (Long)this.__IM.onGet((Object)this, "maxSizeGlobalSetting");
    }

    void __setmaxSizeGlobalSetting(Long l) {
        if (!this.__FmaxSizeGlobalSetting) {
            this.maxSizeGlobalSetting = l;
            return;
        }
        this.__IM.onSet((Object)this, "maxSizeGlobalSetting", (Object)l);
    }

    Long __getminSizeGlobalSetting() {
        if (!this.__FminSizeGlobalSetting) {
            return this.minSizeGlobalSetting;
        }
        return (Long)this.__IM.onGet((Object)this, "minSizeGlobalSetting");
    }

    void __setminSizeGlobalSetting(Long l) {
        if (!this.__FminSizeGlobalSetting) {
            this.minSizeGlobalSetting = l;
            return;
        }
        this.__IM.onSet((Object)this, "minSizeGlobalSetting", (Object)l);
    }

    public ContentEncodingHelperImpl() {
        this(null);
    }

    private ContentEncodingHelperImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setallowEncodingGlobalSetting(null);
        this.__setallowUrlEncodingGlobalSetting(null);
        this.__setmaxSizeGlobalSetting(null);
        this.__setminSizeGlobalSetting(null);
    }

    public void setConfiguration(ApplicationConfiguration configuration) {
        if (!this.__MsetConfiguration$org_wisdom_api_configuration_ApplicationConfiguration) {
            this.__M_setConfiguration(configuration);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setConfiguration$org_wisdom_api_configuration_ApplicationConfiguration", new Object[]{configuration});
            this.__M_setConfiguration(configuration);
            this.__IM.onExit((Object)this, "setConfiguration$org_wisdom_api_configuration_ApplicationConfiguration", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setConfiguration$org_wisdom_api_configuration_ApplicationConfiguration", throwable);
            throw throwable;
        }
    }

    private void __M_setConfiguration(ApplicationConfiguration configuration) {
        this.__setconfiguration(configuration);
    }

    public boolean getAllowEncodingGlobalSetting() {
        boolean bl;
        if (!this.__MgetAllowEncodingGlobalSetting) {
            return this.__M_getAllowEncodingGlobalSetting();
        }
        try {
            this.__IM.onEntry((Object)this, "getAllowEncodingGlobalSetting", new Object[0]);
            bl = this.__M_getAllowEncodingGlobalSetting();
            this.__IM.onExit((Object)this, "getAllowEncodingGlobalSetting", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAllowEncodingGlobalSetting", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_getAllowEncodingGlobalSetting() {
        if (this.__getallowEncodingGlobalSetting() == null) {
            this.__setallowEncodingGlobalSetting(this.__getconfiguration().getBooleanWithDefault("encoding.global", Boolean.valueOf(true)));
        }
        return this.__getallowEncodingGlobalSetting();
    }

    public boolean getAllowUrlEncodingGlobalSetting() {
        boolean bl;
        if (!this.__MgetAllowUrlEncodingGlobalSetting) {
            return this.__M_getAllowUrlEncodingGlobalSetting();
        }
        try {
            this.__IM.onEntry((Object)this, "getAllowUrlEncodingGlobalSetting", new Object[0]);
            bl = this.__M_getAllowUrlEncodingGlobalSetting();
            this.__IM.onExit((Object)this, "getAllowUrlEncodingGlobalSetting", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAllowUrlEncodingGlobalSetting", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_getAllowUrlEncodingGlobalSetting() {
        if (this.__getallowUrlEncodingGlobalSetting() == null) {
            this.__setallowUrlEncodingGlobalSetting(this.__getconfiguration().getBooleanWithDefault("encoding.url", Boolean.valueOf(true)));
        }
        return this.__getallowUrlEncodingGlobalSetting();
    }

    public long getMaxSizeGlobalSetting() {
        long l;
        if (!this.__MgetMaxSizeGlobalSetting) {
            return this.__M_getMaxSizeGlobalSetting();
        }
        try {
            this.__IM.onEntry((Object)this, "getMaxSizeGlobalSetting", new Object[0]);
            l = this.__M_getMaxSizeGlobalSetting();
            this.__IM.onExit((Object)this, "getMaxSizeGlobalSetting", (Object)new Long(l));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMaxSizeGlobalSetting", throwable);
            throw throwable;
        }
        return l;
    }

    private long __M_getMaxSizeGlobalSetting() {
        if (this.__getmaxSizeGlobalSetting() == null) {
            this.__setmaxSizeGlobalSetting(this.__getconfiguration().getLongWithDefault("encoding.max.size", Long.valueOf(10240000L)));
        }
        return this.__getmaxSizeGlobalSetting();
    }

    public long getMinSizeGlobalSetting() {
        long l;
        if (!this.__MgetMinSizeGlobalSetting) {
            return this.__M_getMinSizeGlobalSetting();
        }
        try {
            this.__IM.onEntry((Object)this, "getMinSizeGlobalSetting", new Object[0]);
            l = this.__M_getMinSizeGlobalSetting();
            this.__IM.onExit((Object)this, "getMinSizeGlobalSetting", (Object)new Long(l));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMinSizeGlobalSetting", throwable);
            throw throwable;
        }
        return l;
    }

    private long __M_getMinSizeGlobalSetting() {
        if (this.__getminSizeGlobalSetting() == null) {
            this.__setminSizeGlobalSetting(this.__getconfiguration().getLongWithDefault("encoding.min.size", Long.valueOf(10240L)));
        }
        return this.__getminSizeGlobalSetting();
    }

    public boolean shouldEncode(Context context, Result result, Renderable<?> renderable) {
        boolean bl;
        if (!this.__MshouldEncode$org_wisdom_api_http_Context$org_wisdom_api_http_Result$org_wisdom_api_http_Renderable) {
            return this.__M_shouldEncode(context, result, renderable);
        }
        try {
            this.__IM.onEntry((Object)this, "shouldEncode$org_wisdom_api_http_Context$org_wisdom_api_http_Result$org_wisdom_api_http_Renderable", new Object[]{context, result, renderable});
            bl = this.__M_shouldEncode(context, result, renderable);
            this.__IM.onExit((Object)this, "shouldEncode$org_wisdom_api_http_Context$org_wisdom_api_http_Result$org_wisdom_api_http_Renderable", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "shouldEncode$org_wisdom_api_http_Context$org_wisdom_api_http_Result$org_wisdom_api_http_Renderable", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_shouldEncode(Context context, Result result, Renderable<?> renderable) {
        return context != null && result != null && this.shouldEncodeWithHeaders(result.getHeaders()) && this.shouldEncodeWithRoute(context.route()) && this.shouldEncodeWithSize(context.route(), renderable) && this.shouldEncodeWithMimeType(renderable);
    }

    public boolean shouldEncodeWithHeaders(Map<String, String> headers) {
        boolean bl;
        if (!this.__MshouldEncodeWithHeaders$java_util_Map) {
            return this.__M_shouldEncodeWithHeaders(headers);
        }
        try {
            this.__IM.onEntry((Object)this, "shouldEncodeWithHeaders$java_util_Map", new Object[]{headers});
            bl = this.__M_shouldEncodeWithHeaders(headers);
            this.__IM.onExit((Object)this, "shouldEncodeWithHeaders$java_util_Map", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "shouldEncodeWithHeaders$java_util_Map", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_shouldEncodeWithHeaders(Map<String, String> headers) {
        if (headers == null) {
            return true;
        }
        String contentEncoding = headers.get("Content-Encoding");
        return contentEncoding == null || contentEncoding.length() == 0 || contentEncoding.equals("\n") || contentEncoding.equals("identity");
    }

    public boolean shouldEncodeWithMimeType(Renderable<?> renderable) {
        boolean bl;
        if (!this.__MshouldEncodeWithMimeType$org_wisdom_api_http_Renderable) {
            return this.__M_shouldEncodeWithMimeType(renderable);
        }
        try {
            this.__IM.onEntry((Object)this, "shouldEncodeWithMimeType$org_wisdom_api_http_Renderable", new Object[]{renderable});
            bl = this.__M_shouldEncodeWithMimeType(renderable);
            this.__IM.onExit((Object)this, "shouldEncodeWithMimeType$org_wisdom_api_http_Renderable", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "shouldEncodeWithMimeType$org_wisdom_api_http_Renderable", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_shouldEncodeWithMimeType(Renderable<?> renderable) {
        if (renderable == null) {
            return false;
        }
        String mime = renderable.mimetype();
        return mime != null && !KnownMimeTypes.COMPRESSED_MIME.contains(mime);
    }

    public boolean shouldEncodeWithSize(Route route, Renderable<?> renderable) {
        boolean bl;
        if (!this.__MshouldEncodeWithSize$org_wisdom_api_router_Route$org_wisdom_api_http_Renderable) {
            return this.__M_shouldEncodeWithSize(route, renderable);
        }
        try {
            this.__IM.onEntry((Object)this, "shouldEncodeWithSize$org_wisdom_api_router_Route$org_wisdom_api_http_Renderable", new Object[]{route, renderable});
            bl = this.__M_shouldEncodeWithSize(route, renderable);
            this.__IM.onExit((Object)this, "shouldEncodeWithSize$org_wisdom_api_router_Route$org_wisdom_api_http_Renderable", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "shouldEncodeWithSize$org_wisdom_api_router_Route$org_wisdom_api_http_Renderable", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_shouldEncodeWithSize(Route route, Renderable<?> renderable) {
        long maxSize;
        if (renderable == null) {
            return false;
        }
        long renderableLength = renderable.length();
        if (renderable instanceof RenderableURL) {
            return this.getAllowUrlEncodingGlobalSetting();
        }
        if (renderableLength <= 0L) {
            return false;
        }
        long confMaxSize = this.getMaxSizeGlobalSetting();
        long confMinSize = this.getMinSizeGlobalSetting();
        long methodMaxSize = -1L;
        long controllerMaxSize = -1L;
        long methodMinSize = -1L;
        long controllerMinSize = -1L;
        if (route != null && !route.isUnbound()) {
            AllowEncoding allowOnMethod = route.getControllerMethod().getAnnotation(AllowEncoding.class);
            methodMaxSize = allowOnMethod != null ? allowOnMethod.maxSize() : -1L;
            methodMinSize = allowOnMethod != null ? allowOnMethod.minSize() : -1L;
            AllowEncoding allowOnController = route.getControllerClass().getAnnotation(AllowEncoding.class);
            controllerMaxSize = allowOnController != null ? allowOnController.maxSize() : -1L;
            long l = controllerMinSize = allowOnController != null ? allowOnController.minSize() : -1L;
        }
        long l = methodMaxSize != -1L ? methodMaxSize : (maxSize = controllerMaxSize != -1L ? controllerMaxSize : confMaxSize);
        long minSize = methodMinSize != -1L ? methodMinSize : (controllerMinSize != -1L ? controllerMinSize : confMinSize);
        return renderableLength <= maxSize && renderableLength >= minSize;
    }

    public boolean shouldEncodeWithRoute(Route route) {
        boolean bl;
        if (!this.__MshouldEncodeWithRoute$org_wisdom_api_router_Route) {
            return this.__M_shouldEncodeWithRoute(route);
        }
        try {
            this.__IM.onEntry((Object)this, "shouldEncodeWithRoute$org_wisdom_api_router_Route", new Object[]{route});
            bl = this.__M_shouldEncodeWithRoute(route);
            this.__IM.onExit((Object)this, "shouldEncodeWithRoute$org_wisdom_api_router_Route", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "shouldEncodeWithRoute$org_wisdom_api_router_Route", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_shouldEncodeWithRoute(Route route) {
        boolean isAllowOnMethod = false;
        boolean isDenyOnMethod = false;
        boolean isAllowOnController = false;
        boolean isDenyOnController = false;
        if (route != null && !route.isUnbound()) {
            isAllowOnMethod = route.getControllerMethod().getAnnotation(AllowEncoding.class) != null;
            isAllowOnController = route.getControllerClass().getAnnotation(AllowEncoding.class) != null;
            isDenyOnMethod = route.getControllerMethod().getAnnotation(DenyEncoding.class) != null;
            boolean bl = isDenyOnController = route.getControllerClass().getAnnotation(DenyEncoding.class) != null;
        }
        if (this.getAllowEncodingGlobalSetting()) {
            return !isDenyOnMethod && (!isDenyOnController || isAllowOnMethod);
        }
        return isAllowOnMethod || isAllowOnController && !isDenyOnMethod;
    }

    public List<String> parseAcceptEncodingHeader(String headerContent) {
        List<String> list;
        if (!this.__MparseAcceptEncodingHeader$java_lang_String) {
            return this.__M_parseAcceptEncodingHeader(headerContent);
        }
        try {
            this.__IM.onEntry((Object)this, "parseAcceptEncodingHeader$java_lang_String", new Object[]{headerContent});
            list = this.__M_parseAcceptEncodingHeader(headerContent);
            this.__IM.onExit((Object)this, "parseAcceptEncodingHeader$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "parseAcceptEncodingHeader$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __M_parseAcceptEncodingHeader(String headerContent) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<ValuedEncoding> tmp = new ArrayList<ValuedEncoding>();
        if (headerContent == null || headerContent.trim().length() == 0 || headerContent.trim().equals("\n")) {
            return result;
        }
        String[] encodingItems = headerContent.split(",");
        int position = 0;
        for (String encodingItem : encodingItems) {
            ValuedEncoding encoding = new ValuedEncoding(encodingItem, position);
            if (encoding.qValue > 0.0) {
                tmp.add(encoding);
            }
            position += 100;
        }
        ValuedEncoding wildCard = null;
        for (ValuedEncoding valuedEncoding : tmp) {
            if (!valuedEncoding.encoding.equals("*")) continue;
            wildCard = valuedEncoding;
            break;
        }
        if (wildCard != null) {
            List<String> encodingsToAdd = Arrays.asList(EncodingNames.ALL_ENCODINGS);
            tmp.remove(wildCard);
            for (ValuedEncoding valuedEncoding : tmp) {
                encodingsToAdd.remove(valuedEncoding.encoding);
            }
            for (String remainingEncoding : encodingsToAdd) {
                ValuedEncoding valuedEncoding = wildCard;
                Integer n = valuedEncoding.position;
                Integer n2 = valuedEncoding.position = Integer.valueOf(valuedEncoding.position + 1);
                tmp.add(new ValuedEncoding(remainingEncoding, wildCard.qValue, n));
            }
        }
        Collections.sort(tmp);
        for (ValuedEncoding encoding : tmp) {
            result.add(encoding.encoding);
        }
        return result;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("allowEncodingGlobalSetting")) {
                this.__FallowEncodingGlobalSetting = true;
            }
            if (set.contains("allowUrlEncodingGlobalSetting")) {
                this.__FallowUrlEncodingGlobalSetting = true;
            }
            if (set.contains("configuration")) {
                this.__Fconfiguration = true;
            }
            if (set.contains("maxSizeGlobalSetting")) {
                this.__FmaxSizeGlobalSetting = true;
            }
            if (set.contains("minSizeGlobalSetting")) {
                this.__FminSizeGlobalSetting = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("setConfiguration$org_wisdom_api_configuration_ApplicationConfiguration")) {
                this.__MsetConfiguration$org_wisdom_api_configuration_ApplicationConfiguration = true;
            }
            if (set.contains("getAllowEncodingGlobalSetting")) {
                this.__MgetAllowEncodingGlobalSetting = true;
            }
            if (set.contains("getAllowUrlEncodingGlobalSetting")) {
                this.__MgetAllowUrlEncodingGlobalSetting = true;
            }
            if (set.contains("getMaxSizeGlobalSetting")) {
                this.__MgetMaxSizeGlobalSetting = true;
            }
            if (set.contains("getMinSizeGlobalSetting")) {
                this.__MgetMinSizeGlobalSetting = true;
            }
            if (set.contains("shouldEncode$org_wisdom_api_http_Context$org_wisdom_api_http_Result$org_wisdom_api_http_Renderable")) {
                this.__MshouldEncode$org_wisdom_api_http_Context$org_wisdom_api_http_Result$org_wisdom_api_http_Renderable = true;
            }
            if (set.contains("shouldEncodeWithHeaders$java_util_Map")) {
                this.__MshouldEncodeWithHeaders$java_util_Map = true;
            }
            if (set.contains("shouldEncodeWithMimeType$org_wisdom_api_http_Renderable")) {
                this.__MshouldEncodeWithMimeType$org_wisdom_api_http_Renderable = true;
            }
            if (set.contains("shouldEncodeWithSize$org_wisdom_api_router_Route$org_wisdom_api_http_Renderable")) {
                this.__MshouldEncodeWithSize$org_wisdom_api_router_Route$org_wisdom_api_http_Renderable = true;
            }
            if (set.contains("shouldEncodeWithRoute$org_wisdom_api_router_Route")) {
                this.__MshouldEncodeWithRoute$org_wisdom_api_router_Route = true;
            }
            if (set.contains("parseAcceptEncodingHeader$java_lang_String")) {
                this.__MparseAcceptEncodingHeader$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

