/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.content.encoding;

public class ValuedEncoding
implements Comparable<ValuedEncoding> {
    String encoding = null;
    Double qValue = 1.0;
    Integer position;

    public ValuedEncoding(String encodingName, Double qValue, int position) {
        this.encoding = encodingName;
        this.qValue = qValue;
        this.position = position;
    }

    public ValuedEncoding(String encodingItem, int position) {
        this.position = position;
        String[] encodingParts = encodingItem.split(";");
        this.encoding = encodingParts[0].trim().replace("\n", "");
        if (encodingParts.length > 1) {
            this.qValue = Double.parseDouble(encodingParts[1].trim().replace("\n", "").replace("q=", ""));
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Double getqValue() {
        return this.qValue;
    }

    public Integer getPosition() {
        return this.position;
    }

    @Override
    public int compareTo(ValuedEncoding o) {
        if (this.qValue.equals(o.qValue)) {
            return this.position.compareTo(o.position);
        }
        return this.qValue.compareTo(o.qValue) * -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ValuedEncoding)) {
            return false;
        }
        ValuedEncoding ov = (ValuedEncoding)obj;
        return this.getPosition().equals(ov.getPosition()) && this.getEncoding().equals(ov.getEncoding()) && this.getqValue().equals(ov.getqValue());
    }

    public int hashCode() {
        int enc = this.encoding != null ? this.encoding.hashCode() : 0;
        int qval = this.qValue != null ? this.qValue.hashCode() : 0;
        return 31 * (enc + qval + this.position);
    }
}

