/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.content.engines;

import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.slf4j.LoggerFactory;
import org.wisdom.api.content.BodyParser;
import org.wisdom.api.content.ContentCodec;
import org.wisdom.api.content.ContentEncodingHelper;
import org.wisdom.api.content.ContentEngine;
import org.wisdom.api.content.ContentSerializer;

@Component
@Provides
@Instantiate(name="ContentEngine")
public class Engine
implements ContentEngine,
Pojo {
    InstanceManager __IM;
    private boolean __Fparsers;
    @Requires(specification=BodyParser.class, optional=true)
    List<BodyParser> parsers;
    private boolean __Fserializers;
    @Requires(specification=ContentSerializer.class, optional=true)
    List<ContentSerializer> serializers;
    private boolean __Fencoders;
    @Requires(specification=ContentCodec.class, optional=true)
    List<ContentCodec> encoders;
    private boolean __FencodingHelper;
    @Requires(specification=ContentEncodingHelper.class, optional=true)
    ContentEncodingHelper encodingHelper;
    boolean __MgetBodyParserEngineForContentType$java_lang_String;
    boolean __MgetContentSerializerForContentType$java_lang_String;
    boolean __MgetBestSerializer$java_util_Collection;
    boolean __MgetContentCodecForEncodingType$java_lang_String;
    boolean __MgetContentEncodingHelper;

    List __getparsers() {
        if (!this.__Fparsers) {
            return this.parsers;
        }
        return (List)this.__IM.onGet((Object)this, "parsers");
    }

    void __setparsers(List list) {
        if (!this.__Fparsers) {
            this.parsers = list;
            return;
        }
        this.__IM.onSet((Object)this, "parsers", (Object)list);
    }

    List __getserializers() {
        if (!this.__Fserializers) {
            return this.serializers;
        }
        return (List)this.__IM.onGet((Object)this, "serializers");
    }

    void __setserializers(List list) {
        if (!this.__Fserializers) {
            this.serializers = list;
            return;
        }
        this.__IM.onSet((Object)this, "serializers", (Object)list);
    }

    List __getencoders() {
        if (!this.__Fencoders) {
            return this.encoders;
        }
        return (List)this.__IM.onGet((Object)this, "encoders");
    }

    void __setencoders(List list) {
        if (!this.__Fencoders) {
            this.encoders = list;
            return;
        }
        this.__IM.onSet((Object)this, "encoders", (Object)list);
    }

    ContentEncodingHelper __getencodingHelper() {
        if (!this.__FencodingHelper) {
            return this.encodingHelper;
        }
        return (ContentEncodingHelper)this.__IM.onGet((Object)this, "encodingHelper");
    }

    void __setencodingHelper(ContentEncodingHelper contentEncodingHelper) {
        if (!this.__FencodingHelper) {
            this.encodingHelper = contentEncodingHelper;
            return;
        }
        this.__IM.onSet((Object)this, "encodingHelper", (Object)contentEncodingHelper);
    }

    public Engine() {
        this(null);
    }

    private Engine(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public BodyParser getBodyParserEngineForContentType(String contentType) {
        BodyParser bodyParser;
        if (!this.__MgetBodyParserEngineForContentType$java_lang_String) {
            return this.__M_getBodyParserEngineForContentType(contentType);
        }
        try {
            this.__IM.onEntry((Object)this, "getBodyParserEngineForContentType$java_lang_String", new Object[]{contentType});
            bodyParser = this.__M_getBodyParserEngineForContentType(contentType);
            this.__IM.onExit((Object)this, "getBodyParserEngineForContentType$java_lang_String", (Object)bodyParser);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getBodyParserEngineForContentType$java_lang_String", throwable);
            throw throwable;
        }
        return bodyParser;
    }

    private BodyParser __M_getBodyParserEngineForContentType(String contentType) {
        for (BodyParser parser : this.__getparsers()) {
            if (!parser.getContentTypes().contains(contentType)) continue;
            return parser;
        }
        LoggerFactory.getLogger(this.getClass()).info("Cannot find a body parser for " + contentType);
        return null;
    }

    public ContentSerializer getContentSerializerForContentType(String contentType) {
        ContentSerializer contentSerializer;
        if (!this.__MgetContentSerializerForContentType$java_lang_String) {
            return this.__M_getContentSerializerForContentType(contentType);
        }
        try {
            this.__IM.onEntry((Object)this, "getContentSerializerForContentType$java_lang_String", new Object[]{contentType});
            contentSerializer = this.__M_getContentSerializerForContentType(contentType);
            this.__IM.onExit((Object)this, "getContentSerializerForContentType$java_lang_String", (Object)contentSerializer);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getContentSerializerForContentType$java_lang_String", throwable);
            throw throwable;
        }
        return contentSerializer;
    }

    private ContentSerializer __M_getContentSerializerForContentType(String contentType) {
        for (ContentSerializer renderer : this.__getserializers()) {
            if (!renderer.getContentType().equals(contentType)) continue;
            return renderer;
        }
        LoggerFactory.getLogger(this.getClass()).info("Cannot find a content renderer handling " + contentType);
        return null;
    }

    public ContentSerializer getBestSerializer(Collection<MediaType> mediaTypes) {
        ContentSerializer contentSerializer;
        if (!this.__MgetBestSerializer$java_util_Collection) {
            return this.__M_getBestSerializer(mediaTypes);
        }
        try {
            this.__IM.onEntry((Object)this, "getBestSerializer$java_util_Collection", new Object[]{mediaTypes});
            contentSerializer = this.__M_getBestSerializer(mediaTypes);
            this.__IM.onExit((Object)this, "getBestSerializer$java_util_Collection", (Object)contentSerializer);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getBestSerializer$java_util_Collection", throwable);
            throw throwable;
        }
        return contentSerializer;
    }

    private ContentSerializer __M_getBestSerializer(Collection<MediaType> mediaTypes) {
        if (mediaTypes == null || mediaTypes.isEmpty()) {
            mediaTypes = ImmutableList.of((Object)MediaType.HTML_UTF_8);
        }
        for (MediaType type : mediaTypes) {
            for (ContentSerializer ser : this.__getserializers()) {
                MediaType mt = MediaType.parse((String)ser.getContentType());
                if (!mt.is(type.withoutParameters())) continue;
                return ser;
            }
        }
        return null;
    }

    public ContentCodec getContentCodecForEncodingType(String encoding) {
        ContentCodec contentCodec;
        if (!this.__MgetContentCodecForEncodingType$java_lang_String) {
            return this.__M_getContentCodecForEncodingType(encoding);
        }
        try {
            this.__IM.onEntry((Object)this, "getContentCodecForEncodingType$java_lang_String", new Object[]{encoding});
            contentCodec = this.__M_getContentCodecForEncodingType(encoding);
            this.__IM.onExit((Object)this, "getContentCodecForEncodingType$java_lang_String", (Object)contentCodec);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getContentCodecForEncodingType$java_lang_String", throwable);
            throw throwable;
        }
        return contentCodec;
    }

    private ContentCodec __M_getContentCodecForEncodingType(String encoding) {
        for (ContentCodec codec : this.__getencoders()) {
            if (!codec.getEncodingType().equals(encoding)) continue;
            return codec;
        }
        return null;
    }

    public ContentEncodingHelper getContentEncodingHelper() {
        ContentEncodingHelper contentEncodingHelper;
        if (!this.__MgetContentEncodingHelper) {
            return this.__M_getContentEncodingHelper();
        }
        try {
            this.__IM.onEntry((Object)this, "getContentEncodingHelper", new Object[0]);
            contentEncodingHelper = this.__M_getContentEncodingHelper();
            this.__IM.onExit((Object)this, "getContentEncodingHelper", (Object)contentEncodingHelper);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getContentEncodingHelper", throwable);
            throw throwable;
        }
        return contentEncodingHelper;
    }

    private ContentEncodingHelper __M_getContentEncodingHelper() {
        return this.__getencodingHelper();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("encoders")) {
                this.__Fencoders = true;
            }
            if (set.contains("encodingHelper")) {
                this.__FencodingHelper = true;
            }
            if (set.contains("parsers")) {
                this.__Fparsers = true;
            }
            if (set.contains("serializers")) {
                this.__Fserializers = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getBodyParserEngineForContentType$java_lang_String")) {
                this.__MgetBodyParserEngineForContentType$java_lang_String = true;
            }
            if (set.contains("getContentSerializerForContentType$java_lang_String")) {
                this.__MgetContentSerializerForContentType$java_lang_String = true;
            }
            if (set.contains("getBestSerializer$java_util_Collection")) {
                this.__MgetBestSerializer$java_util_Collection = true;
            }
            if (set.contains("getContentCodecForEncodingType$java_lang_String")) {
                this.__MgetContentCodecForEncodingType$java_lang_String = true;
            }
            if (set.contains("getContentEncodingHelper")) {
                this.__MgetContentEncodingHelper = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

