/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.jdbc.driver.helpers;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;

public class BeanUtils {
    private BeanUtils() {
    }

    public static void setProperty(Object object, String name, String value) throws SQLException {
        PropertyDescriptor[] descriptors;
        Class<?> type = object.getClass();
        try {
            descriptors = Introspector.getBeanInfo(type).getPropertyDescriptors();
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
        ArrayList<String> names = new ArrayList<String>();
        for (PropertyDescriptor descriptor : descriptors) {
            if (descriptor.getWriteMethod() == null) continue;
            if (descriptor.getName().equals(name)) {
                Method method = descriptor.getWriteMethod();
                Class<?> paramType = method.getParameterTypes()[0];
                Object param = BeanUtils.toBasicType(value, paramType.getName());
                try {
                    method.invoke(object, param);
                }
                catch (Exception ex) {
                    throw new SQLException(ex);
                }
                return;
            }
            names.add(descriptor.getName());
        }
        throw new SQLException("No such property: " + name + ", exists.  Writable properties are: " + names);
    }

    public static Object toBasicType(String value, String type) throws SQLException {
        if (value == null) {
            return null;
        }
        if (type == null || type.equals(String.class.getName())) {
            return value;
        }
        if (type.equals(Integer.class.getName()) || type.equals(Integer.TYPE.getName())) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                BeanUtils.throwSQLException(e, "Integer", value);
            }
        }
        if (type.equals(Float.class.getName()) || type.equals(Float.TYPE.getName())) {
            try {
                return Float.valueOf(value);
            }
            catch (NumberFormatException e) {
                BeanUtils.throwSQLException(e, "Float", value);
            }
        }
        if (type.equals(Long.class.getName()) || type.equals(Long.TYPE.getName())) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                BeanUtils.throwSQLException(e, "Long", value);
            }
        }
        if (type.equals(Double.class.getName()) || type.equals(Double.TYPE.getName())) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                BeanUtils.throwSQLException(e, "Double", value);
            }
        }
        if (type.equals(Character.class.getName()) || type.equals(Character.TYPE.getName())) {
            if (value.length() != 1) {
                throw new SQLException("Invalid Character value: " + value);
            }
            return Character.valueOf(value.charAt(0));
        }
        if (type.equals(Byte.class.getName()) || type.equals(Byte.TYPE.getName())) {
            try {
                return Byte.valueOf(value);
            }
            catch (NumberFormatException e) {
                BeanUtils.throwSQLException(e, "Byte", value);
            }
        }
        if (type.equals(Short.class.getName()) || type.equals(Short.TYPE.getName())) {
            try {
                return Short.valueOf(value);
            }
            catch (NumberFormatException e) {
                BeanUtils.throwSQLException(e, "Short", value);
            }
        }
        if (type.equals(Boolean.class.getName()) || type.equals(Boolean.TYPE.getName())) {
            return Boolean.valueOf(value);
        }
        throw new SQLException("Unrecognized property type: " + type);
    }

    public static void throwSQLException(Exception cause, String theType, String value) throws SQLException {
        throw new SQLException("Invalid " + theType + " value: " + value, cause);
    }
}

