/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.jcr;

import java.util.Set;
import javax.jcr.Node;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Requires;
import org.wisdom.api.DefaultController;
import org.wisdom.api.annotations.Controller;
import org.wisdom.api.annotations.Parameter;
import org.wisdom.api.annotations.Path;
import org.wisdom.api.annotations.Route;
import org.wisdom.api.annotations.View;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Result;
import org.wisdom.api.security.Authenticated;
import org.wisdom.api.templates.Template;
import org.wisdom.jcrom.runtime.JcrRepository;
import org.wisdom.monitor.extensions.jcr.JcrExplorerModel;
import org.wisdom.monitor.service.MonitorExtension;

@Path(value="/monitor/jcr/explorer")
@Authenticated(value="Monitor-Authenticator")
@Controller
public class JcrExplorerExtension
extends DefaultController
implements MonitorExtension,
Pojo {
    InstanceManager __IM;
    private boolean __Fexplorer;
    @View(value="monitor/explorer")
    Template explorer;
    private boolean __FjcrRepository;
    @Requires
    JcrRepository jcrRepository;
    boolean __Mexplorer$java_lang_String$java_lang_String;
    boolean __Mlabel;
    boolean __Murl;
    boolean __Mcategory;

    Template __getexplorer() {
        if (!this.__Fexplorer) {
            return this.explorer;
        }
        return (Template)this.__IM.onGet((Object)this, "explorer");
    }

    void __setexplorer(Template template) {
        if (!this.__Fexplorer) {
            this.explorer = template;
            return;
        }
        this.__IM.onSet((Object)this, "explorer", (Object)template);
    }

    JcrRepository __getjcrRepository() {
        if (!this.__FjcrRepository) {
            return this.jcrRepository;
        }
        return (JcrRepository)this.__IM.onGet((Object)this, "jcrRepository");
    }

    void __setjcrRepository(JcrRepository jcrRepository) {
        if (!this.__FjcrRepository) {
            this.jcrRepository = jcrRepository;
            return;
        }
        this.__IM.onSet((Object)this, "jcrRepository", (Object)jcrRepository);
    }

    public JcrExplorerExtension() {
        this(null);
    }

    private JcrExplorerExtension(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    @Route(uri="/{workspace}/{path*}", method=HttpMethod.GET)
    public Result explorer(@Parameter(value="path") String path, @Parameter(value="workspace") String workspace) throws Exception {
        Result result;
        if (!this.__Mexplorer$java_lang_String$java_lang_String) {
            return this.__M_explorer(path, workspace);
        }
        try {
            this.__IM.onEntry((Object)this, "explorer$java_lang_String$java_lang_String", new Object[]{path, workspace});
            result = this.__M_explorer(path, workspace);
            this.__IM.onExit((Object)this, "explorer$java_lang_String$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "explorer$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result __M_explorer(String path, String workspace) throws Exception {
        path = path.isEmpty() ? "/" : "/" + path;
        Node node = null;
        if (workspace != null) {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                node = this.__getjcrRepository().getRepository().login(workspace).getNode(path);
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        } else {
            node = this.__getjcrRepository().getSession().getNode(path);
        }
        JcrExplorerModel jcrExplorerModel = JcrExplorerModel.build(node);
        return JcrExplorerExtension.ok((Object)this.render(this.__getexplorer(), new Object[]{"nodeModel", jcrExplorerModel, "repository", this.__getjcrRepository(), "currentWorkspace", workspace, "workspaces", this.__getjcrRepository().getSession().getWorkspace().getAccessibleWorkspaceNames()}));
    }

    public String label() {
        String string;
        if (!this.__Mlabel) {
            return this.__M_label();
        }
        try {
            this.__IM.onEntry((Object)this, "label", new Object[0]);
            string = this.__M_label();
            this.__IM.onExit((Object)this, "label", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "label", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_label() {
        return "Explorer";
    }

    public String url() {
        String string;
        if (!this.__Murl) {
            return this.__M_url();
        }
        try {
            this.__IM.onEntry((Object)this, "url", new Object[0]);
            string = this.__M_url();
            this.__IM.onExit((Object)this, "url", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "url", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_url() {
        String currentWorkspace = this.__getjcrRepository().getSession().getWorkspace().getName();
        return "/monitor/jcr/explorer/" + currentWorkspace + "/";
    }

    public String category() {
        String string;
        if (!this.__Mcategory) {
            return this.__M_category();
        }
        try {
            this.__IM.onEntry((Object)this, "category", new Object[0]);
            string = this.__M_category();
            this.__IM.onExit((Object)this, "category", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "category", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_category() {
        return "JCR";
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("explorer")) {
                this.__Fexplorer = true;
            }
            if (set.contains("jcrRepository")) {
                this.__FjcrRepository = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("explorer$java_lang_String$java_lang_String")) {
                this.__Mexplorer$java_lang_String$java_lang_String = true;
            }
            if (set.contains("label")) {
                this.__Mlabel = true;
            }
            if (set.contains("url")) {
                this.__Murl = true;
            }
            if (set.contains("category")) {
                this.__Mcategory = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

