/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.jcr;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;

public class JcrExplorerModel {
    private Node node;
    private List<Node> subnodes = new ArrayList<Node>();
    private Map<String, String> properties = new HashMap<String, String>();
    private List<String> mixins = new ArrayList<String>();

    public static JcrExplorerModel build(Node node) throws Exception {
        return new JcrExplorerModel(node);
    }

    private JcrExplorerModel(Node node) throws RepositoryException {
        this.node = node;
        this.buildSubNodes();
        this.buildProperties();
        this.buildMixins();
    }

    public Node getNode() {
        return this.node;
    }

    public List<Node> getSubnodes() {
        return this.subnodes;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public List<String> getMixins() {
        return this.mixins;
    }

    private void buildSubNodes() throws RepositoryException {
        NodeIterator nodeIterator = this.node.getNodes();
        while (nodeIterator.hasNext()) {
            Node nextNode = nodeIterator.nextNode();
            this.subnodes.add(nextNode);
        }
    }

    private void buildProperties() throws RepositoryException {
        PropertyIterator propertyIterator = this.node.getProperties();
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.nextProperty();
            if (this.node.getPrimaryNodeType().isNodeType("nt:resource") && property.getName().equals("jcr:data")) continue;
            this.properties.put(property.getName(), this.getPropertyValue(property));
        }
    }

    private void buildMixins() throws RepositoryException {
        for (NodeType nodeType : this.node.getMixinNodeTypes()) {
            this.mixins.add(nodeType.getName());
        }
    }

    private String getPropertyValue(Property property) {
        try {
            String result = "";
            if (!property.isMultiple()) {
                result = result + this.showProperly(property.getValue());
            } else {
                for (Value value : property.getValues()) {
                    result = result + this.showProperly(value) + " - ";
                }
                result = result.substring(0, result.lastIndexOf(" - "));
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String showProperly(Value value) throws RepositoryException, IOException, ClassNotFoundException {
        if (value.getType() == 2) {
            return new ObjectInputStream(value.getBinary().getStream()).readObject().toString();
        }
        return value.getString();
    }
}

