/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.crypto;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.crypto.Crypto;
import org.wisdom.api.crypto.Hash;

@Component
@Provides
@Instantiate(name="crypto")
public class CryptoServiceSingleton
implements Crypto,
Pojo {
    InstanceManager __IM;
    public static final String AES_ECB_ALGORITHM = "AES";
    private static final Charset UTF_8 = Charsets.UTF_8;
    public static final String HMAC_SHA_1 = "HmacSHA1";
    public static final String PBKDF_2_WITH_HMAC_SHA_1 = "PBKDF2WithHmacSHA1";
    private boolean __Ftransformation;
    private final String transformation;
    private boolean __FkeySize;
    private final int keySize;
    private boolean __FiterationCount;
    private final int iterationCount;
    private boolean __FdefaultHash;
    private final Hash defaultHash;
    private boolean __Fsecret;
    private final String secret;
    private boolean __Frandom;
    private final SecureRandom random;
    boolean __MgenerateAESKey$java_lang_String$java_lang_String;
    boolean __MencryptAESWithCBC$java_lang_String$java_lang_String;
    boolean __MencryptAESWithCBC$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    boolean __MdecryptAESWithCBC$java_lang_String$java_lang_String;
    boolean __MdecryptAESWithCBC$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    boolean __MdoFinal$int$javax_crypto_SecretKey$java_lang_String$byte__;
    boolean __Msign$java_lang_String;
    boolean __Msign$java_lang_String$byte__;
    boolean __Mhash$java_lang_String;
    boolean __Mhash$java_lang_String$org_wisdom_api_crypto_Hash;
    boolean __MencryptAES$java_lang_String;
    boolean __MencryptAES$java_lang_String$java_lang_String;
    boolean __MdecryptAES$java_lang_String;
    boolean __MdecryptAES$java_lang_String$java_lang_String;
    boolean __MgetSecretPrefix;
    boolean __MgetDefaultIV;
    boolean __MsignToken$java_lang_String;
    boolean __MextractSignedToken$java_lang_String;
    boolean __MconstantTimeEquals$java_lang_String$java_lang_String;
    boolean __MencodeBase64$byte__;
    boolean __MdecodeBase64$java_lang_String;
    boolean __MhexMD5$java_lang_String;
    boolean __MhexSHA1$java_lang_String;
    boolean __MgenerateToken;
    boolean __MgenerateSignedToken;
    boolean __McompareSignedTokens$java_lang_String$java_lang_String;
    boolean __Mmd5$java_lang_String;
    boolean __Msha1$java_lang_String;
    boolean __Mhex$byte__;
    boolean __MhexToString$byte__;
    boolean __MdecodeHex$java_lang_String;

    String __gettransformation() {
        if (!this.__Ftransformation) {
            return this.transformation;
        }
        return (String)this.__IM.onGet((Object)this, "transformation");
    }

    void __settransformation(String string) {
        if (!this.__Ftransformation) {
            this.transformation = string;
            return;
        }
        this.__IM.onSet((Object)this, "transformation", (Object)string);
    }

    int __getkeySize() {
        if (!this.__FkeySize) {
            return this.keySize;
        }
        Object object = this.__IM.onGet((Object)this, "keySize");
        Integer n = (Integer)object;
        return n;
    }

    void __setkeySize(int n) {
        if (!this.__FkeySize) {
            this.keySize = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "keySize", (Object)n2);
    }

    int __getiterationCount() {
        if (!this.__FiterationCount) {
            return this.iterationCount;
        }
        Object object = this.__IM.onGet((Object)this, "iterationCount");
        Integer n = (Integer)object;
        return n;
    }

    void __setiterationCount(int n) {
        if (!this.__FiterationCount) {
            this.iterationCount = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "iterationCount", (Object)n2);
    }

    Hash __getdefaultHash() {
        if (!this.__FdefaultHash) {
            return this.defaultHash;
        }
        return (Hash)this.__IM.onGet((Object)this, "defaultHash");
    }

    void __setdefaultHash(Hash hash) {
        if (!this.__FdefaultHash) {
            this.defaultHash = hash;
            return;
        }
        this.__IM.onSet((Object)this, "defaultHash", (Object)hash);
    }

    String __getsecret() {
        if (!this.__Fsecret) {
            return this.secret;
        }
        return (String)this.__IM.onGet((Object)this, "secret");
    }

    void __setsecret(String string) {
        if (!this.__Fsecret) {
            this.secret = string;
            return;
        }
        this.__IM.onSet((Object)this, "secret", (Object)string);
    }

    SecureRandom __getrandom() {
        if (!this.__Frandom) {
            return this.random;
        }
        return (SecureRandom)this.__IM.onGet((Object)this, "random");
    }

    void __setrandom(SecureRandom secureRandom) {
        if (!this.__Frandom) {
            this.random = secureRandom;
            return;
        }
        this.__IM.onSet((Object)this, "random", (Object)secureRandom);
    }

    public CryptoServiceSingleton(@Requires ApplicationConfiguration configuration) {
        this(null, configuration);
    }

    private CryptoServiceSingleton(InstanceManager _manager, ApplicationConfiguration configuration) {
        this(configuration.getOrDie("application.secret"), Hash.valueOf((String)configuration.getWithDefault("crypto.default-hash", "MD5")), configuration.getIntegerWithDefault("crypto.aes.key-size", Integer.valueOf(128)), configuration.getWithDefault("crypto.aes.transformation", "AES/CBC/PKCS5Padding"), configuration.getIntegerWithDefault("crypto.aes.iterations", Integer.valueOf(20)));
    }

    public CryptoServiceSingleton(String secret, Hash defaultHash, Integer keySize, String transformation, Integer iterationCount) {
        this(null, secret, defaultHash, keySize, transformation, iterationCount);
    }

    private CryptoServiceSingleton(InstanceManager _manager, String secret, Hash defaultHash, Integer keySize, String transformation, Integer iterationCount) {
        this._setInstanceManager(_manager);
        this.__setrandom(new SecureRandom());
        this.__setsecret(secret);
        this.__setdefaultHash(defaultHash);
        this.__setkeySize(keySize);
        this.__setiterationCount(iterationCount);
        this.__settransformation(transformation);
    }

    private SecretKey generateAESKey(String privateKey, String salt) {
        SecretKey secretKey;
        if (!this.__MgenerateAESKey$java_lang_String$java_lang_String) {
            return this.__M_generateAESKey(privateKey, salt);
        }
        try {
            this.__IM.onEntry((Object)this, "generateAESKey$java_lang_String$java_lang_String", new Object[]{privateKey, salt});
            secretKey = this.__M_generateAESKey(privateKey, salt);
            this.__IM.onExit((Object)this, "generateAESKey$java_lang_String$java_lang_String", (Object)secretKey);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateAESKey$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return secretKey;
    }

    private SecretKey __M_generateAESKey(String privateKey, String salt) {
        try {
            byte[] raw = this.decodeHex(salt);
            PBEKeySpec spec = new PBEKeySpec(privateKey.toCharArray(), raw, this.__getiterationCount(), this.__getkeySize());
            SecretKeyFactory factory = SecretKeyFactory.getInstance(PBKDF_2_WITH_HMAC_SHA_1);
            return new SecretKeySpec(factory.generateSecret(spec).getEncoded(), AES_ECB_ALGORITHM);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
    }

    public String encryptAESWithCBC(String value, String salt) {
        String string;
        if (!this.__MencryptAESWithCBC$java_lang_String$java_lang_String) {
            return this.__M_encryptAESWithCBC(value, salt);
        }
        try {
            this.__IM.onEntry((Object)this, "encryptAESWithCBC$java_lang_String$java_lang_String", new Object[]{value, salt});
            string = this.__M_encryptAESWithCBC(value, salt);
            this.__IM.onExit((Object)this, "encryptAESWithCBC$java_lang_String$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "encryptAESWithCBC$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_encryptAESWithCBC(String value, String salt) {
        return this.encryptAESWithCBC(value, this.getSecretPrefix(), salt, this.getDefaultIV());
    }

    public String encryptAESWithCBC(String value, String privateKey, String salt, String iv) {
        String string;
        if (!this.__MencryptAESWithCBC$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_encryptAESWithCBC(value, privateKey, salt, iv);
        }
        try {
            this.__IM.onEntry((Object)this, "encryptAESWithCBC$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{value, privateKey, salt, iv});
            string = this.__M_encryptAESWithCBC(value, privateKey, salt, iv);
            this.__IM.onExit((Object)this, "encryptAESWithCBC$java_lang_String$java_lang_String$java_lang_String$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "encryptAESWithCBC$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_encryptAESWithCBC(String value, String privateKey, String salt, String iv) {
        SecretKey genKey = this.generateAESKey(privateKey, salt);
        byte[] encrypted = this.doFinal(1, genKey, iv, value.getBytes(UTF_8));
        return this.encodeBase64(encrypted);
    }

    public String decryptAESWithCBC(String value, String salt) {
        String string;
        if (!this.__MdecryptAESWithCBC$java_lang_String$java_lang_String) {
            return this.__M_decryptAESWithCBC(value, salt);
        }
        try {
            this.__IM.onEntry((Object)this, "decryptAESWithCBC$java_lang_String$java_lang_String", new Object[]{value, salt});
            string = this.__M_decryptAESWithCBC(value, salt);
            this.__IM.onExit((Object)this, "decryptAESWithCBC$java_lang_String$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "decryptAESWithCBC$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_decryptAESWithCBC(String value, String salt) {
        return this.decryptAESWithCBC(value, this.getSecretPrefix(), salt, this.getDefaultIV());
    }

    public String decryptAESWithCBC(String value, String privateKey, String salt, String iv) {
        String string;
        if (!this.__MdecryptAESWithCBC$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_decryptAESWithCBC(value, privateKey, salt, iv);
        }
        try {
            this.__IM.onEntry((Object)this, "decryptAESWithCBC$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{value, privateKey, salt, iv});
            string = this.__M_decryptAESWithCBC(value, privateKey, salt, iv);
            this.__IM.onExit((Object)this, "decryptAESWithCBC$java_lang_String$java_lang_String$java_lang_String$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "decryptAESWithCBC$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_decryptAESWithCBC(String value, String privateKey, String salt, String iv) {
        SecretKey key = this.generateAESKey(privateKey, salt);
        byte[] decrypted = this.doFinal(2, key, iv, this.decodeBase64(value));
        return new String(decrypted, UTF_8);
    }

    private byte[] doFinal(int encryptMode, SecretKey generatedKey, String vector, byte[] message) {
        byte[] byArray;
        if (!this.__MdoFinal$int$javax_crypto_SecretKey$java_lang_String$byte__) {
            return this.__M_doFinal(encryptMode, generatedKey, vector, message);
        }
        try {
            this.__IM.onEntry((Object)this, "doFinal$int$javax_crypto_SecretKey$java_lang_String$byte__", new Object[]{new Integer(encryptMode), generatedKey, vector, message});
            byArray = this.__M_doFinal(encryptMode, generatedKey, vector, message);
            this.__IM.onExit((Object)this, "doFinal$int$javax_crypto_SecretKey$java_lang_String$byte__", (Object)byArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doFinal$int$javax_crypto_SecretKey$java_lang_String$byte__", throwable);
            throw throwable;
        }
        return byArray;
    }

    private byte[] __M_doFinal(int encryptMode, SecretKey generatedKey, String vector, byte[] message) {
        try {
            byte[] raw = this.decodeHex(vector);
            Cipher cipher = Cipher.getInstance(this.__gettransformation());
            cipher.init(encryptMode, (Key)generatedKey, new IvParameterSpec(raw));
            return cipher.doFinal(message);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IllegalStateException(e);
        }
    }

    public String sign(String message) {
        String string;
        if (!this.__Msign$java_lang_String) {
            return this.__M_sign(message);
        }
        try {
            this.__IM.onEntry((Object)this, "sign$java_lang_String", new Object[]{message});
            string = this.__M_sign(message);
            this.__IM.onExit((Object)this, "sign$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "sign$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_sign(String message) {
        return this.sign(message, this.__getsecret().getBytes(Charsets.UTF_8));
    }

    public String sign(String message, byte[] key) {
        String string;
        if (!this.__Msign$java_lang_String$byte__) {
            return this.__M_sign(message, key);
        }
        try {
            this.__IM.onEntry((Object)this, "sign$java_lang_String$byte__", new Object[]{message, key});
            string = this.__M_sign(message, key);
            this.__IM.onExit((Object)this, "sign$java_lang_String$byte__", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "sign$java_lang_String$byte__", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_sign(String message, byte[] key) {
        Preconditions.checkNotNull((Object)message);
        Preconditions.checkNotNull((Object)key);
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key, HMAC_SHA_1);
            Mac mac = Mac.getInstance(HMAC_SHA_1);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(message.getBytes(Charsets.UTF_8));
            return this.hexToString(rawHmac);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String hash(String input) {
        String string;
        if (!this.__Mhash$java_lang_String) {
            return this.__M_hash(input);
        }
        try {
            this.__IM.onEntry((Object)this, "hash$java_lang_String", new Object[]{input});
            string = this.__M_hash(input);
            this.__IM.onExit((Object)this, "hash$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "hash$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_hash(String input) {
        return this.hash(input, this.__getdefaultHash());
    }

    public String hash(String input, Hash hashType) {
        String string;
        if (!this.__Mhash$java_lang_String$org_wisdom_api_crypto_Hash) {
            return this.__M_hash(input, hashType);
        }
        try {
            this.__IM.onEntry((Object)this, "hash$java_lang_String$org_wisdom_api_crypto_Hash", new Object[]{input, hashType});
            string = this.__M_hash(input, hashType);
            this.__IM.onExit((Object)this, "hash$java_lang_String$org_wisdom_api_crypto_Hash", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "hash$java_lang_String$org_wisdom_api_crypto_Hash", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_hash(String input, Hash hashType) {
        Preconditions.checkNotNull((Object)input);
        Preconditions.checkNotNull((Object)hashType);
        try {
            MessageDigest m = MessageDigest.getInstance(hashType.toString());
            byte[] out = m.digest(input.getBytes(Charsets.UTF_8));
            return this.encodeBase64(out);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String encryptAES(String value) {
        String string;
        if (!this.__MencryptAES$java_lang_String) {
            return this.__M_encryptAES(value);
        }
        try {
            this.__IM.onEntry((Object)this, "encryptAES$java_lang_String", new Object[]{value});
            string = this.__M_encryptAES(value);
            this.__IM.onExit((Object)this, "encryptAES$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "encryptAES$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_encryptAES(String value) {
        return this.encryptAES(value, this.getSecretPrefix());
    }

    public String encryptAES(String value, String privateKey) {
        String string;
        if (!this.__MencryptAES$java_lang_String$java_lang_String) {
            return this.__M_encryptAES(value, privateKey);
        }
        try {
            this.__IM.onEntry((Object)this, "encryptAES$java_lang_String$java_lang_String", new Object[]{value, privateKey});
            string = this.__M_encryptAES(value, privateKey);
            this.__IM.onExit((Object)this, "encryptAES$java_lang_String$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "encryptAES$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_encryptAES(String value, String privateKey) {
        try {
            byte[] raw = privateKey.getBytes(UTF_8);
            SecretKeySpec skeySpec = new SecretKeySpec(raw, AES_ECB_ALGORITHM);
            Cipher cipher = Cipher.getInstance(AES_ECB_ALGORITHM);
            cipher.init(1, skeySpec);
            return this.hexToString(cipher.doFinal(value.getBytes(Charsets.UTF_8)));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IllegalStateException(e);
        }
    }

    public String decryptAES(String value) {
        String string;
        if (!this.__MdecryptAES$java_lang_String) {
            return this.__M_decryptAES(value);
        }
        try {
            this.__IM.onEntry((Object)this, "decryptAES$java_lang_String", new Object[]{value});
            string = this.__M_decryptAES(value);
            this.__IM.onExit((Object)this, "decryptAES$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "decryptAES$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_decryptAES(String value) {
        return this.decryptAES(value, this.getSecretPrefix());
    }

    public String decryptAES(String value, String privateKey) {
        String string;
        if (!this.__MdecryptAES$java_lang_String$java_lang_String) {
            return this.__M_decryptAES(value, privateKey);
        }
        try {
            this.__IM.onEntry((Object)this, "decryptAES$java_lang_String$java_lang_String", new Object[]{value, privateKey});
            string = this.__M_decryptAES(value, privateKey);
            this.__IM.onExit((Object)this, "decryptAES$java_lang_String$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "decryptAES$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_decryptAES(String value, String privateKey) {
        try {
            byte[] raw = privateKey.getBytes(UTF_8);
            SecretKeySpec skeySpec = new SecretKeySpec(raw, AES_ECB_ALGORITHM);
            Cipher cipher = Cipher.getInstance(AES_ECB_ALGORITHM);
            cipher.init(2, skeySpec);
            return new String(cipher.doFinal(this.decodeHex(value)), Charsets.UTF_8);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IllegalStateException(e);
        }
    }

    private String getSecretPrefix() {
        String string;
        if (!this.__MgetSecretPrefix) {
            return this.__M_getSecretPrefix();
        }
        try {
            this.__IM.onEntry((Object)this, "getSecretPrefix", new Object[0]);
            string = this.__M_getSecretPrefix();
            this.__IM.onExit((Object)this, "getSecretPrefix", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getSecretPrefix", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getSecretPrefix() {
        return this.__getsecret().substring(0, 16);
    }

    private String getDefaultIV() {
        String string;
        if (!this.__MgetDefaultIV) {
            return this.__M_getDefaultIV();
        }
        try {
            this.__IM.onEntry((Object)this, "getDefaultIV", new Object[0]);
            string = this.__M_getDefaultIV();
            this.__IM.onExit((Object)this, "getDefaultIV", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDefaultIV", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getDefaultIV() {
        return String.valueOf(this.hex(this.__getsecret().substring(16, 32).getBytes(Charsets.UTF_8)));
    }

    public String signToken(String token) {
        String string;
        if (!this.__MsignToken$java_lang_String) {
            return this.__M_signToken(token);
        }
        try {
            this.__IM.onEntry((Object)this, "signToken$java_lang_String", new Object[]{token});
            string = this.__M_signToken(token);
            this.__IM.onExit((Object)this, "signToken$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "signToken$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_signToken(String token) {
        long nonce = System.currentTimeMillis();
        String joined = nonce + "-" + token;
        return this.sign(joined) + "-" + joined;
    }

    public String extractSignedToken(String token) {
        String string;
        if (!this.__MextractSignedToken$java_lang_String) {
            return this.__M_extractSignedToken(token);
        }
        try {
            this.__IM.onEntry((Object)this, "extractSignedToken$java_lang_String", new Object[]{token});
            string = this.__M_extractSignedToken(token);
            this.__IM.onExit((Object)this, "extractSignedToken$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "extractSignedToken$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_extractSignedToken(String token) {
        String[] chunks = token.split("-", 3);
        if (chunks.length != 3) {
            return null;
        }
        String signature = chunks[0];
        String nonce = chunks[1];
        String raw = chunks[2];
        if (this.constantTimeEquals(signature, this.sign(nonce + "-" + raw))) {
            return raw;
        }
        return null;
    }

    public boolean constantTimeEquals(String a, String b) {
        boolean bl;
        if (!this.__MconstantTimeEquals$java_lang_String$java_lang_String) {
            return this.__M_constantTimeEquals(a, b);
        }
        try {
            this.__IM.onEntry((Object)this, "constantTimeEquals$java_lang_String$java_lang_String", new Object[]{a, b});
            bl = this.__M_constantTimeEquals(a, b);
            this.__IM.onExit((Object)this, "constantTimeEquals$java_lang_String$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "constantTimeEquals$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_constantTimeEquals(String a, String b) {
        if (a.length() != b.length()) {
            return false;
        }
        int equal = 0;
        for (int i = 0; i < a.length(); ++i) {
            equal |= a.charAt(i) ^ b.charAt(i);
        }
        return equal == 0;
    }

    public String encodeBase64(byte[] value) {
        String string;
        if (!this.__MencodeBase64$byte__) {
            return this.__M_encodeBase64(value);
        }
        try {
            this.__IM.onEntry((Object)this, "encodeBase64$byte__", new Object[]{value});
            string = this.__M_encodeBase64(value);
            this.__IM.onExit((Object)this, "encodeBase64$byte__", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "encodeBase64$byte__", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_encodeBase64(byte[] value) {
        return new String(Base64.encodeBase64((byte[])value), Charsets.UTF_8);
    }

    public byte[] decodeBase64(String value) {
        byte[] byArray;
        if (!this.__MdecodeBase64$java_lang_String) {
            return this.__M_decodeBase64(value);
        }
        try {
            this.__IM.onEntry((Object)this, "decodeBase64$java_lang_String", new Object[]{value});
            byArray = this.__M_decodeBase64(value);
            this.__IM.onExit((Object)this, "decodeBase64$java_lang_String", (Object)byArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "decodeBase64$java_lang_String", throwable);
            throw throwable;
        }
        return byArray;
    }

    private byte[] __M_decodeBase64(String value) {
        return Base64.decodeBase64((byte[])value.getBytes(UTF_8));
    }

    public String hexMD5(String value) {
        String string;
        if (!this.__MhexMD5$java_lang_String) {
            return this.__M_hexMD5(value);
        }
        try {
            this.__IM.onEntry((Object)this, "hexMD5$java_lang_String", new Object[]{value});
            string = this.__M_hexMD5(value);
            this.__IM.onExit((Object)this, "hexMD5$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "hexMD5$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_hexMD5(String value) {
        return String.valueOf(Hex.encodeHex((byte[])this.md5(value)));
    }

    public String hexSHA1(String value) {
        String string;
        if (!this.__MhexSHA1$java_lang_String) {
            return this.__M_hexSHA1(value);
        }
        try {
            this.__IM.onEntry((Object)this, "hexSHA1$java_lang_String", new Object[]{value});
            string = this.__M_hexSHA1(value);
            this.__IM.onExit((Object)this, "hexSHA1$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "hexSHA1$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_hexSHA1(String value) {
        return String.valueOf(Hex.encodeHex((byte[])this.sha1(value)));
    }

    public String generateToken() {
        String string;
        if (!this.__MgenerateToken) {
            return this.__M_generateToken();
        }
        try {
            this.__IM.onEntry((Object)this, "generateToken", new Object[0]);
            string = this.__M_generateToken();
            this.__IM.onExit((Object)this, "generateToken", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateToken", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_generateToken() {
        byte[] bytes = new byte[12];
        this.__getrandom().nextBytes(bytes);
        return this.hexToString(bytes);
    }

    public String generateSignedToken() {
        String string;
        if (!this.__MgenerateSignedToken) {
            return this.__M_generateSignedToken();
        }
        try {
            this.__IM.onEntry((Object)this, "generateSignedToken", new Object[0]);
            string = this.__M_generateSignedToken();
            this.__IM.onExit((Object)this, "generateSignedToken", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateSignedToken", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_generateSignedToken() {
        return this.signToken(this.generateToken());
    }

    public boolean compareSignedTokens(String tokenA, String tokenB) {
        boolean bl;
        if (!this.__McompareSignedTokens$java_lang_String$java_lang_String) {
            return this.__M_compareSignedTokens(tokenA, tokenB);
        }
        try {
            this.__IM.onEntry((Object)this, "compareSignedTokens$java_lang_String$java_lang_String", new Object[]{tokenA, tokenB});
            bl = this.__M_compareSignedTokens(tokenA, tokenB);
            this.__IM.onExit((Object)this, "compareSignedTokens$java_lang_String$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "compareSignedTokens$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_compareSignedTokens(String tokenA, String tokenB) {
        String a = this.extractSignedToken(tokenA);
        String b = this.extractSignedToken(tokenB);
        return a != null && b != null && this.constantTimeEquals(a, b);
    }

    public byte[] md5(String toHash) {
        byte[] byArray;
        if (!this.__Mmd5$java_lang_String) {
            return this.__M_md5(toHash);
        }
        try {
            this.__IM.onEntry((Object)this, "md5$java_lang_String", new Object[]{toHash});
            byArray = this.__M_md5(toHash);
            this.__IM.onExit((Object)this, "md5$java_lang_String", (Object)byArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "md5$java_lang_String", throwable);
            throw throwable;
        }
        return byArray;
    }

    private byte[] __M_md5(String toHash) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(Hash.MD5.toString());
            messageDigest.reset();
            messageDigest.update(toHash.getBytes(UTF_8));
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] sha1(String toHash) {
        byte[] byArray;
        if (!this.__Msha1$java_lang_String) {
            return this.__M_sha1(toHash);
        }
        try {
            this.__IM.onEntry((Object)this, "sha1$java_lang_String", new Object[]{toHash});
            byArray = this.__M_sha1(toHash);
            this.__IM.onExit((Object)this, "sha1$java_lang_String", (Object)byArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "sha1$java_lang_String", throwable);
            throw throwable;
        }
        return byArray;
    }

    private byte[] __M_sha1(String toHash) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(Hash.SHA1.toString());
            messageDigest.reset();
            messageDigest.update(toHash.getBytes(UTF_8));
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public char[] hex(byte[] bytes) {
        char[] cArray;
        if (!this.__Mhex$byte__) {
            return this.__M_hex(bytes);
        }
        try {
            this.__IM.onEntry((Object)this, "hex$byte__", new Object[]{bytes});
            cArray = this.__M_hex(bytes);
            this.__IM.onExit((Object)this, "hex$byte__", (Object)cArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "hex$byte__", throwable);
            throw throwable;
        }
        return cArray;
    }

    private char[] __M_hex(byte[] bytes) {
        return Hex.encodeHex((byte[])bytes);
    }

    public String hexToString(byte[] bytes) {
        String string;
        if (!this.__MhexToString$byte__) {
            return this.__M_hexToString(bytes);
        }
        try {
            this.__IM.onEntry((Object)this, "hexToString$byte__", new Object[]{bytes});
            string = this.__M_hexToString(bytes);
            this.__IM.onExit((Object)this, "hexToString$byte__", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "hexToString$byte__", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_hexToString(byte[] bytes) {
        return Hex.encodeHexString((byte[])bytes);
    }

    public byte[] decodeHex(String value) {
        byte[] byArray;
        if (!this.__MdecodeHex$java_lang_String) {
            return this.__M_decodeHex(value);
        }
        try {
            this.__IM.onEntry((Object)this, "decodeHex$java_lang_String", new Object[]{value});
            byArray = this.__M_decodeHex(value);
            this.__IM.onExit((Object)this, "decodeHex$java_lang_String", (Object)byArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "decodeHex$java_lang_String", throwable);
            throw throwable;
        }
        return byArray;
    }

    private byte[] __M_decodeHex(String value) {
        try {
            return Hex.decodeHex((char[])value.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("defaultHash")) {
                this.__FdefaultHash = true;
            }
            if (set.contains("iterationCount")) {
                this.__FiterationCount = true;
            }
            if (set.contains("keySize")) {
                this.__FkeySize = true;
            }
            if (set.contains("random")) {
                this.__Frandom = true;
            }
            if (set.contains("secret")) {
                this.__Fsecret = true;
            }
            if (set.contains("transformation")) {
                this.__Ftransformation = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("generateAESKey$java_lang_String$java_lang_String")) {
                this.__MgenerateAESKey$java_lang_String$java_lang_String = true;
            }
            if (set.contains("encryptAESWithCBC$java_lang_String$java_lang_String")) {
                this.__MencryptAESWithCBC$java_lang_String$java_lang_String = true;
            }
            if (set.contains("encryptAESWithCBC$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MencryptAESWithCBC$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("decryptAESWithCBC$java_lang_String$java_lang_String")) {
                this.__MdecryptAESWithCBC$java_lang_String$java_lang_String = true;
            }
            if (set.contains("decryptAESWithCBC$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MdecryptAESWithCBC$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("doFinal$int$javax_crypto_SecretKey$java_lang_String$byte__")) {
                this.__MdoFinal$int$javax_crypto_SecretKey$java_lang_String$byte__ = true;
            }
            if (set.contains("sign$java_lang_String")) {
                this.__Msign$java_lang_String = true;
            }
            if (set.contains("sign$java_lang_String$byte__")) {
                this.__Msign$java_lang_String$byte__ = true;
            }
            if (set.contains("hash$java_lang_String")) {
                this.__Mhash$java_lang_String = true;
            }
            if (set.contains("hash$java_lang_String$org_wisdom_api_crypto_Hash")) {
                this.__Mhash$java_lang_String$org_wisdom_api_crypto_Hash = true;
            }
            if (set.contains("encryptAES$java_lang_String")) {
                this.__MencryptAES$java_lang_String = true;
            }
            if (set.contains("encryptAES$java_lang_String$java_lang_String")) {
                this.__MencryptAES$java_lang_String$java_lang_String = true;
            }
            if (set.contains("decryptAES$java_lang_String")) {
                this.__MdecryptAES$java_lang_String = true;
            }
            if (set.contains("decryptAES$java_lang_String$java_lang_String")) {
                this.__MdecryptAES$java_lang_String$java_lang_String = true;
            }
            if (set.contains("getSecretPrefix")) {
                this.__MgetSecretPrefix = true;
            }
            if (set.contains("getDefaultIV")) {
                this.__MgetDefaultIV = true;
            }
            if (set.contains("signToken$java_lang_String")) {
                this.__MsignToken$java_lang_String = true;
            }
            if (set.contains("extractSignedToken$java_lang_String")) {
                this.__MextractSignedToken$java_lang_String = true;
            }
            if (set.contains("constantTimeEquals$java_lang_String$java_lang_String")) {
                this.__MconstantTimeEquals$java_lang_String$java_lang_String = true;
            }
            if (set.contains("encodeBase64$byte__")) {
                this.__MencodeBase64$byte__ = true;
            }
            if (set.contains("decodeBase64$java_lang_String")) {
                this.__MdecodeBase64$java_lang_String = true;
            }
            if (set.contains("hexMD5$java_lang_String")) {
                this.__MhexMD5$java_lang_String = true;
            }
            if (set.contains("hexSHA1$java_lang_String")) {
                this.__MhexSHA1$java_lang_String = true;
            }
            if (set.contains("generateToken")) {
                this.__MgenerateToken = true;
            }
            if (set.contains("generateSignedToken")) {
                this.__MgenerateSignedToken = true;
            }
            if (set.contains("compareSignedTokens$java_lang_String$java_lang_String")) {
                this.__McompareSignedTokens$java_lang_String$java_lang_String = true;
            }
            if (set.contains("md5$java_lang_String")) {
                this.__Mmd5$java_lang_String = true;
            }
            if (set.contains("sha1$java_lang_String")) {
                this.__Msha1$java_lang_String = true;
            }
            if (set.contains("hex$byte__")) {
                this.__Mhex$byte__ = true;
            }
            if (set.contains("hexToString$byte__")) {
                this.__MhexToString$byte__ = true;
            }
            if (set.contains("decodeHex$java_lang_String")) {
                this.__MdecodeHex$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    public CryptoServiceSingleton(InstanceManager instanceManager) {
        this._setInstanceManager(instanceManager);
    }
}

