/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ascii.memcache;

import com.hazelcast.ascii.TextCommandConstants;
import com.hazelcast.ascii.TextCommandServiceImpl;
import com.hazelcast.ascii.memcache.IncrementCommand;
import com.hazelcast.ascii.memcache.MemcacheCommandProcessor;
import com.hazelcast.ascii.memcache.MemcacheEntry;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.util.ByteUtil;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class IncrementCommandProcessor
extends MemcacheCommandProcessor<IncrementCommand> {
    private final ILogger logger;

    public IncrementCommandProcessor(TextCommandServiceImpl textCommandService) {
        super(textCommandService);
        this.logger = textCommandService.getNode().getLogger(this.getClass().getName());
    }

    @Override
    public void handle(IncrementCommand incrementCommand) {
        String key = null;
        try {
            key = URLDecoder.decode(incrementCommand.getKey(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new HazelcastException(e);
        }
        String mapName = "hz_memcache_default";
        int index = key.indexOf(58);
        if (index != -1) {
            mapName = "hz_memcache_" + key.substring(0, index);
            key = key.substring(index + 1);
        }
        try {
            this.textCommandService.lock(mapName, key);
        }
        catch (Exception e) {
            incrementCommand.setResponse(NOT_FOUND);
            if (incrementCommand.shouldReply()) {
                this.textCommandService.sendResponse(incrementCommand);
            }
            return;
        }
        Object value = this.textCommandService.get(mapName, key);
        MemcacheEntry entry = null;
        if (value != null) {
            if (value instanceof MemcacheEntry) {
                entry = (MemcacheEntry)value;
            } else if (value instanceof byte[]) {
                entry = new MemcacheEntry(incrementCommand.getKey(), (byte[])value, 0);
            } else if (value instanceof String) {
                entry = new MemcacheEntry(incrementCommand.getKey(), StringUtil.stringToBytes((String)value), 0);
            } else {
                try {
                    entry = new MemcacheEntry(incrementCommand.getKey(), this.textCommandService.toByteArray(value), 0);
                }
                catch (Exception e) {
                    throw ExceptionUtil.rethrow(e);
                }
            }
            byte[] value1 = entry.getValue();
            long current = value1 == null || value1.length == 0 ? 0L : (long)IncrementCommandProcessor.byteArrayToLong(value1);
            long result = -1L;
            if (incrementCommand.getType() == TextCommandConstants.TextCommandType.INCREMENT) {
                result = current + (long)incrementCommand.getValue();
                result = 0L > result ? Long.MAX_VALUE : result;
                this.textCommandService.incrementIncHitCount();
            } else if (incrementCommand.getType() == TextCommandConstants.TextCommandType.DECREMENT) {
                result = current - (long)incrementCommand.getValue();
                result = 0L > result ? 0L : result;
                this.textCommandService.incrementDecrHitCount();
            }
            incrementCommand.setResponse(ByteUtil.concatenate(StringUtil.stringToBytes(String.valueOf(result)), RETURN));
            MemcacheEntry newValue = new MemcacheEntry(key, IncrementCommandProcessor.longToByteArray(result), entry.getFlag());
            this.textCommandService.put(mapName, key, newValue);
        } else {
            if (incrementCommand.getType() == TextCommandConstants.TextCommandType.INCREMENT) {
                this.textCommandService.incrementIncMissCount();
            } else {
                this.textCommandService.incrementDecrMissCount();
            }
            incrementCommand.setResponse(NOT_FOUND);
        }
        this.textCommandService.unlock(mapName, key);
        if (incrementCommand.shouldReply()) {
            this.textCommandService.sendResponse(incrementCommand);
        }
    }

    @Override
    public void handleRejection(IncrementCommand incrementCommand) {
        incrementCommand.setResponse(NOT_FOUND);
        if (incrementCommand.shouldReply()) {
            this.textCommandService.sendResponse(incrementCommand);
        }
    }
}

