/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.txn.BaseTransactionRequest;
import com.hazelcast.client.txn.ClientTxnPortableHook;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.TransactionPermission;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.TransactionAccessor;
import java.io.IOException;
import java.security.Permission;

public class CommitTransactionRequest
extends BaseTransactionRequest {
    private boolean prepareAndCommit;

    public CommitTransactionRequest() {
    }

    public CommitTransactionRequest(boolean prepareAndCommit) {
        this.prepareAndCommit = prepareAndCommit;
    }

    @Override
    public Object innerCall() throws Exception {
        ClientEndpoint endpoint = this.getEndpoint();
        TransactionContext transactionContext = endpoint.getTransactionContext(this.txnId);
        if (this.prepareAndCommit) {
            transactionContext.commitTransaction();
        } else {
            Transaction transaction = TransactionAccessor.getTransaction(transactionContext);
            transaction.commit();
        }
        endpoint.removeTransactionContext(this.txnId);
        return null;
    }

    @Override
    public String getServiceName() {
        return "hz:core:clientEngine";
    }

    @Override
    public int getFactoryId() {
        return ClientTxnPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeBoolean("pc", this.prepareAndCommit);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.prepareAndCommit = reader.readBoolean("pc");
    }

    @Override
    public Permission getRequiredPermission() {
        return new TransactionPermission();
    }
}

