/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.client;

import com.hazelcast.collection.CollectionContainsOperation;
import com.hazelcast.collection.client.CollectionRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class CollectionContainsRequest
extends CollectionRequest {
    private Set<Data> valueSet;

    public CollectionContainsRequest() {
    }

    public CollectionContainsRequest(String name, Set<Data> valueSet) {
        super(name);
        this.valueSet = valueSet;
    }

    public CollectionContainsRequest(String name, Data value) {
        super(name);
        this.valueSet = new HashSet<Data>(1);
        this.valueSet.add(value);
    }

    @Override
    protected Operation prepareOperation() {
        return new CollectionContainsOperation(this.name, this.valueSet);
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeInt(this.valueSet.size());
        for (Data value : this.valueSet) {
            value.writeData(out);
        }
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        int size = in.readInt();
        this.valueSet = new HashSet<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data value = new Data();
            value.readData(in);
            this.valueSet.add(value);
        }
    }

    @Override
    public String getRequiredAction() {
        return "read";
    }
}

