/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management.request;

import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.management.ManagementCenterService;
import com.hazelcast.management.request.ConsoleRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;

public class VersionMismatchLogRequest
implements ConsoleRequest {
    private String manCenterVersion;

    public VersionMismatchLogRequest() {
    }

    public VersionMismatchLogRequest(String manCenterVersion) {
        this.manCenterVersion = manCenterVersion;
    }

    @Override
    public int getType() {
        return 17;
    }

    @Override
    public Object readResponse(ObjectDataInput in) throws IOException {
        return "SUCCESS";
    }

    @Override
    public void writeResponse(ManagementCenterService managementCenterService, ObjectDataOutput dos) throws Exception {
        managementCenterService.signalVersionMismatch();
        Node node = managementCenterService.getHazelcastInstance().node;
        ILogger logger = node.getLogger(VersionMismatchLogRequest.class);
        logger.severe("The version of the management center is " + this.manCenterVersion);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.manCenterVersion);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.manCenterVersion = in.readUTF();
    }
}

