/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapService;
import com.hazelcast.map.PartitionContainer;
import com.hazelcast.map.RecordStore;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;

public abstract class KeyBasedMapOperation
extends Operation
implements PartitionAwareOperation {
    protected String name;
    protected Data dataKey;
    protected long threadId;
    protected Data dataValue = null;
    protected long ttl = -1L;
    protected transient MapService mapService;
    protected transient MapContainer mapContainer;
    protected transient PartitionContainer partitionContainer;
    protected transient RecordStore recordStore;

    public KeyBasedMapOperation() {
    }

    public KeyBasedMapOperation(String name, Data dataKey) {
        this.dataKey = dataKey;
        this.name = name;
    }

    protected KeyBasedMapOperation(String name, Data dataKey, Data dataValue) {
        this.name = name;
        this.dataKey = dataKey;
        this.dataValue = dataValue;
    }

    protected KeyBasedMapOperation(String name, Data dataKey, long ttl) {
        this.name = name;
        this.dataKey = dataKey;
        this.ttl = ttl;
    }

    protected KeyBasedMapOperation(String name, Data dataKey, Data dataValue, long ttl) {
        this.name = name;
        this.dataKey = dataKey;
        this.dataValue = dataValue;
        this.ttl = ttl;
    }

    public final String getName() {
        return this.name;
    }

    public final Data getKey() {
        return this.dataKey;
    }

    public final long getThreadId() {
        return this.threadId;
    }

    public final void setThreadId(long threadId) {
        this.threadId = threadId;
    }

    public final Data getValue() {
        return this.dataValue;
    }

    public final long getTtl() {
        return this.ttl;
    }

    @Override
    public final void beforeRun() throws Exception {
        this.mapService = (MapService)this.getService();
        this.mapContainer = this.mapService.getMapContainer(this.name);
        this.partitionContainer = this.mapService.getPartitionContainer(this.getPartitionId());
        this.recordStore = this.partitionContainer.getRecordStore(this.name);
        this.innerBeforeRun();
    }

    public void innerBeforeRun() {
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    protected final void invalidateNearCaches() {
        if (this.mapContainer.isNearCacheEnabled() && this.mapContainer.getMapConfig().getNearCacheConfig().isInvalidateOnChange()) {
            this.mapService.invalidateAllNearCaches(this.name, this.dataKey);
        }
    }

    protected void invalidateLocalNearCache(Data dataKey) {
        if (this.mapService.isNearCacheAndInvalidationEnabled(this.name)) {
            this.mapService.invalidateNearCache(this.name, dataKey);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        this.dataKey.writeData(out);
        out.writeLong(this.threadId);
        IOUtil.writeNullableData(out, this.dataValue);
        out.writeLong(this.ttl);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.dataKey = new Data();
        this.dataKey.readData(in);
        this.threadId = in.readLong();
        this.dataValue = IOUtil.readNullableData(in);
        this.ttl = in.readLong();
    }
}

