/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mapreduce.impl.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.InvocationClientRequest;
import com.hazelcast.mapreduce.impl.MapReducePortableHook;
import com.hazelcast.mapreduce.impl.MapReduceService;
import com.hazelcast.mapreduce.impl.task.JobSupervisor;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import java.io.IOException;
import java.security.Permission;
import java.util.concurrent.CancellationException;

public class ClientCancellationRequest
extends InvocationClientRequest {
    private String name;
    private String jobId;

    public ClientCancellationRequest() {
    }

    public ClientCancellationRequest(String name, String jobId) {
        this.name = name;
        this.jobId = jobId;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapReduceService";
    }

    @Override
    protected void invoke() {
        ClientEndpoint endpoint = this.getEndpoint();
        MapReduceService mapReduceService = (MapReduceService)this.getService();
        Address jobOwner = mapReduceService.getLocalAddress();
        mapReduceService.registerJobSupervisorCancellation(this.name, this.jobId, jobOwner);
        JobSupervisor supervisor = mapReduceService.getJobSupervisor(this.name, this.jobId);
        if (supervisor != null && supervisor.isOwnerNode()) {
            CancellationException exception = new CancellationException("Operation was cancelled by the user");
            supervisor.cancelAndNotify(exception);
        }
        endpoint.sendResponse(Boolean.TRUE, this.getCallId());
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeUTF("name", this.name);
        writer.writeUTF("jobId", this.jobId);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.name = reader.readUTF("name");
        this.jobId = reader.readUTF("jobId");
    }

    @Override
    public int getFactoryId() {
        return MapReducePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

