/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.operations;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.multimap.MultiMapContainer;
import com.hazelcast.multimap.MultiMapRecord;
import com.hazelcast.multimap.MultiMapService;
import com.hazelcast.multimap.operations.ClearBackupOperation;
import com.hazelcast.multimap.operations.MultiMapOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.util.Collection;
import java.util.Map;

public class ClearOperation
extends MultiMapOperation
implements BackupAwareOperation,
PartitionAwareOperation {
    Map<Data, Collection<MultiMapRecord>> objects;

    public ClearOperation() {
    }

    public ClearOperation(String name) {
        super(name);
    }

    @Override
    public void beforeRun() throws Exception {
        if (this.hasListener()) {
            MultiMapContainer container = this.getOrCreateContainer();
            this.objects = container.copyCollections();
        }
    }

    @Override
    public void run() throws Exception {
        MultiMapContainer container = this.getOrCreateContainer();
        container.clear();
        this.response = true;
    }

    @Override
    public void afterRun() throws Exception {
        ((MultiMapService)this.getService()).getLocalMultiMapStatsImpl(this.name).incrementOtherOperations();
        if (this.objects != null && !this.objects.isEmpty()) {
            MultiMapContainer container = this.getOrCreateContainer();
            for (Map.Entry<Data, Collection<MultiMapRecord>> entry : this.objects.entrySet()) {
                Data key = entry.getKey();
                if (container.isLocked(key)) continue;
                Collection<MultiMapRecord> coll = entry.getValue();
                for (MultiMapRecord record : coll) {
                    this.publishEvent(EntryEventType.REMOVED, key, record.getObject());
                }
            }
            this.objects.clear();
        }
        this.objects = null;
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.objects != null && !this.objects.isEmpty());
    }

    @Override
    public Operation getBackupOperation() {
        return new ClearBackupOperation(this.name);
    }

    @Override
    public int getId() {
        return 3;
    }
}

