/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue;

import com.hazelcast.core.ItemEventType;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.queue.AddAllBackupOperation;
import com.hazelcast.queue.QueueBackupAwareOperation;
import com.hazelcast.queue.QueueContainer;
import com.hazelcast.spi.Notifier;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.WaitNotifyKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class AddAllOperation
extends QueueBackupAwareOperation
implements Notifier {
    private Collection<Data> dataList;
    private Map<Long, Data> dataMap;

    public AddAllOperation() {
    }

    public AddAllOperation(String name, Collection<Data> dataList) {
        super(name);
        this.dataList = dataList;
    }

    @Override
    public void run() {
        QueueContainer container = this.getOrCreateContainer();
        if (container.hasEnoughCapacity()) {
            this.dataMap = container.addAll(this.dataList);
            this.response = true;
        } else {
            this.response = false;
        }
    }

    @Override
    public void afterRun() throws Exception {
        this.getQueueService().getLocalQueueStatsImpl(this.name).incrementOtherOperations();
        if (Boolean.TRUE.equals(this.response)) {
            for (Data data : this.dataList) {
                this.publishEvent(ItemEventType.ADDED, data);
            }
        }
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public Operation getBackupOperation() {
        return new AddAllBackupOperation(this.name, this.dataMap);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.dataList.size());
        for (Data data : this.dataList) {
            data.writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.dataList = new ArrayList<Data>(size);
        for (int i = 0; i < size; ++i) {
            this.dataList.add(IOUtil.readData(in));
        }
    }

    @Override
    public boolean shouldNotify() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return this.getOrCreateContainer().getPollWaitNotifyKey();
    }

    @Override
    public int getId() {
        return 6;
    }
}

