/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.nio.Address;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class UuidUtil {
    private static final ThreadLocal<Random> RANDOMIZERS = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random(UuidUtil.seedUniquifier() ^ System.nanoTime());
        }
    };
    private static final AtomicLong SEED_UNIQUIFIER = new AtomicLong(8682522807148012L);

    private static long seedUniquifier() {
        long next;
        long current;
        while (!SEED_UNIQUIFIER.compareAndSet(current = SEED_UNIQUIFIER.get(), next = current * 181783497276652981L)) {
        }
        return next;
    }

    public static String createMemberUuid(Address endpoint) {
        return UuidUtil.buildRandomUUID().toString();
    }

    public static String createClientUuid(Address endpoint) {
        return UuidUtil.buildRandomUUID().toString();
    }

    public static String buildRandomUuidString() {
        return UuidUtil.buildRandomUUID().toString();
    }

    public static UUID buildRandomUUID() {
        int i;
        byte[] data = new byte[16];
        RANDOMIZERS.get().nextBytes(data);
        data[6] = (byte)(data[6] & 0xF);
        data[6] = (byte)(data[6] | 0x40);
        data[8] = (byte)(data[8] & 0x3F);
        data[8] = (byte)(data[8] | 0x80);
        long mostSigBits = 0L;
        long leastSigBits = 0L;
        assert (data.length == 16) : "data must be 16 bytes in length";
        for (i = 0; i < 8; ++i) {
            mostSigBits = mostSigBits << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            leastSigBits = leastSigBits << 8 | (long)(data[i] & 0xFF);
        }
        return new UUID(mostSigBits, leastSigBits);
    }

    private UuidUtil() {
    }
}

