/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

public class ValidationUtil {
    public static String hasText(String argument, String argName) {
        ValidationUtil.isNotNull(argument, argName);
        if (argument.isEmpty()) {
            throw new IllegalArgumentException(String.format("argument '%s' can't be an empty string", argName));
        }
        return argument;
    }

    public static <E> E isNotNull(E argument, String argName) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("argument '%s' can't be null", argName));
        }
        return argument;
    }

    private ValidationUtil() {
    }

    public static void isNotNegative(int permits, String argumentName) {
        if (permits < 0) {
            throw new IllegalArgumentException(argumentName + " cannot be negative!");
        }
    }

    public static void shouldBePositive(long value, String argumentName) {
        if (value <= 0L) {
            throw new IllegalArgumentException(argumentName + " should be positive!");
        }
    }
}

