/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.spi.cluster.impl.hazelcast;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.vertx.java.core.impl.ConcurrentHashSet;
import org.vertx.java.core.spi.cluster.ChoosableIterable;

class ChoosableSet<T>
implements ChoosableIterable<T> {
    private volatile boolean initialised;
    private final Set<T> ids;
    private volatile Iterator<T> iter;

    public ChoosableSet(int initialSize) {
        this.ids = new ConcurrentHashSet<T>(initialSize);
    }

    public int size() {
        return this.ids.size();
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    public void setInitialised() {
        this.initialised = true;
    }

    public void add(T elem) {
        this.ids.add(elem);
    }

    public void remove(T elem) {
        this.ids.remove(elem);
    }

    public void merge(ChoosableSet<T> toMerge) {
        this.ids.addAll(toMerge.ids);
    }

    @Override
    public boolean isEmpty() {
        return this.ids.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.ids.iterator();
    }

    @Override
    public synchronized T choose() {
        if (!this.ids.isEmpty()) {
            if (this.iter == null || !this.iter.hasNext()) {
                this.iter = this.ids.iterator();
            }
            try {
                return this.iter.next();
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
        return null;
    }
}

