/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.spi.cluster.impl.hazelcast;

import com.hazelcast.core.IMap;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.spi.Action;
import org.vertx.java.core.spi.VertxSPI;
import org.vertx.java.core.spi.cluster.AsyncMap;
import org.vertx.java.spi.cluster.impl.hazelcast.HazelcastServerID;

class HazelcastAsyncMap<K, V>
implements AsyncMap<K, V> {
    private final VertxSPI vertx;
    private final IMap<K, V> map;

    public HazelcastAsyncMap(VertxSPI vertx, IMap<K, V> map) {
        this.vertx = vertx;
        this.map = map;
    }

    @Override
    public void get(final K k, Handler<AsyncResult<V>> asyncResultHandler) {
        this.vertx.executeBlocking(new Action<V>(){

            @Override
            public V perform() {
                return HazelcastAsyncMap.this.map.get(k);
            }
        }, asyncResultHandler);
    }

    @Override
    public void put(final K k, final V v, Handler<AsyncResult<Void>> completionHandler) {
        this.vertx.executeBlocking(new Action<Void>(){

            @Override
            public Void perform() {
                HazelcastAsyncMap.this.map.put(k, HazelcastServerID.convertServerID(v));
                return null;
            }
        }, completionHandler);
    }

    @Override
    public void remove(final K k, Handler<AsyncResult<Void>> completionHandler) {
        this.vertx.executeBlocking(new Action<Void>(){

            @Override
            public Void perform() {
                HazelcastAsyncMap.this.map.remove(k);
                return null;
            }
        }, completionHandler);
    }
}

