/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class BuildConstants {
    public static String CONSTANTS_PATH = "META-INF/constants.properties";
    public static String WISDOM_VERSION_KEY = "wisdom.version";
    public static String VERTX_VERSION_KEY = "vertx.version";
    private static volatile Properties properties;
    public static final String WISDOM_VERSION;
    public static final String VERTX_VERSION;

    private static void load() {
        properties = new Properties();
        InputStream is = BuildConstants.class.getClassLoader().getResourceAsStream(CONSTANTS_PATH);
        try {
            properties.load(is);
            is.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load the 'constants' file");
        }
    }

    public static String get(String key) {
        return properties.getProperty(key);
    }

    static {
        BuildConstants.load();
        WISDOM_VERSION = BuildConstants.get(WISDOM_VERSION_KEY);
        VERTX_VERSION = BuildConstants.get(VERTX_VERSION_KEY);
    }
}

