/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.vertx.java.core.Context;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.http.HttpServerRequest;
import org.wisdom.api.content.BodyParser;
import org.wisdom.api.cookies.Cookie;
import org.wisdom.api.cookies.Cookies;
import org.wisdom.api.cookies.FlashCookie;
import org.wisdom.api.cookies.SessionCookie;
import org.wisdom.api.http.FileItem;
import org.wisdom.api.http.Request;
import org.wisdom.api.router.Route;
import org.wisdom.framework.vertx.HttpUtils;
import org.wisdom.framework.vertx.RequestFromVertx;
import org.wisdom.framework.vertx.ServiceAccessor;
import org.wisdom.framework.vertx.cookies.CookieHelper;
import org.wisdom.framework.vertx.cookies.FlashCookieImpl;
import org.wisdom.framework.vertx.cookies.SessionCookieImpl;
import org.wisdom.framework.vertx.file.VertxFileUpload;

public class ContextFromVertx
implements org.wisdom.api.http.Context {
    private static AtomicLong ids = new AtomicLong();
    private final long id = ids.getAndIncrement();
    private final ServiceAccessor services;
    private final FlashCookieImpl flash;
    private final SessionCookieImpl session;
    private final Vertx vertx;
    private Route route;
    private RequestFromVertx request;
    private Context vertxContext;

    public ContextFromVertx(Vertx vertx, ServiceAccessor accessor, HttpServerRequest req) {
        this.services = accessor;
        this.request = new RequestFromVertx(this, req, accessor.getConfiguration());
        this.vertx = vertx;
        this.flash = new FlashCookieImpl(accessor.getConfiguration());
        this.session = new SessionCookieImpl(accessor.getCrypto(), accessor.getConfiguration());
        this.flash.init(this);
        this.session.init(this);
    }

    public Long id() {
        return this.id;
    }

    public Request request() {
        return this.request;
    }

    public String path() {
        return this.request().path();
    }

    public FlashCookie flash() {
        return this.flash;
    }

    public SessionCookie session() {
        return this.session;
    }

    public Cookie cookie(String cookieName) {
        return this.request().cookie(cookieName);
    }

    public boolean hasCookie(String cookieName) {
        return this.request().cookie(cookieName) != null;
    }

    public Cookies cookies() {
        return this.request().cookies();
    }

    public String contextPath() {
        return "";
    }

    public String parameter(String name) {
        return this.request.parameter(name);
    }

    public Map<String, List<String>> attributes() {
        return this.form();
    }

    public Map<String, List<String>> form() {
        return this.request.getFormData();
    }

    public List<String> parameterMultipleValues(String name) {
        return this.request.parameterMultipleValues(name);
    }

    public String parameter(String name, String defaultValue) {
        return this.request.parameter(name, defaultValue);
    }

    public Integer parameterAsInteger(String name) {
        return this.request.parameterAsInteger(name);
    }

    public Integer parameterAsInteger(String name, Integer defaultValue) {
        return this.request.parameterAsInteger(name, defaultValue);
    }

    public Boolean parameterAsBoolean(String name) {
        return this.request.parameterAsBoolean(name);
    }

    public Boolean parameterAsBoolean(String name, boolean defaultValue) {
        return this.request.parameterAsBoolean(name, defaultValue);
    }

    public String parameterFromPath(String name) {
        String encodedParameter = (String)this.route.getPathParametersEncoded(this.path()).get(name);
        if (encodedParameter == null) {
            return null;
        }
        return URI.create(encodedParameter).getPath();
    }

    public String parameterFromPathEncoded(String name) {
        return (String)this.route.getPathParametersEncoded(this.path()).get(name);
    }

    public Integer parameterFromPathAsInteger(String key) {
        String parameter = this.parameterFromPath(key);
        if (parameter == null) {
            return null;
        }
        return Integer.parseInt(parameter);
    }

    public Map<String, List<String>> parameters() {
        return this.request.parameters();
    }

    public String header(String name) {
        List<String> list = this.request.headers().get(name);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public List<String> headers(String name) {
        return this.request.headers().get(name);
    }

    public Map<String, List<String>> headers() {
        return this.request.headers();
    }

    public String cookieValue(String name) {
        return CookieHelper.getCookieValue(name, this.request().cookies());
    }

    public <T> T body(Class<T> classOfT) {
        return this.body(classOfT, null);
    }

    public <T> T body(Class<T> classOfT, Type genericType) {
        String rawContentType = this.request().contentType();
        if (rawContentType == null) {
            return null;
        }
        String contentTypeOnly = HttpUtils.getContentTypeFromContentTypeAndCharacterSetting(rawContentType);
        BodyParser parser = this.services.getContentEngines().getBodyParserEngineForContentType(contentTypeOnly);
        if (parser == null) {
            return null;
        }
        return (T)parser.invoke((org.wisdom.api.http.Context)this, classOfT, genericType);
    }

    public String body() {
        return this.request.getRawBodyAsString();
    }

    public byte[] raw() {
        return this.request.getRawBody();
    }

    public BufferedReader reader() throws IOException {
        byte[] raw = this.request.getRawBody();
        if (raw != null) {
            return IOUtils.toBufferedReader((Reader)new InputStreamReader(new ByteArrayInputStream(raw)));
        }
        return null;
    }

    public Route route() {
        return this.route;
    }

    public void route(Route route) {
        Preconditions.checkState((this.route == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)route);
        this.route = route;
    }

    public boolean isMultipart() {
        return "multipart/form-data".equals(this.request.getHeader("Content-Type"));
    }

    public Collection<? extends FileItem> files() {
        return this.request.getFiles();
    }

    public FileItem file(String name) {
        for (FileItem fileItem : this.request.getFiles()) {
            if (!fileItem.field().equals(name) || Strings.isNullOrEmpty((String)fileItem.name())) continue;
            return fileItem;
        }
        return null;
    }

    public void cleanup() {
        for (VertxFileUpload item : this.request.getFiles()) {
            item.cleanup();
        }
    }

    public boolean ready() {
        this.vertxContext = this.vertx.currentContext();
        return this.request.ready();
    }

    public Vertx vertx() {
        return this.vertx;
    }

    public Context vertxContext() {
        return this.vertxContext;
    }

    public String toString() {
        return "context-" + this.id + " / " + this.vertxContext;
    }
}

