/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.sockjs.SockJSServer;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.configuration.Configuration;
import org.wisdom.api.http.Result;
import org.wisdom.api.http.Results;
import org.wisdom.framework.vertx.HttpHandler;
import org.wisdom.framework.vertx.ServiceAccessor;
import org.wisdom.framework.vertx.SockJsHandler;
import org.wisdom.framework.vertx.WebSocketHandler;
import org.wisdom.framework.vertx.ssl.SSLServerContext;

public class Server {
    private static volatile Random random = new Random();
    private final String name;
    private final String host;
    private final Logger logger;
    private final Vertx vertx;
    private final ServiceAccessor accessor;
    private final ApplicationConfiguration configuration;
    private int port;
    private final boolean ssl;
    private final boolean authentication;
    private List<Pattern> allow;
    private List<Pattern> deny;
    private String onDenied;
    private HttpServer http;
    private List<SockJSServer> sockjs = new ArrayList<SockJSServer>();
    private long encodingMinBound;
    private long encodingMaxBound;

    public static Server defaultHttp(ServiceAccessor accessor, Vertx vertx) {
        return new Server(accessor, vertx, "default-http", accessor.getConfiguration().getIntegerWithDefault("http.port", Integer.valueOf(9000)), false, false, null, Collections.emptyList(), Collections.emptyList(), null);
    }

    public static Server defaultHttps(ServiceAccessor accessor, Vertx vertx) {
        return new Server(accessor, vertx, "default-https", accessor.getConfiguration().getIntegerWithDefault("https.port", Integer.valueOf(9001)), true, false, null, Collections.emptyList(), Collections.emptyList(), null);
    }

    public static Server from(ServiceAccessor accessor, Vertx vertx, String name, Configuration configuration) {
        return new Server(accessor, vertx, name, configuration.getIntegerOrDie("port"), configuration.getBooleanWithDefault("ssl", Boolean.valueOf(false)), configuration.getBooleanWithDefault("authentication", Boolean.valueOf(false)), configuration.get("host"), configuration.getList("allow"), configuration.getList("deny"), configuration.get("onDenied"));
    }

    public Server(ServiceAccessor accessor, Vertx vertx, String name, int port, boolean ssl, boolean authentication, String host, List<String> allow, List<String> deny, String onDenied) {
        Preconditions.checkNotNull((Object)accessor);
        Preconditions.checkNotNull((Object)vertx);
        Preconditions.checkNotNull((Object)name);
        this.accessor = accessor;
        this.configuration = accessor.getConfiguration();
        this.vertx = vertx;
        this.name = name;
        this.host = host == null ? "0.0.0.0" : host;
        this.port = port;
        this.ssl = ssl;
        this.authentication = authentication;
        ArrayList<Pattern> allowedPatterns = new ArrayList<Pattern>();
        ArrayList<Pattern> deniedPatterns = new ArrayList<Pattern>();
        for (String a : allow) {
            allowedPatterns.add(Pattern.compile(a.trim().replace(".", "\\.").replace("*", ".*")));
        }
        for (String a : deny) {
            deniedPatterns.add(Pattern.compile(a.trim().replace(".", "\\.").replace("*", ".*")));
        }
        this.allow = allowedPatterns;
        this.deny = deniedPatterns;
        this.onDenied = onDenied;
        this.logger = LoggerFactory.getLogger((String)("server-" + name));
    }

    public void bind() {
        this.logger.info("Starting server {}", (Object)this.name);
        this.bind(this.port);
    }

    private void bind(int p) {
        final int thePort = this.pickAPort(this.port);
        this.http = this.vertx.createHttpServer().requestHandler(new HttpHandler(this.vertx, this.accessor, this)).websocketHandler(new WebSocketHandler(this.accessor, this));
        if (this.ssl) {
            ((HttpServer)this.http.setSSL(true)).setSSLContext(SSLServerContext.getInstance(this.accessor).serverContext());
            if (this.authentication) {
                this.http.setClientAuthRequired(true);
            }
        }
        for (String prefix : this.configuration.getList("vertx.sockjs.prefixes")) {
            this.configureSockJsServer(prefix, this.vertx.createSockJSServer(this.http));
        }
        if (this.hasCompressionEnabled()) {
            this.http.setCompressionSupported(true);
        }
        if (this.configuration.getIntegerWithDefault("vertx.acceptBacklog", Integer.valueOf(-1)) != -1) {
            this.http.setAcceptBacklog(this.configuration.getInteger("vertx.acceptBacklog"));
        }
        if (this.configuration.getIntegerWithDefault("vertx.maxWebSocketFrameSize", Integer.valueOf(-1)) != -1) {
            this.http.setMaxWebSocketFrameSize(this.configuration.getInteger("vertx.maxWebSocketFrameSize"));
        }
        if (this.configuration.getStringArray("wisdom.websocket.subprotocols").length > 0) {
            this.http.setWebSocketSubProtocols(this.configuration.getStringArray("wisdom.websocket.subprotocols"));
        }
        if (this.configuration.getStringArray("vertx.websocket-subprotocols").length > 0) {
            this.http.setWebSocketSubProtocols(this.configuration.getStringArray("vertx.websocket-subprotocols"));
        }
        if (this.configuration.getIntegerWithDefault("vertx.receiveBufferSize", Integer.valueOf(-1)) != -1) {
            this.http.setReceiveBufferSize(this.configuration.getInteger("vertx.receiveBufferSize"));
        }
        if (this.configuration.getIntegerWithDefault("vertx.sendBufferSize", Integer.valueOf(-1)) != -1) {
            this.http.setSendBufferSize(this.configuration.getInteger("vertx.sendBufferSize"));
        }
        this.http.listen(thePort, this.host, new Handler<AsyncResult<HttpServer>>(){

            @Override
            public void handle(AsyncResult<HttpServer> event) {
                if (event.succeeded()) {
                    Server.this.logger.info("Wisdom is going to serve HTTP requests on port {}.", (Object)thePort);
                    Server.this.port = thePort;
                } else if (Server.this.port == 0) {
                    Server.this.logger.debug("Cannot bind on port {} (port already used probably)", (Object)thePort, (Object)event.cause());
                    Server.this.bind(0);
                } else {
                    Server.this.logger.error("Cannot bind on port {} (port already used probably)", (Object)thePort, (Object)event.cause());
                }
            }
        });
    }

    private void configureSockJsServer(String prefix, SockJSServer sockJSServer) {
        JsonObject config = new JsonObject().putString("prefix", prefix).putNumber("session_timeout", this.configuration.getDuration("vertx.sockjs.timeout", TimeUnit.MILLISECONDS, 5000L)).putNumber("heartbeat_period", this.configuration.getDuration("vertx.sockjs.heartbeat", TimeUnit.MILLISECONDS, 5000L)).putNumber("max_bytes_streaming", this.configuration.getBytes("vertx.sockjs.max", 131072L)).putString("library_url", this.configuration.getWithDefault("vertx.sockjs.library", "http://cdn.jsdelivr.net/sockjs/0.3.4/sockjs.min.js"));
        sockJSServer.installApp(config, new SockJsHandler(this.accessor, prefix));
        this.sockjs.add(sockJSServer);
    }

    public boolean accept(String path) {
        if (this.allow.isEmpty() && this.deny.isEmpty()) {
            return true;
        }
        for (Pattern p : this.deny) {
            if (!p.matcher(path).matches()) continue;
            return false;
        }
        for (Pattern p : this.allow) {
            if (!p.matcher(path).matches()) continue;
            return true;
        }
        return !this.deny.isEmpty();
    }

    public Result getOnDeniedResult() {
        if (this.onDenied == null) {
            return Results.forbidden();
        }
        return Results.redirect((String)this.onDenied);
    }

    private int pickAPort(int port) {
        if (port == 0) {
            port = 9000 + random.nextInt(10000);
            this.logger.debug("Random port lookup - Trying with {}", (Object)port);
        }
        return port;
    }

    public String name() {
        return this.name;
    }

    public void close() {
        for (SockJSServer server : this.sockjs) {
            server.close();
        }
        this.http.close((Handler<AsyncResult<Void>>)new AsyncResultHandler<Void>(){

            @Override
            public void handle(AsyncResult<Void> event) {
                Server.this.logger.info("The server '{}' has been stopped (bound port: {})", (Object)Server.this.name, (Object)Server.this.port);
            }
        });
    }

    public boolean ssl() {
        return this.ssl;
    }

    public int port() {
        return this.port;
    }

    public String host() {
        return this.host;
    }

    public boolean hasCompressionEnabled() {
        return this.configuration.getBooleanWithDefault("vertx.compression", Boolean.valueOf(true));
    }

    public long getEncodingMinBound() {
        return this.configuration.getBytes("encoding.min", 1024L);
    }

    public long getEncodingMaxBound() {
        return this.configuration.getBytes("encoding.max", 10240000L);
    }
}

