/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx;

import java.util.Collection;
import org.wisdom.api.concurrent.ManagedExecutorService;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.content.ContentEngine;
import org.wisdom.api.crypto.Crypto;
import org.wisdom.api.exceptions.ExceptionMapper;
import org.wisdom.api.router.Router;
import org.wisdom.framework.vertx.WisdomVertxServer;

public class ServiceAccessor {
    private final Crypto crypto;
    private final ApplicationConfiguration configuration;
    private final Router router;
    private final ContentEngine contentEngines;
    private final ManagedExecutorService executor;
    private final WisdomVertxServer dispatcher;
    private final Collection<ExceptionMapper> mappers;

    public ServiceAccessor(Crypto crypto, ApplicationConfiguration configuration, Router router, ContentEngine engine, ManagedExecutorService executor, WisdomVertxServer dispatcher, Collection<ExceptionMapper> mappers) {
        this.crypto = crypto;
        this.configuration = configuration;
        this.router = router;
        this.contentEngines = engine;
        this.executor = executor;
        this.dispatcher = dispatcher;
        this.mappers = mappers;
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    public ApplicationConfiguration getConfiguration() {
        return this.configuration;
    }

    public Router getRouter() {
        return this.router;
    }

    public ContentEngine getContentEngines() {
        return this.contentEngines;
    }

    public ManagedExecutorService getExecutor() {
        return this.executor;
    }

    public WisdomVertxServer getDispatcher() {
        return this.dispatcher;
    }

    public ExceptionMapper getExceptionMapper(Exception t) {
        for (ExceptionMapper mapper : this.mappers) {
            if (!mapper.getExceptionClass().getName().equals(t.getClass().getName())) continue;
            return mapper;
        }
        return null;
    }
}

