/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Vertx;
import org.wisdom.api.concurrent.ManagedExecutorService;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.configuration.Configuration;
import org.wisdom.api.content.ContentEngine;
import org.wisdom.api.crypto.Crypto;
import org.wisdom.api.engine.WisdomEngine;
import org.wisdom.api.exceptions.ExceptionMapper;
import org.wisdom.api.http.websockets.WebSocketDispatcher;
import org.wisdom.api.http.websockets.WebSocketListener;
import org.wisdom.api.router.Router;
import org.wisdom.framework.vertx.Server;
import org.wisdom.framework.vertx.ServiceAccessor;
import org.wisdom.framework.vertx.Socket;

@Component
@Provides
@Instantiate
public class WisdomVertxServer
implements WebSocketDispatcher,
WisdomEngine,
Pojo {
    InstanceManager __IM;
    private static final Logger LOGGER = LoggerFactory.getLogger(WisdomVertxServer.class);
    private boolean __Flisteners;
    private List<WebSocketListener> listeners;
    private boolean __FsocketsByUri;
    private Map<String, List<Socket>> socketsByUri;
    private boolean __Fvertx;
    @Requires
    Vertx vertx;
    private boolean __Frouter;
    @Requires
    private Router router;
    private boolean __Fconfiguration;
    @Requires
    ApplicationConfiguration configuration;
    private boolean __Fcrypto;
    @Requires
    private Crypto crypto;
    private boolean __Fengine;
    @Requires
    private ContentEngine engine;
    private boolean __Fexecutor;
    @Requires(filter="(name=wisdom-system-executor)")
    private ManagedExecutorService executor;
    private boolean __Fmappers;
    @Requires(specification=ExceptionMapper.class, optional=true)
    private Collection<ExceptionMapper> mappers;
    private boolean __Faccessor;
    ServiceAccessor accessor;
    private boolean __Faddress;
    private InetAddress address;
    private boolean __Fservers;
    protected List<Server> servers;
    boolean __Mstart;
    boolean __MinitializeInetAddress;
    boolean __MonError;
    boolean __Mstop;
    boolean __Mhostname;
    boolean __MhttpPort;
    boolean __MhttpsPort;
    boolean __Mpublish$java_lang_String$java_lang_String;
    boolean __Mpublish$java_lang_String$byte__;
    boolean __MaddSocket$java_lang_String$org_wisdom_framework_vertx_Socket;
    boolean __MremoveSocket$java_lang_String$org_wisdom_framework_vertx_Socket;
    boolean __Mregister$org_wisdom_api_http_websockets_WebSocketListener;
    boolean __Munregister$org_wisdom_api_http_websockets_WebSocketListener;
    boolean __Msend$java_lang_String$java_lang_String$java_lang_String;
    boolean __Msend$java_lang_String$java_lang_String$byte__;
    boolean __Mreceived$java_lang_String$byte__$org_wisdom_framework_vertx_Socket;

    List __getlisteners() {
        if (!this.__Flisteners) {
            return this.listeners;
        }
        return (List)this.__IM.onGet((Object)this, "listeners");
    }

    void __setlisteners(List list) {
        if (!this.__Flisteners) {
            this.listeners = list;
            return;
        }
        this.__IM.onSet((Object)this, "listeners", (Object)list);
    }

    Map __getsocketsByUri() {
        if (!this.__FsocketsByUri) {
            return this.socketsByUri;
        }
        return (Map)this.__IM.onGet((Object)this, "socketsByUri");
    }

    void __setsocketsByUri(Map map) {
        if (!this.__FsocketsByUri) {
            this.socketsByUri = map;
            return;
        }
        this.__IM.onSet((Object)this, "socketsByUri", (Object)map);
    }

    Vertx __getvertx() {
        if (!this.__Fvertx) {
            return this.vertx;
        }
        return (Vertx)this.__IM.onGet((Object)this, "vertx");
    }

    void __setvertx(Vertx vertx) {
        if (!this.__Fvertx) {
            this.vertx = vertx;
            return;
        }
        this.__IM.onSet((Object)this, "vertx", (Object)vertx);
    }

    Router __getrouter() {
        if (!this.__Frouter) {
            return this.router;
        }
        return (Router)this.__IM.onGet((Object)this, "router");
    }

    void __setrouter(Router router) {
        if (!this.__Frouter) {
            this.router = router;
            return;
        }
        this.__IM.onSet((Object)this, "router", (Object)router);
    }

    ApplicationConfiguration __getconfiguration() {
        if (!this.__Fconfiguration) {
            return this.configuration;
        }
        return (ApplicationConfiguration)this.__IM.onGet((Object)this, "configuration");
    }

    void __setconfiguration(ApplicationConfiguration applicationConfiguration) {
        if (!this.__Fconfiguration) {
            this.configuration = applicationConfiguration;
            return;
        }
        this.__IM.onSet((Object)this, "configuration", (Object)applicationConfiguration);
    }

    Crypto __getcrypto() {
        if (!this.__Fcrypto) {
            return this.crypto;
        }
        return (Crypto)this.__IM.onGet((Object)this, "crypto");
    }

    void __setcrypto(Crypto crypto) {
        if (!this.__Fcrypto) {
            this.crypto = crypto;
            return;
        }
        this.__IM.onSet((Object)this, "crypto", (Object)crypto);
    }

    ContentEngine __getengine() {
        if (!this.__Fengine) {
            return this.engine;
        }
        return (ContentEngine)this.__IM.onGet((Object)this, "engine");
    }

    void __setengine(ContentEngine contentEngine) {
        if (!this.__Fengine) {
            this.engine = contentEngine;
            return;
        }
        this.__IM.onSet((Object)this, "engine", (Object)contentEngine);
    }

    ManagedExecutorService __getexecutor() {
        if (!this.__Fexecutor) {
            return this.executor;
        }
        return (ManagedExecutorService)this.__IM.onGet((Object)this, "executor");
    }

    void __setexecutor(ManagedExecutorService managedExecutorService) {
        if (!this.__Fexecutor) {
            this.executor = managedExecutorService;
            return;
        }
        this.__IM.onSet((Object)this, "executor", (Object)managedExecutorService);
    }

    Collection __getmappers() {
        if (!this.__Fmappers) {
            return this.mappers;
        }
        return (Collection)this.__IM.onGet((Object)this, "mappers");
    }

    void __setmappers(Collection collection) {
        if (!this.__Fmappers) {
            this.mappers = collection;
            return;
        }
        this.__IM.onSet((Object)this, "mappers", (Object)collection);
    }

    ServiceAccessor __getaccessor() {
        if (!this.__Faccessor) {
            return this.accessor;
        }
        return (ServiceAccessor)this.__IM.onGet((Object)this, "accessor");
    }

    void __setaccessor(ServiceAccessor serviceAccessor) {
        if (!this.__Faccessor) {
            this.accessor = serviceAccessor;
            return;
        }
        this.__IM.onSet((Object)this, "accessor", (Object)serviceAccessor);
    }

    InetAddress __getaddress() {
        if (!this.__Faddress) {
            return this.address;
        }
        return (InetAddress)this.__IM.onGet((Object)this, "address");
    }

    void __setaddress(InetAddress inetAddress) {
        if (!this.__Faddress) {
            this.address = inetAddress;
            return;
        }
        this.__IM.onSet((Object)this, "address", (Object)inetAddress);
    }

    List __getservers() {
        if (!this.__Fservers) {
            return this.servers;
        }
        return (List)this.__IM.onGet((Object)this, "servers");
    }

    void __setservers(List list) {
        if (!this.__Fservers) {
            this.servers = list;
            return;
        }
        this.__IM.onSet((Object)this, "servers", (Object)list);
    }

    public WisdomVertxServer() {
        this(null);
    }

    private WisdomVertxServer(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlisteners(new ArrayList());
        this.__setsocketsByUri(new HashMap());
        this.__setaccessor(new ServiceAccessor(this.__getcrypto(), this.__getconfiguration(), this.__getrouter(), this.__getengine(), this.__getexecutor(), this, this.__getmappers()));
        this.__setservers(new ArrayList(2));
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() {
        LOGGER.info("Starting the vert.x server");
        int httpPort = this.__getaccessor().getConfiguration().getIntegerWithDefault("vertx.http.port", this.__getaccessor().getConfiguration().getIntegerWithDefault("http.port", Integer.valueOf(9000)));
        int httpsPort = this.__getaccessor().getConfiguration().getIntegerWithDefault("vertx.https.port", this.__getaccessor().getConfiguration().getIntegerWithDefault("https.port", Integer.valueOf(-1)));
        this.initializeInetAddress();
        Configuration servers = this.__getconfiguration().getConfiguration("vertx.servers");
        if (servers == null) {
            if (httpPort != -1) {
                LOGGER.info("Configuring default HTTP Server");
                this.__getservers().add(Server.defaultHttp(this.__getaccessor(), this.__getvertx()));
            }
            if (httpsPort != -1) {
                LOGGER.info("Configuring default HTTPS Server");
                this.__getservers().add(Server.defaultHttps(this.__getaccessor(), this.__getvertx()));
            }
        } else {
            for (String name : servers.asMap().keySet()) {
                LOGGER.info("Configuring server {}", (Object)name);
                this.__getservers().add(Server.from(this.__getaccessor(), this.__getvertx(), name, servers.getConfiguration(name)));
            }
        }
        for (Server conf : this.__getservers()) {
            conf.bind();
        }
    }

    private void initializeInetAddress() {
        if (!this.__MinitializeInetAddress) {
            this.__M_initializeInetAddress();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initializeInetAddress", new Object[0]);
            this.__M_initializeInetAddress();
            this.__IM.onExit((Object)this, "initializeInetAddress", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initializeInetAddress", throwable);
            throw throwable;
        }
    }

    private void __M_initializeInetAddress() {
        this.__setaddress(null);
        try {
            if (this.__getaccessor().getConfiguration().get("http.address") != null) {
                this.__setaddress(InetAddress.getByName(this.__getaccessor().getConfiguration().get("http.address")));
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not understand http.address", (Throwable)e);
            this.onError();
        }
    }

    private void onError() {
        if (!this.__MonError) {
            this.__M_onError();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "onError", new Object[0]);
            this.__M_onError();
            this.__IM.onExit((Object)this, "onError", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "onError", throwable);
            throw throwable;
        }
    }

    private void __M_onError() {
        System.exit(-1);
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        this.__getlisteners().clear();
        LOGGER.info("Stopping the vert.x server");
        for (Server configuration : this.__getservers()) {
            configuration.close();
        }
    }

    public String hostname() {
        String string;
        if (!this.__Mhostname) {
            return this.__M_hostname();
        }
        try {
            this.__IM.onEntry((Object)this, "hostname", new Object[0]);
            string = this.__M_hostname();
            this.__IM.onExit((Object)this, "hostname", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "hostname", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_hostname() {
        if (this.__getaddress() == null) {
            return "localhost";
        }
        return this.__getaddress().getHostName();
    }

    public synchronized int httpPort() {
        int n;
        if (!this.__MhttpPort) {
            return this.__M_httpPort();
        }
        try {
            this.__IM.onEntry((Object)this, "httpPort", new Object[0]);
            n = this.__M_httpPort();
            this.__IM.onExit((Object)this, "httpPort", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "httpPort", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_httpPort() {
        for (Server server : this.__getservers()) {
            if (server.ssl()) continue;
            return server.port();
        }
        return -1;
    }

    public synchronized int httpsPort() {
        int n;
        if (!this.__MhttpsPort) {
            return this.__M_httpsPort();
        }
        try {
            this.__IM.onEntry((Object)this, "httpsPort", new Object[0]);
            n = this.__M_httpsPort();
            this.__IM.onExit((Object)this, "httpsPort", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "httpsPort", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_httpsPort() {
        for (Server server : this.__getservers()) {
            if (!server.ssl()) continue;
            return server.port();
        }
        return -1;
    }

    public void publish(String url, String data) {
        if (!this.__Mpublish$java_lang_String$java_lang_String) {
            this.__M_publish(url, data);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "publish$java_lang_String$java_lang_String", new Object[]{url, data});
            this.__M_publish(url, data);
            this.__IM.onExit((Object)this, "publish$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "publish$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_publish(String url, String data) {
        List<Socket> sockets;
        WisdomVertxServer wisdomVertxServer = this;
        synchronized (wisdomVertxServer) {
            List ch = (List)this.__getsocketsByUri().get(url);
            sockets = ch != null ? new ArrayList<Socket>(ch) : Collections.emptyList();
        }
        for (Socket socket : sockets) {
            socket.publish(data, this.__getvertx().eventBus());
        }
    }

    public synchronized void publish(String url, byte[] data) {
        if (!this.__Mpublish$java_lang_String$byte__) {
            this.__M_publish(url, data);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "publish$java_lang_String$byte__", new Object[]{url, data});
            this.__M_publish(url, data);
            this.__IM.onExit((Object)this, "publish$java_lang_String$byte__", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "publish$java_lang_String$byte__", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_publish(String url, byte[] data) {
        List<Socket> sockets;
        WisdomVertxServer wisdomVertxServer = this;
        synchronized (wisdomVertxServer) {
            List ch = (List)this.__getsocketsByUri().get(url);
            sockets = ch != null ? new ArrayList<Socket>(ch) : Collections.emptyList();
        }
        for (Socket socket : sockets) {
            socket.publish(data, this.__getvertx().eventBus());
        }
    }

    public void addSocket(String url, Socket socket) {
        if (!this.__MaddSocket$java_lang_String$org_wisdom_framework_vertx_Socket) {
            this.__M_addSocket(url, socket);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addSocket$java_lang_String$org_wisdom_framework_vertx_Socket", new Object[]{url, socket});
            this.__M_addSocket(url, socket);
            this.__IM.onExit((Object)this, "addSocket$java_lang_String$org_wisdom_framework_vertx_Socket", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addSocket$java_lang_String$org_wisdom_framework_vertx_Socket", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_addSocket(String url, Socket socket) {
        ArrayList webSocketListeners;
        LOGGER.info("Adding web socket on {} bound to {}", (Object)url, (Object)socket);
        WisdomVertxServer wisdomVertxServer = this;
        synchronized (wisdomVertxServer) {
            ArrayList<Socket> channels = (ArrayList<Socket>)this.__getsocketsByUri().get(url);
            if (channels == null) {
                channels = new ArrayList<Socket>();
            }
            channels.add(socket);
            this.__getsocketsByUri().put(url, channels);
            webSocketListeners = new ArrayList(this.__getlisteners());
        }
        for (WebSocketListener listener : webSocketListeners) {
            listener.opened(url, WisdomVertxServer.id(socket));
        }
    }

    public void removeSocket(String url, Socket socket) {
        if (!this.__MremoveSocket$java_lang_String$org_wisdom_framework_vertx_Socket) {
            this.__M_removeSocket(url, socket);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeSocket$java_lang_String$org_wisdom_framework_vertx_Socket", new Object[]{url, socket});
            this.__M_removeSocket(url, socket);
            this.__IM.onExit((Object)this, "removeSocket$java_lang_String$org_wisdom_framework_vertx_Socket", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeSocket$java_lang_String$org_wisdom_framework_vertx_Socket", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_removeSocket(String url, Socket socket) {
        ArrayList webSocketListeners;
        LOGGER.info("Removing web socket on {} bound to {}", (Object)url, (Object)socket.path());
        WisdomVertxServer wisdomVertxServer = this;
        synchronized (wisdomVertxServer) {
            List channels = (List)this.__getsocketsByUri().get(url);
            if (channels != null) {
                channels.remove(socket);
                if (channels.isEmpty()) {
                    this.__getsocketsByUri().remove(url);
                }
            }
            webSocketListeners = new ArrayList(this.__getlisteners());
        }
        for (WebSocketListener listener : webSocketListeners) {
            listener.closed(url, WisdomVertxServer.id(socket));
        }
    }

    public void register(WebSocketListener listener) {
        if (!this.__Mregister$org_wisdom_api_http_websockets_WebSocketListener) {
            this.__M_register(listener);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "register$org_wisdom_api_http_websockets_WebSocketListener", new Object[]{listener});
            this.__M_register(listener);
            this.__IM.onExit((Object)this, "register$org_wisdom_api_http_websockets_WebSocketListener", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "register$org_wisdom_api_http_websockets_WebSocketListener", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_register(WebSocketListener listener) {
        HashMap copy;
        WisdomVertxServer wisdomVertxServer = this;
        synchronized (wisdomVertxServer) {
            this.__getlisteners().add(listener);
            copy = new HashMap(this.__getsocketsByUri());
        }
        for (Map.Entry entry : copy.entrySet()) {
            for (Socket client : (List)entry.getValue()) {
                listener.opened((String)entry.getKey(), WisdomVertxServer.id(client));
            }
        }
    }

    public void unregister(WebSocketListener listener) {
        if (!this.__Munregister$org_wisdom_api_http_websockets_WebSocketListener) {
            this.__M_unregister(listener);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unregister$org_wisdom_api_http_websockets_WebSocketListener", new Object[]{listener});
            this.__M_unregister(listener);
            this.__IM.onExit((Object)this, "unregister$org_wisdom_api_http_websockets_WebSocketListener", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unregister$org_wisdom_api_http_websockets_WebSocketListener", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_unregister(WebSocketListener listener) {
        WisdomVertxServer wisdomVertxServer = this;
        synchronized (wisdomVertxServer) {
            this.__getlisteners().remove(listener);
        }
    }

    public void send(String uri, String client, String message) {
        if (!this.__Msend$java_lang_String$java_lang_String$java_lang_String) {
            this.__M_send(uri, client, message);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "send$java_lang_String$java_lang_String$java_lang_String", new Object[]{uri, client, message});
            this.__M_send(uri, client, message);
            this.__IM.onExit((Object)this, "send$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "send$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_send(String uri, String client, String message) {
        List<Socket> sockets;
        WisdomVertxServer wisdomVertxServer = this;
        synchronized (wisdomVertxServer) {
            List ch = (List)this.__getsocketsByUri().get(uri);
            sockets = ch != null ? new ArrayList<Socket>(ch) : Collections.emptyList();
        }
        for (Socket socket : sockets) {
            if (!client.equals(WisdomVertxServer.id(socket))) continue;
            socket.publish(message, this.__getvertx().eventBus());
        }
    }

    static String id(Socket socket) {
        return Integer.toOctalString(socket.hashCode());
    }

    public void send(String uri, String client, byte[] message) {
        if (!this.__Msend$java_lang_String$java_lang_String$byte__) {
            this.__M_send(uri, client, message);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "send$java_lang_String$java_lang_String$byte__", new Object[]{uri, client, message});
            this.__M_send(uri, client, message);
            this.__IM.onExit((Object)this, "send$java_lang_String$java_lang_String$byte__", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "send$java_lang_String$java_lang_String$byte__", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_send(String uri, String client, byte[] message) {
        List<Socket> sockets;
        WisdomVertxServer wisdomVertxServer = this;
        synchronized (wisdomVertxServer) {
            List ch = (List)this.__getsocketsByUri().get(uri);
            sockets = ch != null ? new ArrayList<Socket>(ch) : Collections.emptyList();
        }
        for (Socket socket : sockets) {
            if (!client.equals(WisdomVertxServer.id(socket))) continue;
            socket.publish(message, this.__getvertx().eventBus());
        }
    }

    public void received(String uri, byte[] content, Socket socket) {
        if (!this.__Mreceived$java_lang_String$byte__$org_wisdom_framework_vertx_Socket) {
            this.__M_received(uri, content, socket);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "received$java_lang_String$byte__$org_wisdom_framework_vertx_Socket", new Object[]{uri, content, socket});
            this.__M_received(uri, content, socket);
            this.__IM.onExit((Object)this, "received$java_lang_String$byte__$org_wisdom_framework_vertx_Socket", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "received$java_lang_String$byte__$org_wisdom_framework_vertx_Socket", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_received(String uri, byte[] content, Socket socket) {
        ArrayList localListeners;
        WisdomVertxServer wisdomVertxServer = this;
        synchronized (wisdomVertxServer) {
            localListeners = new ArrayList(this.__getlisteners());
        }
        for (WebSocketListener listener : localListeners) {
            listener.received(uri, WisdomVertxServer.id(socket), content);
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("accessor")) {
                this.__Faccessor = true;
            }
            if (set.contains("address")) {
                this.__Faddress = true;
            }
            if (set.contains("configuration")) {
                this.__Fconfiguration = true;
            }
            if (set.contains("crypto")) {
                this.__Fcrypto = true;
            }
            if (set.contains("engine")) {
                this.__Fengine = true;
            }
            if (set.contains("executor")) {
                this.__Fexecutor = true;
            }
            if (set.contains("listeners")) {
                this.__Flisteners = true;
            }
            if (set.contains("mappers")) {
                this.__Fmappers = true;
            }
            if (set.contains("router")) {
                this.__Frouter = true;
            }
            if (set.contains("servers")) {
                this.__Fservers = true;
            }
            if (set.contains("socketsByUri")) {
                this.__FsocketsByUri = true;
            }
            if (set.contains("vertx")) {
                this.__Fvertx = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("initializeInetAddress")) {
                this.__MinitializeInetAddress = true;
            }
            if (set.contains("onError")) {
                this.__MonError = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("hostname")) {
                this.__Mhostname = true;
            }
            if (set.contains("httpPort")) {
                this.__MhttpPort = true;
            }
            if (set.contains("httpsPort")) {
                this.__MhttpsPort = true;
            }
            if (set.contains("publish$java_lang_String$java_lang_String")) {
                this.__Mpublish$java_lang_String$java_lang_String = true;
            }
            if (set.contains("publish$java_lang_String$byte__")) {
                this.__Mpublish$java_lang_String$byte__ = true;
            }
            if (set.contains("addSocket$java_lang_String$org_wisdom_framework_vertx_Socket")) {
                this.__MaddSocket$java_lang_String$org_wisdom_framework_vertx_Socket = true;
            }
            if (set.contains("removeSocket$java_lang_String$org_wisdom_framework_vertx_Socket")) {
                this.__MremoveSocket$java_lang_String$org_wisdom_framework_vertx_Socket = true;
            }
            if (set.contains("register$org_wisdom_api_http_websockets_WebSocketListener")) {
                this.__Mregister$org_wisdom_api_http_websockets_WebSocketListener = true;
            }
            if (set.contains("unregister$org_wisdom_api_http_websockets_WebSocketListener")) {
                this.__Munregister$org_wisdom_api_http_websockets_WebSocketListener = true;
            }
            if (set.contains("send$java_lang_String$java_lang_String$java_lang_String")) {
                this.__Msend$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("send$java_lang_String$java_lang_String$byte__")) {
                this.__Msend$java_lang_String$java_lang_String$byte__ = true;
            }
            if (set.contains("received$java_lang_String$byte__$org_wisdom_framework_vertx_Socket")) {
                this.__Mreceived$java_lang_String$byte__$org_wisdom_framework_vertx_Socket = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

