/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx.cookies;

import com.google.common.base.Preconditions;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.DefaultCookie;
import org.wisdom.api.cookies.Cookie;
import org.wisdom.api.cookies.Cookies;

public class CookieHelper {
    private static final String PATH = ", path=";

    private CookieHelper() {
    }

    public static Cookie convertWisdomCookieToNettyCookie(org.wisdom.api.cookies.Cookie cookie) {
        DefaultCookie nettyCookie = new DefaultCookie(cookie.name(), cookie.value());
        nettyCookie.setMaxAge(cookie.maxAge());
        if (cookie.comment() != null) {
            nettyCookie.setComment(cookie.comment());
        }
        if (cookie.domain() != null) {
            nettyCookie.setDomain(cookie.domain());
        }
        if (cookie.isSecure()) {
            nettyCookie.setSecure(true);
        }
        if (cookie.path() != null) {
            nettyCookie.setPath(cookie.path());
        }
        if (cookie.isHttpOnly()) {
            nettyCookie.setHttpOnly(true);
        }
        return nettyCookie;
    }

    public static org.wisdom.api.cookies.Cookie convertNettyCookieToWisdomCookie(Cookie cookie) {
        Preconditions.checkNotNull((Object)cookie);
        String value = cookie.getValue();
        if (value.contains(PATH)) {
            value = value.substring(0, value.indexOf(PATH));
        }
        Cookie.Builder builder = org.wisdom.api.cookies.Cookie.builder((String)cookie.getName(), (String)value);
        builder.setMaxAge(cookie.getMaxAge());
        if (cookie.getComment() != null) {
            builder.setComment(cookie.getComment());
        }
        if (cookie.getDomain() != null) {
            builder.setDomain(cookie.getDomain());
        }
        builder.setSecure(cookie.isSecure());
        if (cookie.getPath() != null) {
            builder.setPath(cookie.getPath());
        }
        builder.setHttpOnly(cookie.isHttpOnly());
        return builder.build();
    }

    public static String getCookieValue(String name, Cookies cookies) {
        org.wisdom.api.cookies.Cookie c = cookies.get(name);
        if (c != null) {
            return c.value();
        }
        return null;
    }
}

