/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx.cookies;

import com.google.common.collect.Maps;
import io.netty.handler.codec.http.CookieDecoder;
import java.util.Map;
import java.util.Set;
import org.vertx.java.core.http.HttpServerRequest;
import org.wisdom.api.cookies.Cookie;
import org.wisdom.api.cookies.Cookies;
import org.wisdom.framework.vertx.cookies.CookieHelper;

public class CookiesImpl
implements Cookies {
    private Map<String, Cookie> cookies = Maps.newTreeMap();

    public CookiesImpl(HttpServerRequest request) {
        String value = request.headers().get("Cookie");
        if (value != null) {
            Set localCookies = CookieDecoder.decode((String)value);
            for (io.netty.handler.codec.http.Cookie cookie : localCookies) {
                this.cookies.put(cookie.getName(), CookieHelper.convertNettyCookieToWisdomCookie(cookie));
            }
        }
    }

    public Cookie get(String name) {
        return this.cookies.get(name);
    }
}

