/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.vertx.cookies;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.cookies.Cookie;
import org.wisdom.api.cookies.SessionCookie;
import org.wisdom.api.crypto.Crypto;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.Result;
import org.wisdom.api.utils.CookieDataCodec;

public class SessionCookieImpl
implements SessionCookie {
    public static final String SESSION_SUFFIX = "_SESSION";
    private static final String ID_KEY = "___ID";
    private static final String TIMESTAMP_KEY = "___TS";
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionCookieImpl.class);
    private final Integer sessionExpireTimeInMs;
    private final Boolean sessionSendOnlyIfChanged;
    private final Boolean sessionTransferredOverHttpsOnly;
    private final Boolean sessionHttpOnly;
    private final String applicationCookiePrefix;
    private final Map<String, String> data = new HashMap<String, String>();
    private final Crypto crypto;
    private boolean sessionDataHasBeenChanged = false;

    public SessionCookieImpl(Crypto crypto, ApplicationConfiguration configuration) {
        this.applicationCookiePrefix = configuration.getWithDefault("application.cookie.prefix", "wisdom");
        this.crypto = crypto;
        this.sessionExpireTimeInMs = configuration.getIntegerWithDefault("application.session.expire_time_in_seconds", Integer.valueOf(3600)) * 1000;
        this.sessionSendOnlyIfChanged = configuration.getBooleanWithDefault("application.session.send_only_if_changed", Boolean.valueOf(true));
        this.sessionTransferredOverHttpsOnly = configuration.getBooleanWithDefault("application.session.transferred_over_https_only", Boolean.valueOf(false));
        this.sessionHttpOnly = configuration.getBooleanWithDefault("application.session.http_only", Boolean.valueOf(true));
    }

    public void init(Context context) {
        try {
            Cookie cookie = context.request().cookie(this.applicationCookiePrefix + SESSION_SUFFIX);
            if (cookie != null && cookie.value() != null && !"".equals(cookie.value().trim()) && cookie.value().contains("-")) {
                String payload;
                String value = cookie.value();
                String sign = value.substring(0, value.indexOf(45));
                if (CookieDataCodec.safeEquals((String)sign, (String)this.crypto.sign(payload = value.substring(value.indexOf(45) + 1)))) {
                    CookieDataCodec.decode(this.data, (String)payload);
                } else {
                    LOGGER.warn("Invalid session cookie - signature check failed");
                }
                if (!this.data.containsKey(TIMESTAMP_KEY)) {
                    this.data.clear();
                } else if (Long.parseLong(this.data.get(TIMESTAMP_KEY)) + (long)this.sessionExpireTimeInMs.intValue() < System.currentTimeMillis()) {
                    this.sessionDataHasBeenChanged = true;
                    this.data.clear();
                }
                this.data.put(TIMESTAMP_KEY, Long.toString(System.currentTimeMillis()));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.error("Encoding exception - this must not happen", (Throwable)unsupportedEncodingException);
        }
    }

    public String getId() {
        if (!this.data.containsKey(ID_KEY)) {
            this.data.put(ID_KEY, UUID.randomUUID().toString());
        }
        return this.data.get(ID_KEY);
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public void save(Context context, Result result) {
        if (!this.sessionDataHasBeenChanged && this.sessionSendOnlyIfChanged.booleanValue()) {
            return;
        }
        if (this.isEmpty()) {
            if (context.hasCookie(this.applicationCookiePrefix + SESSION_SUFFIX)) {
                Cookie.Builder expiredSessionCookie = Cookie.builder((String)(this.applicationCookiePrefix + SESSION_SUFFIX), (String)"");
                expiredSessionCookie.setPath("/");
                expiredSessionCookie.setMaxAge(0L);
                result.with(expiredSessionCookie.build());
            }
            return;
        }
        if (!this.data.containsKey(TIMESTAMP_KEY)) {
            this.data.put(TIMESTAMP_KEY, Long.toString(System.currentTimeMillis()));
        }
        try {
            String sessionData = CookieDataCodec.encode(this.data);
            String sign = this.crypto.sign(sessionData);
            Cookie.Builder cookie = Cookie.builder((String)(this.applicationCookiePrefix + SESSION_SUFFIX), (String)(sign + "-" + sessionData));
            cookie.setPath("/");
            cookie.setMaxAge((long)(this.sessionExpireTimeInMs / 1000));
            if (this.sessionTransferredOverHttpsOnly != null) {
                cookie.setSecure(this.sessionTransferredOverHttpsOnly.booleanValue());
            }
            if (this.sessionHttpOnly != null) {
                cookie.setHttpOnly(this.sessionHttpOnly.booleanValue());
            }
            result.with(cookie.build());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.error("Encoding exception - this must not happen", (Throwable)unsupportedEncodingException);
        }
    }

    public void put(String key, String value) {
        if (key.contains(":")) {
            throw new IllegalArgumentException("Character ':' is invalid in a session key.");
        }
        this.sessionDataHasBeenChanged = true;
        if (value == null) {
            this.remove(key);
        } else {
            this.data.put(key, value);
        }
    }

    public String get(String key) {
        return this.data.get(key);
    }

    public String remove(String key) {
        this.sessionDataHasBeenChanged = true;
        String result = this.get(key);
        this.data.remove(key);
        return result;
    }

    public void clear() {
        this.sessionDataHasBeenChanged = true;
        this.data.clear();
    }

    public boolean isEmpty() {
        return this.data.isEmpty() || this.data.size() == 1 && this.data.containsKey(TIMESTAMP_KEY);
    }
}

